/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModel;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModelRoot {
    private String name = null;
    private LogicModel logicModel = null;
    private WizardDisplayModel wizardDisplayModel = null;
    private ExpertDisplayModel expertDisplayModel = null;
    static /* synthetic */ Class class$ch$dvbern$tax$common$engine$ModelRoot;

    public ModelRoot(String name, LogicModel logicModel, WizardDisplayModel wizardDisplayModel, ExpertDisplayModel expertDisplayModel) {
        this.name = name;
        this.logicModel = logicModel;
        this.wizardDisplayModel = wizardDisplayModel;
        this.expertDisplayModel = expertDisplayModel;
    }

    public String getName() {
        return this.name;
    }

    public LogicModel getLogicModel() {
        return this.logicModel;
    }

    public WizardDisplayModel getWizardDisplayModel() {
        return this.wizardDisplayModel;
    }

    public ExpertDisplayModel getExpertDisplayModel() {
        return this.expertDisplayModel;
    }

    public void initializeLogicModel(Map logicModelItems, List persistenceReadDTOs, boolean verbose) throws InvalidModelException {
        if (this.name == null || this.name.length() == 0) {
            throw new InvalidModelException("No name specified for TMO model!");
        }
        this.logicModel.initializeLogicModel(logicModelItems, persistenceReadDTOs, verbose);
    }

    public void initializeReferences(Map lm) throws InvalidModelException {
        this.logicModel.initializeReferences(lm);
    }

    public void initializeWizardDisplayModel(Map logicModelItems, Map wizardDisplayModelItems) throws InvalidModelException {
        this.wizardDisplayModel.initializeWizardDisplayModel(logicModelItems, wizardDisplayModelItems);
    }

    public void initializeExpertDisplayModel(Map logicModelItems) throws InvalidModelException {
        this.expertDisplayModel.initializeExpertDisplayModel(logicModelItems);
    }

    public static class XMLFactory
    implements ElementParser {
        public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            LogicModel logicModel = null;
            WizardDisplayModel wizardDisplayModel = null;
            ExpertDisplayModel expertDisplayModel = null;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                Element subElement = (Element)i.next();
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LogicModel) {
                        logicModel = (LogicModel)ref;
                        continue;
                    }
                    if (ref instanceof WizardDisplayModel) {
                        wizardDisplayModel = (WizardDisplayModel)ref;
                        continue;
                    }
                    if (ref instanceof ExpertDisplayModel) {
                        expertDisplayModel = (ExpertDisplayModel)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + ref);
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), pnre);
                }
            }
            return new ClassObjectPair(class$ch$dvbern$tax$common$engine$ModelRoot == null ? (class$ch$dvbern$tax$common$engine$ModelRoot = ModelRoot.class$("ch.dvbern.tax.common.engine.ModelRoot")) : class$ch$dvbern$tax$common$engine$ModelRoot, new ModelRoot(element.getAttributeValue("name"), logicModel, wizardDisplayModel, expertDisplayModel));
        }
    }
}

