/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.lib.resource.construct.ConstructionException;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ParserAlreadyRegisteredException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ResourceChangeListener;
import ch.dvbern.lib.resource.construct.xml.ResourceLocator;
import ch.dvbern.lib.resource.construct.xml.ResourceNotFoundException;
import ch.dvbern.lib.resource.construct.xml.XMLObjectConstructor;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.DataResourceImpl;
import ch.dvbern.tax.common.engine.DebugItem;
import ch.dvbern.tax.common.engine.ExpertUpdatePreprocessor;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModel;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.ModelRoot;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.calcitems.AND;
import ch.dvbern.tax.common.engine.calcitems.Abs;
import ch.dvbern.tax.common.engine.calcitems.AbsRef;
import ch.dvbern.tax.common.engine.calcitems.Concat;
import ch.dvbern.tax.common.engine.calcitems.Constant;
import ch.dvbern.tax.common.engine.calcitems.Divide;
import ch.dvbern.tax.common.engine.calcitems.Equals;
import ch.dvbern.tax.common.engine.calcitems.Greater;
import ch.dvbern.tax.common.engine.calcitems.GreaterWithNullAsZero;
import ch.dvbern.tax.common.engine.calcitems.IsNull;
import ch.dvbern.tax.common.engine.calcitems.IsNullOrZero;
import ch.dvbern.tax.common.engine.calcitems.Length;
import ch.dvbern.tax.common.engine.calcitems.MaxValue;
import ch.dvbern.tax.common.engine.calcitems.MinValue;
import ch.dvbern.tax.common.engine.calcitems.Minus;
import ch.dvbern.tax.common.engine.calcitems.Modulo;
import ch.dvbern.tax.common.engine.calcitems.Multiply;
import ch.dvbern.tax.common.engine.calcitems.NOT;
import ch.dvbern.tax.common.engine.calcitems.NotEquals;
import ch.dvbern.tax.common.engine.calcitems.Null;
import ch.dvbern.tax.common.engine.calcitems.OR;
import ch.dvbern.tax.common.engine.calcitems.Opposite;
import ch.dvbern.tax.common.engine.calcitems.Percent;
import ch.dvbern.tax.common.engine.calcitems.Plus;
import ch.dvbern.tax.common.engine.calcitems.Power;
import ch.dvbern.tax.common.engine.calcitems.RelRef;
import ch.dvbern.tax.common.engine.calcitems.Round;
import ch.dvbern.tax.common.engine.calcitems.RoundFiveCents;
import ch.dvbern.tax.common.engine.calcitems.Smaller;
import ch.dvbern.tax.common.engine.calcitems.SmallerWithNullAsZero;
import ch.dvbern.tax.common.engine.calcitems.Summe;
import ch.dvbern.tax.common.engine.calcitems.ToString;
import ch.dvbern.tax.common.engine.calcitems.TruncateToMax;
import ch.dvbern.tax.common.engine.calcitems.ValueIfEqual;
import ch.dvbern.tax.common.engine.calcitems.ValueIfTrue;
import ch.dvbern.tax.common.engine.calcitems.ValuesIfEqual;
import ch.dvbern.tax.common.engine.calcitems.ValuesIfTrue;
import ch.dvbern.tax.common.engine.calcitems.YearFromDate;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode1DItem;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DContainerItem;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DXMLFactory;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertButtonItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelAddOn;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLinkItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListIteratorItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListLabelRowItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListValueRowItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertNavigationItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertTableColumn;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertTableItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertTableMerge;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertValueItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertWizardLinkItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExtraPagesSumItem;
import ch.dvbern.tax.common.engine.expertdisplay.FontXMLFactory;
import ch.dvbern.tax.common.engine.expertdisplay.ImageXMLFactory;
import ch.dvbern.tax.common.engine.expertdisplay.PatternXMLFactory;
import ch.dvbern.tax.common.engine.expertdisplay.RectangleXMLFactory;
import ch.dvbern.tax.common.engine.expertdisplay.ValuePositionXMLFactory;
import ch.dvbern.tax.common.engine.modelitems.Bool;
import ch.dvbern.tax.common.engine.modelitems.Calc;
import ch.dvbern.tax.common.engine.modelitems.CalcInteger;
import ch.dvbern.tax.common.engine.modelitems.Module;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.modelitems.Table;
import ch.dvbern.tax.common.engine.modelitems.TableConcat;
import ch.dvbern.tax.common.engine.modelitems.TableSum;
import ch.dvbern.tax.common.engine.modelitems.Text;
import ch.dvbern.tax.common.engine.modelitems.Value;
import ch.dvbern.tax.common.engine.modelitems.optionitems.ListOptionItem;
import ch.dvbern.tax.common.engine.modelitems.optionitems.SimpleOptionItem;
import ch.dvbern.tax.common.engine.modelitems.optionitems.TableOptionItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.validators.AutoSetDefault;
import ch.dvbern.tax.common.engine.validators.Delete;
import ch.dvbern.tax.common.engine.validators.Disabled;
import ch.dvbern.tax.common.engine.validators.Falsify;
import ch.dvbern.tax.common.engine.validators.GenericValidator;
import ch.dvbern.tax.common.engine.validators.Mandatory;
import ch.dvbern.tax.common.engine.validators.Max;
import ch.dvbern.tax.common.engine.validators.Min;
import ch.dvbern.tax.common.engine.validators.NoInput;
import ch.dvbern.tax.common.engine.validators.NotNegative;
import ch.dvbern.tax.common.engine.validators.Transparent;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModel;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.BR;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Button;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Col;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Header;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Help;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Item;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Label;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Link;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.RowIterator;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Table;
import ch.dvbern.tax.common.engine.wizarddisplay.items.TableMerge;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.PersistenceReadDTO;
import ch.dvbern.tax.common.transfer.dto.UpdateResultDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Engine {
    public static final int CALLER_DEFAULT = 0;
    public static final int CALLER_CD = 1;
    public static final int CALLER_ONLINE = 2;
    private static final Logger log = Logger.getLogger((Class)Engine.class);
    private static Map engines = Collections.synchronizedMap(new HashMap());
    private ModelRoot modelRoot = null;
    private Map logicModelItems = new HashMap();
    private Map wizardDisplayModelItems = new HashMap();
    private List persistenceReadDTOs = new ArrayList();
    private ExpertUpdatePreprocessor expertUpdatePreprocessor = null;
    private int caller = 0;
    private static final String JAMON_KEY_ENGINE_UPDATE = Engine.class.getName() + ".update(Map.Entry, ProtectedMap)";

    private Engine(String xmlStructure, DataResource dataResource, boolean verbose) throws ConstructionException {
        CustomResourceLocator locator = new CustomResourceLocator(xmlStructure);
        ParserFactory factory = new ParserFactory(locator);
        try {
            factory.registerParser("logic-model", new LogicModel.XMLFactory());
            factory.registerParser("module", new Module.XMLFactory());
            factory.registerParser("table", new Table.XMLFactory());
            factory.registerParser("value", new Value.XMLFactory());
            factory.registerParser("calc", new Calc.XMLFactory());
            factory.registerParser("calc-integer", new CalcInteger.XMLFactory());
            factory.registerParser("plus", new Plus.XMLFactory());
            factory.registerParser("length", new Length.XMLFactory());
            factory.registerParser("minus", new Minus.XMLFactory());
            factory.registerParser("power", new Power.XMLFactory());
            factory.registerParser("abs", new Abs.XMLFactory());
            factory.registerParser("summe", new Summe.XMLFactory());
            factory.registerParser("equals", new Equals.XMLFactory());
            factory.registerParser("not-equals", new NotEquals.XMLFactory());
            factory.registerParser("rel-ref", new RelRef.XMLFactory());
            factory.registerParser("abs-ref", new AbsRef.XMLFactory());
            factory.registerParser("table-sum", new TableSum.XMLFactory());
            factory.registerParser("table-concat", new TableConcat.XMLFactory());
            factory.registerParser("max", new Max.XMLFactory());
            factory.registerParser("min", new Min.XMLFactory());
            factory.registerParser("constant", new Constant.XMLFactory(dataResource));
            factory.registerParser("mandatory", new Mandatory.XMLFactory());
            factory.registerParser("generic-validator", new GenericValidator.XMLFactory());
            factory.registerParser("disabled-if-true", new Disabled.XMLFactory(true));
            factory.registerParser("disabled-if-false", new Disabled.XMLFactory(false));
            factory.registerParser("transparent-if-true", new Transparent.XMLFactory(true));
            factory.registerParser("transparent-if-false", new Transparent.XMLFactory(false));
            factory.registerParser("text", new Text.XMLFactory());
            factory.registerParser("bool", new Bool.XMLFactory());
            factory.registerParser("multiply", new Multiply.XMLFactory());
            factory.registerParser("divide", new Divide.XMLFactory());
            factory.registerParser("modulo", new Modulo.XMLFactory());
            factory.registerParser("percent", new Percent.XMLFactory());
            factory.registerParser("not-negative", new NotNegative.XMLFactory());
            factory.registerParser("select", new Select.XMLFactory());
            factory.registerParser("option-item", new SimpleOptionItem.XMLFactory());
            factory.registerParser("list-option", new ListOptionItem.XMLFactory());
            factory.registerParser("table-option", new TableOptionItem.XMLFactory());
            factory.registerParser("data-resource", new DataResourceImpl.XMLFactory(dataResource));
            factory.registerParser("model-root", new ModelRoot.XMLFactory());
            factory.registerParser("and", new AND.XMLFactory());
            factory.registerParser("or", new OR.XMLFactory());
            factory.registerParser("opposite", new Opposite.XMLFactory());
            factory.registerParser("max-value", new MaxValue.XMLFactory());
            factory.registerParser("min-value", new MinValue.XMLFactory());
            factory.registerParser("delete-if-true", new Delete.XMLFactory(true));
            factory.registerParser("delete-if-false", new Delete.XMLFactory(false));
            factory.registerParser("is-null", new IsNull.XMLFactory(true));
            factory.registerParser("not-null", new IsNull.XMLFactory(false));
            factory.registerParser("is-null-or-zero", new IsNullOrZero.XMLFactory(true));
            factory.registerParser("not-null-or-zero", new IsNullOrZero.XMLFactory(false));
            factory.registerParser("greater", new Greater.XMLFactory());
            factory.registerParser("values-if-true", new ValuesIfTrue.XMLFactory(true));
            factory.registerParser("values-if-false", new ValuesIfTrue.XMLFactory(false));
            factory.registerParser("value-if-true", new ValueIfTrue.XMLFactory(true));
            factory.registerParser("value-if-false", new ValueIfTrue.XMLFactory(false));
            factory.registerParser("not", new NOT.XMLFactory());
            factory.registerParser("to-string", new ToString.XMLFactory());
            factory.registerParser("values-if-equal", new ValuesIfEqual.XMLFactory());
            factory.registerParser("value-if-equal", new ValueIfEqual.XMLFactory());
            factory.registerParser("smaller", new Smaller.XMLFactory());
            factory.registerParser("year-from-date", new YearFromDate.XMLFactory());
            factory.registerParser("null-value", new Null.XMLFactory());
            factory.registerParser("no-input", new NoInput.XMLFactory());
            factory.registerParser("falsify-if-true", new Falsify.XMLFactory(true));
            factory.registerParser("falsify-if-false", new Falsify.XMLFactory(false));
            factory.registerParser("auto-set-default", new AutoSetDefault.XMLFactory());
            factory.registerParser("truncate-to-max", new TruncateToMax.XMLFactory());
            factory.registerParser("concat", new Concat.XMLFactory());
            factory.registerParser("round", new Round.XMLFactory());
            factory.registerParser("round-five", new RoundFiveCents.XMLFactory());
            factory.registerParser("debug", new DebugItem.XMLFactory());
            factory.registerParser("greater-null-as-zero", new GreaterWithNullAsZero.XMLFactory());
            factory.registerParser("smaller-null-as-zero", new SmallerWithNullAsZero.XMLFactory());
            factory.registerParser("wizard-display-model", new WizardDisplayModel.XMLFactory());
            factory.registerParser("w-form", new Form.XMLFactory());
            factory.registerParser("w-section", new Section.XMLFactory());
            factory.registerParser("w-col-def", new ColDef.XMLFactory());
            factory.registerParser("w-help", new Help.XMLFactory());
            factory.registerParser("w-row", new Row.XMLFactory());
            factory.registerParser("w-row-iterator", new RowIterator.XMLFactory());
            factory.registerParser("w-label", new Label.XMLFactory());
            factory.registerParser("w-button", new Button.XMLFactory());
            factory.registerParser("w-link", new Link.XMLFactory());
            factory.registerParser("w-item", new Item.XMLFactory());
            factory.registerParser("w-table", new Table.XMLFactory());
            factory.registerParser("w-table-merge", new TableMerge.XMLFactory());
            factory.registerParser("w-col", new Col.XMLFactory());
            factory.registerParser("w-br", new BR.XMLFactory());
            factory.registerParser("w-header", new Header.XMLFactory());
            factory.registerParser("w-label-add-on", new LabelAddOn.XMLFactory());
            factory.registerParser("expert-display-model", new ExpertDisplayModel.XMLFactory());
            factory.registerParser("e-button", new ExpertButtonItem.XMLFactory());
            factory.registerParser("e-navigation", new ExpertNavigationItem.XMLFactory());
            factory.registerParser("e-form", new ExpertFormItem.XMLFactory());
            factory.registerParser("e-label-add-on", new ExpertLabelAddOn.XMLFactory());
            factory.registerParser("e-label", new ExpertLabelItem.XMLFactory());
            factory.registerParser("e-table-col", new ExpertTableColumn.XMLFactory());
            factory.registerParser("e-table", new ExpertTableItem.XMLFactory());
            factory.registerParser("e-table-merge", new ExpertTableMerge.XMLFactory());
            factory.registerParser("e-value", new ExpertValueItem.XMLFactory());
            factory.registerParser("e-value-pos", new ValuePositionXMLFactory());
            factory.registerParser("e-image", new ImageXMLFactory());
            factory.registerParser("e-font", new FontXMLFactory());
            factory.registerParser("e-table-font", new FontXMLFactory());
            factory.registerParser("e-table-header-font", new FontXMLFactory());
            factory.registerParser("e-table-title-font", new FontXMLFactory());
            factory.registerParser("e-table-title-pattern", new PatternXMLFactory());
            factory.registerParser("e-link", new ExpertLinkItem.XMLFactory());
            factory.registerParser("e-barcode", new Barcode1DItem.XMLFactory());
            factory.registerParser("e-barcode2d-container", new Barcode2DContainerItem.XMLFactory());
            factory.registerParser("e-barcode2d", new Barcode2DXMLFactory());
            factory.registerParser("e-rectangle", new RectangleXMLFactory());
            factory.registerParser("e-list", new ExpertListItem.XMLFactory());
            factory.registerParser("e-list-label", new ExpertListLabelRowItem.XMLFactory());
            factory.registerParser("e-list-value", new ExpertListValueRowItem.XMLFactory());
            factory.registerParser("e-list-iterator", new ExpertListIteratorItem.XMLFactory());
            factory.registerParser("e-extra-pages-sum", new ExtraPagesSumItem.XMLFactory());
            factory.registerParser("e-wizard-link", new ExpertWizardLinkItem.XMLFactory());
            factory.registerParser("e-navigation-desc-add-on", new ExpertLabelAddOn.XMLFactory());
        }
        catch (ParserAlreadyRegisteredException pare) {
            throw new ConstructionException(pare);
        }
        XMLObjectConstructor constructor = new XMLObjectConstructor(factory);
        this.modelRoot = (ModelRoot)constructor.construct("<not a file input>", false);
        try {
            this.modelRoot.initializeLogicModel(this.logicModelItems, this.persistenceReadDTOs, verbose);
            this.modelRoot.initializeReferences(this.logicModelItems);
            this.modelRoot.initializeWizardDisplayModel(this.logicModelItems, this.wizardDisplayModelItems);
            this.modelRoot.initializeExpertDisplayModel(this.logicModelItems);
            this.expertUpdatePreprocessor = new ExpertUpdatePreprocessor(this.modelRoot.getLogicModel(), this.logicModelItems);
        }
        catch (InvalidModelException ime) {
            throw new ConstructionException(ime);
        }
    }

    public List getPersistenceReadDTOs() {
        return this.persistenceReadDTOs;
    }

    public List getPersistenceReadDTOs(String dataModelKey) {
        String dmk = EngineUtil.removeTableIndices(dataModelKey);
        ArrayList<PersistenceReadDTO> result = new ArrayList<PersistenceReadDTO>();
        Iterator iterator = this.persistenceReadDTOs.iterator();
        while (iterator.hasNext()) {
            PersistenceReadDTO prDTO = (PersistenceReadDTO)iterator.next();
            String logicModelKey = prDTO.getDataModelKeyTemplate().replaceAll("\\#\\.", "");
            if (!logicModelKey.startsWith(dmk)) continue;
            result.add(prDTO);
        }
        return result;
    }

    public Map initializeDefaultValues(Map dataModel) {
        LogicModelItem.ProtectedMap dataModelMap = new LogicModelItem.ProtectedMap(dataModel, true);
        Iterator i = this.modelRoot.getLogicModel().getModuls().iterator();
        while (i.hasNext()) {
            LogicModelItem lmi = (LogicModelItem)i.next();
            lmi.initializeDefaultValues(dataModelMap, "");
        }
        return dataModelMap.getChangedMap();
    }

    public UpdateResultDTO update(Map dataModel, Map newValues, boolean allowDelete) {
        LogicModelItem.ProtectedMap dataModelMap = new LogicModelItem.ProtectedMap(dataModel, allowDelete);
        Iterator i = newValues.entrySet().iterator();
        while (i.hasNext()) {
            this.update(i.next(), dataModelMap);
        }
        this.processAsyncUpdates(dataModelMap);
        return new UpdateResultDTO(dataModelMap.getChangedMap(), dataModelMap.getUndoInfoMap(), dataModelMap.getDeleteWarnings(), dataModelMap.getTableUpdates());
    }

    public UpdateResultDTO importData(Map dataModel, Map newValues, boolean allowDelete) {
        LogicModelItem.ProtectedMap dataModelMap = new LogicModelItem.ProtectedMap(dataModel, allowDelete);
        dataModelMap.setRecalculating(true);
        Iterator i = newValues.entrySet().iterator();
        while (i.hasNext()) {
            this.update(i.next(), dataModelMap);
        }
        this.processAsyncUpdates(dataModelMap);
        return new UpdateResultDTO(dataModelMap.getChangedMap(), dataModelMap.getUndoInfoMap(), dataModelMap.getDeleteWarnings(), dataModelMap.getTableUpdates());
    }

    private void processAsyncUpdates(LogicModelItem.ProtectedMap dataModelMap) {
        Map asyncUpdates = dataModelMap.getAsyncUpdates();
        while (!asyncUpdates.isEmpty()) {
            Set entries = asyncUpdates.entrySet();
            Map.Entry asyncUpdate = entries.iterator().next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing async update dmk=" + asyncUpdate.getKey() + " updates left=" + asyncUpdates.size()));
            }
            this.update(asyncUpdate, dataModelMap);
            asyncUpdates.remove(asyncUpdate.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Map.Entry me, LogicModelItem.ProtectedMap dataModelMap) {
        Monitor mon = MonitorFactory.start((String)JAMON_KEY_ENGINE_UPDATE);
        try {
            String logicModelKey = EngineUtil.removeTableIndices(me.getKey().toString());
            LogicModelItem lmi = (LogicModelItem)this.logicModelItems.get(logicModelKey);
            if (lmi != null) {
                dataModelMap.getRunningLoops().clear();
                lmi.setValue(dataModelMap, me.getKey().toString(), (ModelItemDTO)me.getValue(), null);
            } else {
                log.debug((Object)("invalid model item key: " + logicModelKey + " not found"));
            }
        }
        finally {
            mon.stop();
        }
    }

    public UpdateResultDTO update(Map dataModel, Map newValues, boolean errorForced, boolean deleteForced, String key, boolean writeOnView, boolean demoMode) throws InvalidModelItemKeyException {
        Iterator<Object> i;
        UpdateResultDTO result = this.update(dataModel, newValues, true);
        WizardDisplayInfoDTO diDTO = null;
        if (key != null) {
            diDTO = this.getWizardDisplayInfo(dataModel, key, writeOnView, false, demoMode, this.caller, false).getWizardDisplayInfoDTO();
        }
        boolean undo = false;
        if (!errorForced) {
            i = newValues.keySet().iterator();
            while (i.hasNext() && !undo) {
                Collection msgs;
                ModelItemDTO miDTO = (ModelItemDTO)dataModel.get(i.next());
                if (miDTO == null || (msgs = miDTO.getMessages()) == null) continue;
                Iterator j = msgs.iterator();
                while (j.hasNext() && !undo) {
                    if (((MessageItemDTO)j.next()).getType() != 4) continue;
                    undo = true;
                }
            }
        }
        if (!deleteForced) {
            Collection deleteWarnings = result.getDeleteWarnings();
            if (diDTO != null && deleteWarnings != null) {
                undo = true;
                diDTO.setDeleteWarnings(deleteWarnings);
            }
        }
        if (undo) {
            i = result.getUndoInformations().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry me = (Map.Entry)i.next();
                if (me.getValue() == null) {
                    dataModel.remove(me.getKey());
                    continue;
                }
                dataModel.put(me.getKey(), me.getValue());
            }
            result.getPersistenceWriteDTOs().clear();
        }
        if (diDTO != null) {
            result.setWizardDisplayInfoDTO(diDTO);
        }
        return result;
    }

    public UpdateResultDTO expertUpdate(Map dataModel, Map newValues, boolean errorForced, boolean deleteForced, String formAccessKey, Locale locale, boolean touchItems) throws InvalidModelItemKeyException {
        Iterator<Object> i;
        Map values = this.expertUpdatePreprocessor.preProcessExpertUpdate(dataModel, newValues);
        UpdateResultDTO result = this.update(dataModel, values, true);
        if (touchItems) {
            List stateItems = this.modelRoot.getExpertDisplayModel().getFormStateItems(formAccessKey);
            Map touchValues = this.expertUpdatePreprocessor.touchModelItems(formAccessKey, stateItems, dataModel);
            UpdateResultDTO touchResult = this.update(dataModel, touchValues, true);
            result.includeOtherResultWithoutDisplayInfo(touchResult);
        }
        ExpertDisplayInfoDTO diDTO = null;
        if (formAccessKey != null) {
            ExpertDisplayInfoDTOAndChanges diAndChanges = this.getExpertDisplayInfo(dataModel, formAccessKey, locale, 1);
            diDTO = diAndChanges.getExpertDisplayInfoDTO();
            result.getPersistenceWriteDTOs().putAll(diAndChanges.getChanges());
        }
        boolean undo = false;
        if (!errorForced) {
            i = values.keySet().iterator();
            while (i.hasNext() && !undo) {
                Collection msgs;
                ModelItemDTO miDTO = (ModelItemDTO)dataModel.get(i.next());
                if (miDTO == null || (msgs = miDTO.getMessages()) == null) continue;
                Iterator j = msgs.iterator();
                while (j.hasNext() && !undo) {
                    if (((MessageItemDTO)j.next()).getType() != 4) continue;
                    undo = true;
                }
            }
        }
        if (!deleteForced) {
            Collection deleteWarnings = result.getDeleteWarnings();
            if (diDTO != null && deleteWarnings != null) {
                undo = true;
                diDTO.setDeleteWarnings(deleteWarnings);
            }
        }
        if (undo) {
            i = result.getUndoInformations().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry me = (Map.Entry)i.next();
                if (me.getValue() == null) {
                    dataModel.remove(me.getKey());
                    continue;
                }
                dataModel.put(me.getKey(), me.getValue());
            }
            result.getPersistenceWriteDTOs().clear();
        }
        if (diDTO != null) {
            result.setExpertDisplayInfoDTO(diDTO);
        }
        return result;
    }

    public WizardDisplayInfoDTOAndChanges getWizardDisplayInfo(Map dataModel, String key, boolean writeOnView, boolean released, boolean demoMode, int caller, boolean autoEnable) throws InvalidModelItemKeyException {
        this.caller = caller;
        return this.getWizardDisplayInfo(dataModel, key, writeOnView, released, demoMode, autoEnable);
    }

    public WizardDisplayInfoDTOAndChanges getWizardDisplayInfo(Map dataModel, String key, boolean writeOnView, boolean released, boolean demoMode, boolean autoEnable) throws InvalidModelItemKeyException {
        int tmoState;
        Map changes;
        if (key == null) {
            key = ((LogicModelItem)this.modelRoot.getLogicModel().getModuls().get(0)).getName();
        }
        LogicModelItem lmi = (LogicModelItem)this.logicModelItems.get(EngineUtil.removeTableIndices(key));
        boolean isSubnavigation = false;
        if (lmi != null && lmi.getChildren() != null) {
            Iterator iter = lmi.getChildren().iterator();
            while (iter.hasNext()) {
                LogicModelItem element = (LogicModelItem)iter.next();
                if (!(element instanceof LogicModelItem.ModuleItem)) continue;
                isSubnavigation = true;
                if (!EngineUtil.endsWithTableIndex(key)) break;
                key = key + "." + EngineUtil.getLastKeyPart(element.getName());
                break;
            }
        }
        boolean isTableEntry = lmi instanceof LogicModelItem.TableItem && !isSubnavigation;
        WizardDisplayModelItem.ProtectedMap protectedDataModel = new WizardDisplayModelItem.ProtectedMap(dataModel, writeOnView, this);
        if (autoEnable && !(changes = this.getAutoEnableChanges(lmi, dataModel, key)).isEmpty()) {
            protectedDataModel.getChangedMap().putAll(this.update(dataModel, changes, false).getPersistenceWriteDTOs());
        }
        int n = tmoState = released ? 100 : this.getState(protectedDataModel);
        if (demoMode) {
            tmoState = 3;
        }
        String nextKey = this.modelRoot.getWizardDisplayModel().getNext(key, protectedDataModel, this.logicModelItems, tmoState, this.caller);
        String prevKey = this.modelRoot.getWizardDisplayModel().getPrev(key, protectedDataModel, this.logicModelItems, tmoState, this.caller);
        String backKey = this.modelRoot.getWizardDisplayModel().getBack(key, this.logicModelItems);
        String navKey = isTableEntry ? EngineUtil.mergeModelKey(lmi.getParent().getName(), key) : key;
        List navigationsItems = this.modelRoot.getWizardDisplayModel().getNavigationsInfo(this.logicModelItems, protectedDataModel, this.modelRoot, navKey, tmoState, this.caller);
        String formDMK = isSubnavigation ? navKey : key;
        String s = EngineUtil.removeTableIndices(formDMK);
        Form form = (Form)this.wizardDisplayModelItems.get(s);
        if (form == null && (form = (Form)this.wizardDisplayModelItems.get(s = EngineUtil.removeLastKeyPart(s))) == null) {
            throw new InvalidModelItemKeyException("no form found for " + formDMK);
        }
        ModelItemDTO prevDTO = (ModelItemDTO)dataModel.get(key);
        WizardDisplayInfoDTO.FormItemDTO formItemDTO = (WizardDisplayInfoDTO.FormItemDTO)form.getFormInfo(protectedDataModel, key);
        formItemDTO.setIsTableEntry(isTableEntry);
        formItemDTO.setAllNavigationItemsTouched(this.areAllNavigationItemsTouched(navigationsItems, key));
        ModelItemDTO postDTO = (ModelItemDTO)dataModel.get(key);
        if (!(postDTO == null || postDTO.getState() != 4 && postDTO.getState() != 2 || prevDTO != null && prevDTO.getState() == postDTO.getState())) {
            nextKey = prevKey = key;
            this.writeKeyInNavigationItems(navigationsItems, key);
        }
        WizardDisplayInfoDTO.NavigationDTO navigationDTO = new WizardDisplayInfoDTO.NavigationDTO(navigationsItems, nextKey, prevKey, backKey, key, tmoState);
        return new WizardDisplayInfoDTOAndChanges(new WizardDisplayInfoDTO(formItemDTO, navigationDTO, released), protectedDataModel.getChangedMap(), protectedDataModel.getUndoInfoMap());
    }

    private void writeKeyInNavigationItems(List navigationItems, String key) {
    }

    private boolean areAllNavigationItemsTouched(List navigationItems, String currentDMK) {
        boolean result = true;
        if (navigationItems != null) {
            Iterator i = navigationItems.iterator();
            while (i.hasNext()) {
                WizardDisplayInfoDTO.NavigationsItemDTO navItem = (WizardDisplayInfoDTO.NavigationsItemDTO)i.next();
                if (!currentDMK.startsWith(navItem.getKey()) && navItem.getState() == 3) {
                    result = false;
                }
                if (this.areAllNavigationItemsTouched(navItem.getChildren(), currentDMK)) continue;
                result = false;
            }
        }
        return result;
    }

    private Map getAutoEnableChanges(LogicModelItem lmi, Map dataModel, String dmk) {
        List validators = lmi.getValidators();
        if (lmi.isReadonly() || validators == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, ModelItemDTO> updates = new HashMap<String, ModelItemDTO>();
        Iterator i = validators.iterator();
        while (i.hasNext()) {
            Validator v = (Validator)i.next();
            if (!(v instanceof Transparent)) continue;
            Transparent t = (Transparent)v;
            Iterator it2 = t.getCalcItems().iterator();
            while (it2.hasNext()) {
                Object value;
                LogicModelItem ref;
                CalcItem ci = (CalcItem)it2.next();
                if (!(ci instanceof Reference) || !((ref = (LogicModelItem)this.logicModelItems.get(((Reference)((Object)ci)).getName())) instanceof Bool) && !(ref instanceof LogicModelItem.SelectItem) || ref.isReadonly()) continue;
                String miDmk = EngineUtil.mergeModelKey(ref.getName(), dmk);
                ModelItemDTO mi = (ModelItemDTO)dataModel.get(miDmk);
                if (mi == null) {
                    mi = new ModelItemDTO(!t.getBooleanExpression());
                    mi.setTouched();
                    updates.put(miDmk, mi);
                    continue;
                }
                if (mi.getState() == 12 || mi.getState() == 11 || (value = mi.getValue()) != null && !Boolean.valueOf(t.getBooleanExpression()).equals(value)) continue;
                mi = mi.clone(!t.getBooleanExpression());
                mi.setTouched();
                updates.put(miDmk, mi);
            }
        }
        return updates;
    }

    public ExpertDisplayInfoDTOAndChanges getExpertDisplayInfo(Map dataModel, String key, Locale locale, int mode) throws InvalidModelItemKeyException {
        ExpertDisplayModel.ProtectedMap protectedDataModel = new ExpertDisplayModel.ProtectedMap(dataModel, true, this);
        ExpertDisplayInfoDTO edi = null;
        edi = this.modelRoot.getExpertDisplayModel().getExpertDisplayInfo(protectedDataModel, key, this.logicModelItems, locale, mode);
        Map values = this.expertUpdatePreprocessor.preProcessExpertUpdate(dataModel, protectedDataModel.getTableUpdates());
        UpdateResultDTO result = this.update(dataModel, values, true);
        Map toWrite = protectedDataModel.getChangedMap();
        toWrite.putAll(result.getPersistenceWriteDTOs());
        return new ExpertDisplayInfoDTOAndChanges(edi, toWrite);
    }

    public List getExpertNavigationItems(Map dataModel) throws InvalidModelItemKeyException {
        ExpertDisplayModel.ProtectedMap protectedDataModel = new ExpertDisplayModel.ProtectedMap(dataModel, false, this);
        return this.modelRoot.getExpertDisplayModel().getExpertNavigationItems(protectedDataModel);
    }

    public ChangesAndUndoInformations delete(Map dataModel, String dataModelKey) throws InvalidModelItemKeyException {
        LogicModelItem.ProtectedMap dataModelMap = new LogicModelItem.ProtectedMap(dataModel, true);
        String logicModelKey = EngineUtil.removeTableIndices(dataModelKey);
        LogicModelItem lmi = (LogicModelItem)this.logicModelItems.get(logicModelKey);
        if (lmi == null) {
            throw new InvalidModelItemKeyException(logicModelKey + " not found");
        }
        lmi.deleteValue(dataModelMap, dataModelKey);
        return new ChangesAndUndoInformations(dataModelMap.getChangedMap(), dataModelMap.getUndoInfoMap());
    }

    public static Engine createEngine(String xmlStructure, DataResource dataResource, boolean verbose) throws ConstructionException {
        Engine result = new Engine(xmlStructure, dataResource, verbose);
        engines.put(result.getId(), result);
        return result;
    }

    public String getId() {
        return this.modelRoot.getName();
    }

    public static Engine getEngine(String id) {
        return (Engine)engines.get(id);
    }

    public static void reloadEngines() {
        engines.clear();
        log.debug((Object)"engines cache cleared");
    }

    public static void setMax(Element element, List validators) {
        if (element.getAttribute("max") != null) {
            String sValue = element.getAttributeValue("max");
            Max max = sValue.indexOf(".") != -1 ? new Max(Double.valueOf(sValue), false, false, null, false) : new Max(Long.valueOf(sValue), false, false, null, false);
            validators.add(max);
        }
    }

    public static void setMin(Element element, List validators) {
        if (element.getAttribute("min") != null) {
            String sValue = element.getAttributeValue("min");
            Min min = sValue.indexOf(".") != -1 ? new Min(Double.valueOf(element.getAttributeValue("min")), false, false, false, null, false) : new Min(Long.valueOf(element.getAttributeValue("min")), false, false, false, null, false);
            validators.add(min);
        }
    }

    public static void setMandatory(Element element, List validators) {
        if (element.getAttribute("mandatory") != null) {
            Mandatory mandatory = new Mandatory(false, null);
            validators.add(mandatory);
        }
    }

    public static void setNotNegative(Element element, List validators) {
        if (element.getAttribute("not-negative") != null) {
            NotNegative nonNegative = new NotNegative(Boolean.valueOf(element.getAttributeValue("not-negative")), false);
            validators.add(nonNegative);
        }
    }

    public int getEngineState(Map dataModel) {
        WizardDisplayModelItem.ProtectedMap protectedModel = new WizardDisplayModelItem.ProtectedMap(dataModel, false, this);
        return this.getState(protectedModel);
    }

    public UpdateResultDTO touchCompleteModel(Map dataModel) throws InvalidModelItemKeyException {
        List toplevelItems = this.modelRoot.getLogicModel().getModuls();
        Map touchValues = this.expertUpdatePreprocessor.touchModelItems("", toplevelItems, dataModel);
        UpdateResultDTO result = this.update(dataModel, touchValues, true);
        ExpertDisplayModel.ProtectedMap pMap = new ExpertDisplayModel.ProtectedMap(dataModel, false, this);
        ExpertDisplayInfoDTO edi = this.modelRoot.getExpertDisplayModel().getExpertDisplayInfo(pMap, null, this.logicModelItems, null, 1);
        result.setExpertDisplayInfoDTO(edi);
        result.getPersistenceWriteDTOs().putAll(pMap.getChangedMap());
        return result;
    }

    public boolean isImportable(String dataModelKey, boolean preinitializedCase) {
        LogicModelItem lmi = (LogicModelItem)this.logicModelItems.get(EngineUtil.removeTableIndices(dataModelKey));
        if (lmi != null) {
            return lmi.isImportable(preinitializedCase);
        }
        return false;
    }

    private int getState(WizardDisplayModelItem.ProtectedMap dataModel) {
        int state = 1;
        List topLevelModuls = this.modelRoot.getLogicModel().getModuls();
        Iterator iter = topLevelModuls.iterator();
        while (iter.hasNext()) {
            String dmk;
            ModelItemDTO dto;
            LogicModelItem.ModuleItem moduleItem;
            Object element = iter.next();
            if (!(element instanceof LogicModelItem.ModuleItem) || !(moduleItem = (LogicModelItem.ModuleItem)element).isImportantState() || (dto = dataModel.getWithoutTouch(dmk = ((LogicModelItem)((Object)moduleItem)).getName())) == null || !dto.hasMoreImportantState(state) || dto.getState() == 12 || dto.getState() == 11) continue;
            state = dto.getState();
        }
        return state;
    }

    public UpdateResultDTO recalculate(Map dataModel) {
        LogicModelItem.ProtectedMap dataModelMap = new LogicModelItem.ProtectedMap(dataModel, true);
        dataModelMap.setRecalculating(true);
        HashMap input = new HashMap();
        input.putAll(dataModel);
        long dmkValidationTime = 0L;
        Iterator i = input.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            String dataModelKey = me.getKey().toString();
            String logicModelKey = EngineUtil.removeTableIndices(dataModelKey);
            LogicModelItem lmi = (LogicModelItem)this.logicModelItems.get(logicModelKey);
            if (lmi == null) {
                log.debug((Object)("invalid model item key: " + logicModelKey + " not found"));
                dataModel.remove(dataModelKey);
                continue;
            }
            long time = System.currentTimeMillis();
            boolean isDmkValid = Engine.checkDataModelKey(dataModel, dataModelKey);
            time = System.currentTimeMillis() - time;
            dmkValidationTime += time;
            if (!isDmkValid) {
                dataModel.remove(dataModelKey);
                continue;
            }
            ModelItemDTO currentValue = dataModelMap.get(dataModelKey);
            ModelItemDTO oldValue = (ModelItemDTO)me.getValue();
            if (currentValue == null || !currentValue.equals(oldValue)) continue;
            lmi.fireDataChangedEvent(dataModelMap, dataModelKey, null, null, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("dataModelKey validation took " + dmkValidationTime + "ms"));
        }
        this.processAsyncUpdates(dataModelMap);
        return new UpdateResultDTO(dataModelMap.getChangedMap(), dataModelMap.getUndoInfoMap(), dataModelMap.getDeleteWarnings(), dataModelMap.getTableUpdates());
    }

    private static boolean checkDataModelKey(Map dataModel, String dataModelKey) {
        boolean isInTable;
        boolean bl = isInTable = !EngineUtil.removeTableIndices(dataModelKey).equals(dataModelKey);
        if (!isInTable) {
            return true;
        }
        String key = dataModelKey;
        while (key.length() > 0) {
            if (EngineUtil.endsWithTableIndex(key)) {
                String index = EngineUtil.getLastKeyPart(key);
                Set tableEntries = Collections.EMPTY_SET;
                String tableKey = EngineUtil.removeLastKeyPart(key);
                ModelItemDTO mi = (ModelItemDTO)dataModel.get(tableKey);
                if (mi != null && mi.getValue() != null) {
                    tableEntries = (Set)mi.getValue();
                }
                if (!tableEntries.contains(index)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("dataModelKey form no exisiting table enty. deleting item : " + dataModelKey));
                    }
                    return false;
                }
            }
            key = EngineUtil.removeLastKeyPart(key);
        }
        return true;
    }

    public byte[] generateBarcode(Map dataModel, Barcode2DGenerator generator, String appVersion, List barcodeLines) {
        if (dataModel == null) {
            throw new NullPointerException("dataModel may not be null");
        }
        if (generator == null) {
            throw new NullPointerException("generator may not be null");
        }
        ExpertDisplayModel.ProtectedMap dataModelMap = new ExpertDisplayModel.ProtectedMap(dataModel, true, this);
        ExpertDisplayModel.RequestContext ctx = new ExpertDisplayModel.RequestContext(dataModelMap, null, null, null, null, null, null, this.logicModelItems);
        ctx.setAppVersion(appVersion);
        ctx.setBarcodeLines(barcodeLines);
        return generator.generateData(ctx);
    }

    public static class ChangesAndUndoInformations {
        Map changes;
        Map undoInformations;

        public ChangesAndUndoInformations(Map changes, Map undoInformations) {
            this.changes = changes;
            this.undoInformations = undoInformations;
        }

        public Map getChanges() {
            return this.changes;
        }

        public Map getUndoInformations() {
            return this.undoInformations;
        }
    }

    public static class ExpertDisplayInfoDTOAndChanges {
        ExpertDisplayInfoDTO expertDisplayInfoDTO;
        Map changes;

        public ExpertDisplayInfoDTOAndChanges(ExpertDisplayInfoDTO expertDisplayInfoDTO, Map changes) {
            this.expertDisplayInfoDTO = expertDisplayInfoDTO;
            this.changes = changes;
        }

        public Map getChanges() {
            return this.changes;
        }

        public ExpertDisplayInfoDTO getExpertDisplayInfoDTO() {
            return this.expertDisplayInfoDTO;
        }
    }

    public static class WizardDisplayInfoDTOAndChanges {
        WizardDisplayInfoDTO wizardDisplayInfoDTO;
        Map changes;
        Map undoInformations;

        public WizardDisplayInfoDTOAndChanges(WizardDisplayInfoDTO wizardDisplayInfoDTO, Map changes, Map undoInformations) {
            this.wizardDisplayInfoDTO = wizardDisplayInfoDTO;
            this.changes = changes;
            this.undoInformations = undoInformations;
        }

        public Map getChanges() {
            return this.changes;
        }

        public WizardDisplayInfoDTO getWizardDisplayInfoDTO() {
            return this.wizardDisplayInfoDTO;
        }

        public Map getUndoInformations() {
            return this.undoInformations;
        }
    }

    private static class CustomResourceLocator
    implements ResourceLocator {
        String xmlStructure;

        private CustomResourceLocator(String xmlStructure) {
            this.xmlStructure = xmlStructure;
        }

        public void addResourceChangeListener(ResourceChangeListener arg0) {
        }

        public InputStream getResourceAsStream(String arg0) throws ResourceNotFoundException {
            if (this.xmlStructure == null || this.xmlStructure.length() == 0) {
                throw new ResourceNotFoundException("missing xml model");
            }
            return new ByteArrayInputStream(this.xmlStructure.getBytes());
        }

        public void removeResourceChangeListener(ResourceChangeListener arg0) {
        }
    }
}

