/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.MonKey;
import com.jamonapi.MonKeyItem;
import com.jamonapi.MonKeyItemBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MonKeyBase
implements MonKey {
    private Map keyMap;
    private String rangeKeyStr;
    private String detailLabel;

    public MonKeyBase(LinkedHashMap keyMap) {
        this(null, keyMap);
    }

    public MonKeyBase(String rangeKeyStr, LinkedHashMap keyMap) {
        this.rangeKeyStr = rangeKeyStr;
        this.keyMap = keyMap == null ? new LinkedHashMap() : keyMap;
    }

    public Object getValue(String key) {
        return this.keyMap.get(key);
    }

    public boolean equals(Object compareKey) {
        if (this == compareKey) {
            return true;
        }
        if (compareKey instanceof MonKeyBase) {
            MonKeyBase key = (MonKeyBase)compareKey;
            return ((Object)this.keyMap).equals(key.getMonKeyMap());
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.keyMap).hashCode();
    }

    public Map getMonKeyMap() {
        return this.keyMap;
    }

    public List getBasicHeader(List header) {
        header.add("Label");
        return header;
    }

    public List getDisplayHeader(List header) {
        return this.getHeader(header);
    }

    public List getHeader(List header) {
        Iterator iter = this.keyMap.keySet().iterator();
        while (iter.hasNext()) {
            header.add(iter.next());
        }
        return header;
    }

    public List getBasicRowData(List rowData) {
        Collection row = this.keyMap.values();
        int currentElement = 1;
        int lastElement = row.size();
        Iterator iter = row.iterator();
        StringBuffer buff = new StringBuffer();
        while (iter.hasNext()) {
            buff.append(iter.next());
            if (currentElement != lastElement) {
                buff.append(", ");
            }
            ++currentElement;
        }
        if (buff.length() > 0) {
            rowData.add(buff.toString());
        }
        return rowData;
    }

    public List getRowData(List rowData) {
        Collection row = this.keyMap.values();
        Iterator iter = row.iterator();
        while (iter.hasNext()) {
            rowData.add(iter.next());
        }
        return rowData;
    }

    public List getRowDisplayData(List rowData) {
        return this.getRowData(rowData);
    }

    public String toString() {
        Iterator iter = this.keyMap.entrySet().iterator();
        StringBuffer buff = new StringBuffer("JAMon Key");
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            buff.append(", ").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return buff.toString();
    }

    public String getRangeKey() {
        if (this.rangeKeyStr == null) {
            StringBuffer buff = new StringBuffer();
            Iterator iter = this.keyMap.keySet().iterator();
            while (iter.hasNext()) {
                buff.append(iter.next()).append(" ");
            }
            this.rangeKeyStr = buff.toString();
        }
        return this.rangeKeyStr;
    }

    public String getDetailLabel() {
        if (this.detailLabel == null) {
            Iterator iter = this.keyMap.entrySet().iterator();
            StringBuffer buff = new StringBuffer();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object value = entry.getValue();
                if (value instanceof MonKeyItem) {
                    value = ((MonKeyItem)value).getDetailLabel();
                }
                buff.append(value).append(", ");
            }
            return buff.toString();
        }
        return this.detailLabel;
    }

    public void setDetailLabel(String detailLabel) {
        this.detailLabel = detailLabel;
    }

    private void testDisplay() {
        System.out.println("\n***");
        System.out.println("toString()=" + this);
        System.out.println("getValue calls=" + this.getValue("fn") + ", " + this.getValue("ln") + ", " + this.getValue("age"));
        System.out.println("getRangeKey()=" + this.getRangeKey());
        System.out.println("\nHeader calls");
        System.out.println("getBasicHeader()=" + this.getBasicHeader(new ArrayList()));
        System.out.println("getHeader()=" + this.getHeader(new ArrayList()));
        System.out.println("getDisplayHeader()=" + this.getDisplayHeader(new ArrayList()));
        System.out.println("\nData calls");
        System.out.println("getBasicRowData()=" + this.getBasicRowData(new ArrayList()));
        System.out.println("getRowData()=" + this.getRowData(new ArrayList()));
        System.out.println("getRowDisplayData()=" + this.getRowDisplayData(new ArrayList()));
        System.out.println("getDetailLabel()=" + this.getDetailLabel());
    }

    public static void main(String[] arg) {
        LinkedHashMap<String, Object> steveMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> mindyMap = new LinkedHashMap<String, Object>();
        steveMap.put("fn", new MonKeyItemBase("steve summary", "steve detail"));
        steveMap.put("ln", "souza");
        steveMap.put("age", new Long(44L));
        mindyMap.put("fn", "mindy");
        mindyMap.put("ln", "bobish");
        mindyMap.put("age", new Long(33L));
        MonKeyBase steveMonKey = new MonKeyBase("Steves Range", steveMap);
        MonKeyBase steveMonKey2 = new MonKeyBase(steveMap);
        MonKeyBase mindyMonKey = new MonKeyBase(mindyMap);
        System.out.println("do 2 steves equal=" + ((Object)steveMonKey).equals(steveMonKey));
        System.out.println("do mindy and steve equal=" + ((Object)steveMonKey).equals(mindyMonKey));
        steveMonKey.testDisplay();
        steveMonKey2.testDisplay();
        mindyMonKey.testDisplay();
    }
}

