/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TextConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringMinMaxLengthConverter
extends TextConverter {
    private static final long serialVersionUID = 3763100777723475257L;
    private Pattern pattern = Pattern.compile("[0-9a-zA-Z]*");
    protected int minLength;
    String errorMax = "";
    String errorMin = "";

    public StringMinMaxLengthConverter(int maxLength, int minLength) {
        super(maxLength);
        this.minLength = minLength;
        this.errorMax = Integer.toString(maxLength);
        this.errorMin = Integer.toString(minLength);
    }

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        if (s.length() > this.maxLength) {
            throw new AbstractConverter.ConvertException("error.format.int-simple.max." + this.errorMax);
        }
        if (s.length() < this.minLength) {
            throw new AbstractConverter.ConvertException("error.format.int-simple.min." + this.errorMin);
        }
        Matcher m = this.pattern.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.int-simple");
        }
        return s;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Float || o instanceof Double) {
            return Long.toString(Math.round(((Number)o).doubleValue()));
        }
        return o.toString();
    }

    public String getUserInputRegExpPattern() {
        return "[0-9a-zA-Z]*";
    }
}

