/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NoContribuableConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3258413941062578742L;
    private Pattern patternValidate = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d)(\\.?)(\\d\\d\\d\\d)(\\-?)(\\d)");
    private Pattern patternRender = Pattern.compile("(\\d\\d\\d)(\\d\\d)(\\d\\d\\d\\d)(\\d)");
    private Pattern patternValidate2 = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d)(\\.?)(\\d\\d\\d\\d)");
    private Pattern patternRender2 = Pattern.compile("(\\d\\d\\d)(\\d\\d)(\\d\\d\\d\\d)");

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.patternValidate.matcher(s);
        Matcher m2 = this.patternValidate2.matcher(s);
        if (!m.matches() && !m2.matches()) {
            throw new AbstractConverter.ConvertException("error.format.noContribuable");
        }
        if (!this.isValid(s)) {
            throw new AbstractConverter.ConvertException("error.format.noContribuableAAA");
        }
        return s;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        Matcher m = this.patternRender.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + "." + m.group(2) + "." + m.group(3) + "-" + m.group(4);
        }
        Matcher m2 = this.patternRender2.matcher(o.toString());
        if (m2.matches()) {
            return m2.group(1) + "." + m2.group(2) + "." + m2.group(3);
        }
        return o.toString();
    }

    public String getUserInputRegExpPattern() {
        return "[0-9]{1,3}(\\.?)[0-9]{0,2}(\\.?)[0-9]{0,4}(\\-?)[0-9]{0,1}";
    }

    private boolean isValid(String sZpv) {
        if (sZpv.trim().equals("")) {
            return true;
        }
        return !(sZpv = NoContribuableConverter.removeAllNonDigits(sZpv)).equals("000000000") && !sZpv.equals("0000000000");
    }

    private static String removeAllNonDigits(String sNoContr) {
        int stringLength = sNoContr.length();
        char[] characters = sNoContr.toCharArray();
        String pureDigits = "";
        for (int i = 0; i < stringLength; ++i) {
            char character = characters[i];
            if (!Character.isDigit(character)) continue;
            pureDigits = pureDigits + character;
        }
        return pureDigits;
    }
}

