/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeDeclarationConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3258413941062578742L;
    private Pattern patternValidate = Pattern.compile("(\\d\\d)(\\-?)(\\d\\d\\d)(\\-?)(\\d\\d\\d)");
    private Pattern patternRender = Pattern.compile("(\\d\\d)(\\d\\d\\d)(\\d\\d\\d)");

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.patternValidate.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.noContribuable");
        }
        return s;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        Matcher m = this.patternRender.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + "-" + m.group(2) + "-" + m.group(3);
        }
        return o.toString();
    }

    public String getUserInputRegExpPattern() {
        return "[0-9]{1,2}(\\-?)[0-9]{0,3}(\\-?)[0-9]{0,3}";
    }
}

