/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.common.imports;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.common.imports.ImportContext;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.TaxFileImporter;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class GeTaxFileImporter
extends TaxFileImporter {
    private static final Logger log = Logger.getLogger(GeTaxFileImporter.class);
    private static final String TAX_YEAR_KEY = "Stammdaten.Declaration.PeriodeTaxation";
    private static final Long TAX_YEAR_EXPECTED = new Long(2008L);
    private static final String TAX_YEAR_ERROR_CODE = "error.import.steuerjahr";
    private static final Map ASSURANCE_VIE_ECHUE;

    public GeTaxFileImporter(ImportContext ctx) {
        super(ctx);
    }

    protected void importOldModelItems() throws ImportException {
        Object value;
        Long taxYear = null;
        ModelItemDTO taxYearItem = (ModelItemDTO)this.getOldDataModel().get(TAX_YEAR_KEY);
        if (taxYearItem != null && (value = taxYearItem.getValue()) != null) {
            if (value instanceof Long) {
                taxYear = (Long)value;
            } else {
                try {
                    taxYear = Long.valueOf(value.toString());
                }
                catch (Exception e) {
                    log.warn((Object)"tax year conversion failed", (Throwable)e);
                    taxYear = null;
                }
            }
        }
        if (!TAX_YEAR_EXPECTED.equals(taxYear)) {
            throw new ImportException(TAX_YEAR_ERROR_CODE);
        }
        super.importOldModelItems();
    }

    protected void storeInNewModel(String key, ModelItemDTO value) throws ImportException {
        String logicModelKey = EngineUtil.removeTableIndices((String)key);
        for (String current : ASSURANCE_VIE_ECHUE.keySet()) {
            Number n;
            Object verfall;
            if (!logicModelKey.startsWith(current)) continue;
            String lmkAufloesung = (String)ASSURANCE_VIE_ECHUE.get(current);
            String dmkAufloesung = EngineUtil.mergeModelKey((String)lmkAufloesung, (String)key);
            ModelItemDTO mi = (ModelItemDTO)this.getOldDataModel().get(dmkAufloesung);
            if (mi == null || mi.getValue() == null || !((verfall = mi.getValue()) instanceof Number) || (n = (Number)verfall).longValue() != (long)(TAX_YEAR_EXPECTED.intValue() + 1)) continue;
            return;
        }
        super.storeInNewModel(key, value);
    }

    static {
        HashMap<String, String> assurancesEchues = new HashMap<String, String>();
        assurancesEchues.put("Deductions.AssurancesVie.AssurancesVie", "Deductions.AssurancesVie.AssurancesVie.AnneeEcheance");
        ASSURANCE_VIE_ECHUE = Collections.unmodifiableMap(assurancesEchues);
    }
}

