/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.util;

import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.presentation.bd.TmoSession;
import ch.dvbern.tax.common.presentation.bd.cd.TmoSessionImpl;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.PrintUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import ch.dvbern.tax.common.transfer.util.ZipHelper;
import ch.dvbern.tax.ge.pp.engine.expertdisplay.GePPBarcodeGenerator;
import ch.dvbern.tax.ge.pp.transfer.dto.TeleversementDTO;
import ch.ge.afc.ael.fo.teledeclaration.pp.EnumCodeErreurTeleversement;
import ch.ge.afc.ael.fo.teledeclaration.pp.ITeleDeclarationWS;
import ch.ge.afc.ael.fo.teledeclaration.pp.ITeleDeclarationWSProxy;
import ch.ge.afc.ael.fo.teledeclaration.pp.ResultatTeleDeclaration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.program.Program;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadUtil
implements IRunnableWithProgress {
    private static final String FILE_SEPARATOR = File.separator;
    private static File televersementDir;
    private static final String DEFAULT_TELEVERSEMENT_DIR;
    private EnumCodeErreurTeleversement resultCode;
    private final ITeleDeclarationWS teleService = new ITeleDeclarationWS(){

        public ResultatTeleDeclaration teleVerser(int periode, byte[] declarationXml, byte[] declarationPdf) {
            String televersementUrl = TaxmeConfig.getString((String)"televersement.web.service.url");
            URL serviceUrl = null;
            ResultatTeleDeclaration response = null;
            try {
                serviceUrl = new URL(televersementUrl);
                ITeleDeclarationWSProxy client = new ITeleDeclarationWSProxy(televersementUrl);
                response = client.teleVerser(periode, declarationXml, declarationPdf);
            }
            catch (MalformedURLException e) {
                DialogUtil.showErrorDialog((String)Messages.getString((String)"label.upload.error.url"));
            }
            catch (RemoteException e) {
                DialogUtil.showErrorDialog((String)Messages.getString((String)"label.upload.error.connection"));
            }
            return response;
        }
    };

    public static String getFileSeparator() {
        return FILE_SEPARATOR;
    }

    public EnumCodeErreurTeleversement uploadDeclaration(IProgressMonitor mon) {
        int periode = Integer.parseInt(TaxmeConfig.getString((String)"steuerjahr"));
        GePPBarcodeGenerator barcodeGen = new GePPBarcodeGenerator();
        byte[] barcode = this.getBarCodeDeclaPP(barcodeGen);
        List forms = new ArrayList();
        try {
            forms = TaxmeController.getInstance().getTmoSession().getExpertNavigationItemAccessKeys();
        }
        catch (InvalidModelItemKeyException e) {
            throw new ApplicationException("could not read access keys", (Throwable)e);
        }
        byte[] declarationPdf = this.getPdfDeclaPP(TaxmeController.getInstance().getLocale(), forms, (TmoSession)TaxmeController.getInstance().getTmoSession());
        byte[] synthese = this.uploadDeclaration(periode, barcode, declarationPdf);
        if (this.resultCode.equals(EnumCodeErreurTeleversement.OK)) {
            this.saveFile(synthese, barcodeGen.getLastname(), barcodeGen.getFirstname(), barcodeGen.getCodeDeclaration());
        }
        this.setResultCode(this.resultCode);
        return this.resultCode;
    }

    private byte[] uploadDeclaration(int periode, byte[] declarationXml, byte[] declarationPdf) {
        ResultatTeleDeclaration response = null;
        try {
            response = this.getTeleService().teleVerser(periode, declarationXml, declarationPdf);
        }
        catch (RemoteException e) {
            DialogUtil.showErrorDialog((String)Messages.getString((String)"label.upload.error.connection"));
        }
        this.resultCode = response.getCode();
        return response.getResultat();
    }

    public ITeleDeclarationWS getTeleService() {
        return this.teleService;
    }

    private byte[] getBarCodeDeclaPP(GePPBarcodeGenerator barcodeGen) {
        TmoSessionImpl tmoSession = TaxmeController.getInstance().getTmoSession();
        byte[] zippedBarcode = tmoSession.generateBarcode((Barcode2DGenerator)barcodeGen);
        return ZipHelper.unzip((byte[])zippedBarcode);
    }

    private byte[] getPdfDeclaPP(Locale locale, List forms, TmoSession tmoSession) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (forms.contains("Barcode#")) {
                forms.remove("Barcode#");
            }
            if (forms.contains("envoi#")) {
                forms.remove("envoi#");
            }
            if (forms.contains("Justificatifs#")) {
                forms.remove("Justificatifs#");
            }
            if (forms.contains("recapitulationImpots#")) {
                forms.remove("recapitulationImpots#");
            }
            PrintUtil.printFormsInBackground((TmoSession)tmoSession, (List)forms, null, (Locale)locale, (boolean)false, (boolean)true, (OutputStream)baos);
        }
        catch (Exception e) {
            throw new ApplicationException("could not create pdfs", (Throwable)e);
        }
        return baos.toByteArray();
    }

    private void saveFile(byte[] synthese, String lastname, String firstname, String codeDeclaration) {
        String strFilePath = this.getTeleversementDir().getAbsolutePath();
        String strFileName = this.constructFileName(lastname, firstname, codeDeclaration);
        File pdfFile = new File(strFilePath + File.separator + strFileName);
        try {
            FileOutputStream fos = new FileOutputStream(pdfFile);
            fos.write(synthese);
            fos.close();
            UploadUtil.showPdf(pdfFile);
        }
        catch (FileNotFoundException e) {
            throw new ApplicationException("could not save pdf", (Throwable)e);
        }
        catch (IOException e) {
            throw new ApplicationException("could not save pdf", (Throwable)e);
        }
        catch (PdfViewerException e) {
            throw new ApplicationException("could not show pdf", (Throwable)e);
        }
    }

    private String constructFileName(String lastname, String firstname, String codeDeclaration) {
        String now = new SimpleDateFormat("yyyyMMdd'-'HHmmss").format(new Date());
        StringBuffer buf = new StringBuffer();
        buf.append(lastname.replaceAll("[\\W]", "").substring(0, 4));
        buf.append("-");
        buf.append(firstname.replaceAll("[\\W]", "").substring(0, 4));
        buf.append("_");
        buf.append(now);
        buf.append("_");
        buf.append(codeDeclaration);
        buf.append(".pdf");
        return buf.toString();
    }

    private File getTeleversementDir() {
        if (televersementDir == null) {
            String televersementDirNameAbsolutePath = TaxmeConfig.getString((String)"user.televersement.absolute.path");
            String televersementDirNameUsbPath = TaxmeConfig.getString((String)"user.televersement.usb.path");
            File tmpTeleversementDir = null;
            if (televersementDirNameAbsolutePath != null) {
                tmpTeleversementDir = new File(televersementDirNameAbsolutePath);
            }
            if (televersementDirNameUsbPath != null) {
                tmpTeleversementDir = new File(televersementDirNameUsbPath);
            }
            if (tmpTeleversementDir != null) {
                televersementDir = tmpTeleversementDir;
            } else {
                String televersementDirName = TaxmeConfig.getString((String)"user.televersement", (String)DEFAULT_TELEVERSEMENT_DIR);
                televersementDir = new File(System.getProperty("user.home"), televersementDirName);
            }
            if (!televersementDir.exists()) {
                televersementDir.mkdirs();
            }
        }
        return televersementDir;
    }

    public static void showPdf(File file) throws PdfViewerException {
        UploadUtil.showPdf(file.getAbsolutePath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void showPdf(String absolutFilePath) throws PdfViewerException {
        if (TaxmeConfig.getBoolean((String)"acroread.path.use")) {
            String path = TaxmeConfig.getString((String)"acroread.path");
            if (!new File(path).exists()) throw new PdfViewerException("PDF Viewer not found");
            try {
                Runtime.getRuntime().exec(path + " " + absolutFilePath);
                return;
            }
            catch (IOException e) {
                throw new PdfViewerException("can't launch PDF Viewer", e);
            }
        } else {
            if (Program.launch((String)absolutFilePath)) return;
            if (!new File(TaxmeConfig.getString((String)"acroread.path")).exists()) throw new PdfViewerException("can't launch PDF Viewer");
            TaxmeConfig.setValue((String)"acroread.path.use", (String)"true");
            UploadUtil.showPdf(absolutFilePath);
        }
    }

    public List<TeleversementDTO> getTeleversements(ModelItemDTO codeDeclarationItem) {
        ArrayList<TeleversementDTO> result = new ArrayList<TeleversementDTO>();
        String strFilePath = this.getTeleversementDir().getAbsolutePath();
        File televersementDir = new File(strFilePath);
        if (televersementDir.exists() && televersementDir.isDirectory()) {
            File[] televersements = televersementDir.listFiles();
            for (int i = 0; i < televersements.length; ++i) {
                File televersement = televersements[i];
                String name = televersement.getName();
                String fileCodeDecla = name.substring(name.lastIndexOf("_") + 1, name.length() - 4);
                fileCodeDecla = fileCodeDecla.replace("-", "");
                String codeDecla = ((String)codeDeclarationItem.getValue()).replace("-", "");
                if (!codeDecla.equals(fileCodeDecla)) continue;
                TeleversementDTO dto = new TeleversementDTO();
                dto.setDate(new Date(televersement.lastModified()));
                dto.setNom(name);
                dto.setAbsolutPath(televersement.getAbsolutePath());
                result.add(dto);
            }
        }
        return result;
    }

    public EnumCodeErreurTeleversement getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(EnumCodeErreurTeleversement resultCode) {
        this.resultCode = resultCode;
    }

    public void run(IProgressMonitor arg0) throws InvocationTargetException, InterruptedException {
    }

    static {
        DEFAULT_TELEVERSEMENT_DIR = "dvbern-tax" + FILE_SEPARATOR + "televersement";
    }

    private static class PdfViewerException
    extends Exception {
        private static final long serialVersionUID = 2283963821878049195L;

        public PdfViewerException(String message, Throwable cause) {
            super(message, cause);
        }

        public PdfViewerException(String message) {
            super(message);
        }
    }
}

