/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.util.DefaultTaxFileConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxmeGeFilename
extends DefaultTaxFileConfig {
    private static final String TAX_YEAR_KEY = "Stammdaten.Declaration.PeriodeTaxation";
    private static final Logger log = Logger.getLogger(TaxmeGeFilename.class);
    private static final Long TAX_YEAR_EXPECTED = new Long(2009L);

    public boolean checkVersion(Map dataModel) {
        Object value;
        Long taxYear = null;
        ModelItemDTO taxYearItem = (ModelItemDTO)dataModel.get(TAX_YEAR_KEY);
        ModelItemDTO model_2009 = (ModelItemDTO)dataModel.get("Stammdaten.isCommuneDeTaxationGenevois");
        if (taxYearItem != null && (value = taxYearItem.getValue()) != null) {
            if (value instanceof Long) {
                taxYear = (Long)value;
            } else {
                try {
                    taxYear = Long.valueOf(value.toString());
                }
                catch (Exception e) {
                    log.warn((Object)"tax year conversion failed", (Throwable)e);
                    taxYear = null;
                }
            }
        }
        if (taxYear == null) {
            return false;
        }
        return TAX_YEAR_EXPECTED.equals(taxYear);
    }

    public String getFileName(Map datamodel) {
        String filename = "";
        ModelItemDTO coupleDTO = (ModelItemDTO)datamodel.get("Stammdaten.Couple");
        ModelItemDTO nomContribuableDTO = (ModelItemDTO)datamodel.get("Stammdaten.Contribuable.Nom");
        ModelItemDTO prenomContribuableDTO = (ModelItemDTO)datamodel.get("Stammdaten.Contribuable.Prenom");
        ModelItemDTO nomConjointDTO = (ModelItemDTO)datamodel.get("Stammdaten.Conjoint.Nom");
        ModelItemDTO prenomConjointDTO = (ModelItemDTO)datamodel.get("Stammdaten.Conjoint.Prenom");
        ModelItemDTO steuerjahrDTO = (ModelItemDTO)datamodel.get(TAX_YEAR_KEY);
        String nomContribuable = nomContribuableDTO != null && nomContribuableDTO.getValue() != null ? (String)nomContribuableDTO.getValue() : "";
        String prenomContribuable = prenomContribuableDTO != null && prenomContribuableDTO.getValue() != null ? (String)prenomContribuableDTO.getValue() : "";
        String nomConjoint = nomConjointDTO != null && nomConjointDTO.getValue() != null ? (String)nomConjointDTO.getValue() : "";
        String prenomConjoint = prenomConjointDTO != null && prenomConjointDTO.getValue() != null ? (String)prenomConjointDTO.getValue() : "";
        String steuerjahr = steuerjahrDTO != null && steuerjahrDTO.getValue() != null ? String.valueOf(steuerjahrDTO.getValue()) : "";
        filename = coupleDTO != null && (Boolean)coupleDTO.getValue() != false ? "Fam_" + nomContribuable + prenomContribuable : nomContribuable + prenomContribuable;
        if (filename.length() > 20) {
            filename = filename.substring(0, 20);
        }
        filename = (filename + steuerjahr).replace(' ', '_');
        return filename;
    }
}

