/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.ge.afc.ael.fo.teledeclaration.pp.EnumCodeErreurTeleversement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GeUploadResultDialog
extends Dialog {
    private String errorString = "";
    private EnumCodeErreurTeleversement errorCode;
    private static final String HELP = "http://www.getax.ch/pp/";

    public GeUploadResultDialog(Shell parentShell, String errorString) {
        super(parentShell);
        this.errorString = errorString;
    }

    public GeUploadResultDialog(Shell parentShell, EnumCodeErreurTeleversement enumCodeErreurTeleversement) {
        super(parentShell);
        this.errorCode = enumCodeErreurTeleversement;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.errorCode.equals(EnumCodeErreurTeleversement.OK)) {
            shell.setText(Messages.getString((String)"label.upload.finished.title"));
        } else if (!"".equals(this.errorString)) {
            shell.setText(this.errorString);
        } else {
            shell.setText(Messages.getString((String)"label.upload.error.title"));
        }
    }

    protected Control createDialogArea(Composite parent) {
        ModelItemDTO codeDeclarationItem = (ModelItemDTO)TaxmeController.getInstance().getTmoSession().getDataModel().get("Stammdaten.Declaration.CodeDeclaration");
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData());
        GridData gdInfo = new GridData();
        gdInfo.widthHint = 530;
        if (this.errorCode != null) {
            if (this.errorCode.equals(EnumCodeErreurTeleversement.OK)) {
                Label labelSuccess1 = new Label(panel, 64);
                labelSuccess1.setText(Messages.getString((String)"label.upload.success.1", (Control)labelSuccess1));
                labelSuccess1.setFont(GuiUtil.getFontRegistry().get(GuiUtil.COLOR_GREEN));
                Label labelSuccess2 = new Label(panel, 64);
                labelSuccess2.setText(Messages.getString((String)"label.upload.success.2", (Control)labelSuccess2));
                labelSuccess2.setFont(GuiUtil.getFontRegistry().get(GuiUtil.COLOR_GREEN));
                Label labelEmpty1 = new Label(panel, 64);
                labelEmpty1.setText(Messages.getString((String)"label.empty", (Control)labelEmpty1));
                Label labelSuccess3 = new Label(panel, 64);
                labelSuccess3.setLayoutData((Object)gdInfo);
                labelSuccess3.setText(Messages.getString((String)"label.upload.success.3", (Control)labelSuccess3));
                Label labelEmpty2 = new Label(panel, 64);
                labelEmpty2.setText(Messages.getString((String)"label.empty", (Control)labelEmpty2));
                Label labelSuccess4 = new Label(panel, 64);
                labelSuccess4.setText(Messages.getString((String)"label.upload.success.4", (Control)labelSuccess4));
                labelSuccess4.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
            } else {
                Label labelError2 = new Label(panel, 64);
                labelError2.setLayoutData((Object)gdInfo);
                labelError2.setText(Messages.getString((String)"label.upload.error.2", (Control)labelError2));
                labelError2.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
                Label labelErrorEnum = new Label(panel, 64);
                labelErrorEnum.setLayoutData((Object)gdInfo);
                if (this.errorCode.equals(EnumCodeErreurTeleversement.ERR_COHERENCE_DATA)) {
                    labelErrorEnum.setText(Messages.getString((String)"label.upload.error.enum.coherence", (Control)labelError2));
                } else if (this.errorCode.equals(EnumCodeErreurTeleversement.ERR_CONTROLE_METIER)) {
                    labelErrorEnum.setText(Messages.getString((String)"label.upload.error.enum.metier", (Control)labelError2));
                } else if (this.errorCode.equals(EnumCodeErreurTeleversement.ERR_DECODAGE)) {
                    labelErrorEnum.setText(Messages.getString((String)"label.upload.error.enum.decode", (Control)labelError2));
                } else if (this.errorCode.equals(EnumCodeErreurTeleversement.ERR_INTERNE)) {
                    labelErrorEnum.setText(Messages.getString((String)"label.upload.error.enum.interne", (Control)labelError2));
                } else if (this.errorCode.equals("ERR_SERVICE_INDISPONIBLE")) {
                    labelErrorEnum.setText(Messages.getString((String)"label.upload.error.enum.unavailable", (Control)labelError2));
                } else {
                    labelErrorEnum.setText(Messages.getString((String)"label.upload.error.other", (Control)labelError2));
                }
                Label labelEmpty = new Label(panel, 64);
                labelEmpty.setLayoutData((Object)gdInfo);
                labelEmpty.setText(Messages.getString((String)"label.empty", (Control)labelEmpty));
                Link linkError3 = new Link(panel, 64);
                linkError3.setLayoutData((Object)gdInfo);
                linkError3.setText(Messages.getString((String)"label.upload.error.3", (Control)linkError3));
                linkError3.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        Program.launch((String)GeUploadResultDialog.HELP);
                    }
                });
                Label labelError4 = new Label(panel, 64);
                labelError4.setLayoutData((Object)gdInfo);
                labelError4.setText(Messages.getString((String)"label.upload.error.4", (Control)labelError4));
                Label labelError5 = new Label(panel, 64);
                labelError5.setLayoutData((Object)gdInfo);
                labelError5.setText(Messages.getString((String)"label.upload.error.5", (Control)labelError5));
                Label labelError6 = new Label(panel, 64);
                labelError6.setLayoutData((Object)gdInfo);
                labelError6.setText(Messages.getString((String)"label.upload.error.6", (Control)labelError6));
            }
        }
        return panel;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, Messages.getString((String)"label.button.updateCommunicationError.closeView"), false);
    }
}

