/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.dialog;

import ch.dvbern.lib.update.exception.CommunicationException;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.ImmediatelyCancelable;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.presentation.cd.dialog.GeUploadProgressDialog;
import ch.dvbern.tax.ge.pp.presentation.cd.util.UploadUtil;
import ch.dvbern.tax.ge.pp.transfer.dto.TeleversementDTO;
import ch.ge.afc.ael.fo.teledeclaration.pp.EnumCodeErreurTeleversement;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.axis.ConfigurationException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class GeUploadDialog
extends Dialog {
    private static final String INFO = "config" + File.separator + "cd" + File.separator + "mainHelp" + File.separator + "fr" + File.separator + "televerser.html";
    private static final Logger log = Logger.getLogger(GeUploadDialog.class);
    private Table televersementsTable;
    private TableViewer televersementsViewer;
    private UploadUtil uploadUtil = new UploadUtil();
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("dd.MM.yyyy");
    private static SimpleDateFormat sdfHour = new SimpleDateFormat("HH:mm:ss");
    private static final int WIDTH_HINT = 530;
    private static final int HEIGHT_HINT = 50;
    private EnumCodeErreurTeleversement erreurTeleversement;
    private static int stateDecla = 0;

    public GeUploadDialog(Shell parentShell) {
        super(parentShell);
        int stateDecla = TaxmeController.getInstance().getWizardDisplayInfoDTO().getNavigationDTO().getState();
        GeUploadDialog.stateDecla = stateDecla;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString((String)"title.shell.upload.dialog"));
    }

    protected Control createDialogArea(Composite parent) {
        ModelItemDTO codeDeclarationItem = (ModelItemDTO)TaxmeController.getInstance().getTmoSession().getDataModel().get("Stammdaten.Declaration.CodeDeclaration");
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData());
        GridData gdInfo = new GridData();
        gdInfo.widthHint = 530;
        if (GeUploadDialog.getStateDecla() != 1 && GeUploadDialog.getStateDecla() != 2) {
            Label labelInfoError = new Label(panel, 64);
            labelInfoError.setText(Messages.getString((String)"label.upload.not.possible", (Control)labelInfoError));
            labelInfoError.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
            Label labelInfoWarning = new Label(panel, 64);
            labelInfoWarning.setLayoutData((Object)gdInfo);
            labelInfoWarning.setText(Messages.getString((String)"label.upload.warning.complet", (Control)labelInfoWarning));
        } else if (codeDeclarationItem.getValue() == null) {
            Label labelInfoError = new Label(panel, 64);
            labelInfoError.setText(Messages.getString((String)"label.upload.not.possible", (Control)labelInfoError));
            labelInfoError.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
            Label labelInfoWarning = new Label(panel, 64);
            labelInfoWarning.setLayoutData((Object)gdInfo);
            labelInfoWarning.setText(Messages.getString((String)"label.upload.warning.codedecla", (Control)labelInfoWarning));
        } else {
            this.createTable(panel, codeDeclarationItem);
            Label labelEmpty = new Label(panel, 64);
            labelEmpty.setLayoutData((Object)gdInfo);
            labelEmpty.setText(Messages.getString((String)"label.empty", (Control)labelEmpty));
            Link linkInfo1 = new Link(panel, 64);
            linkInfo1.setLayoutData((Object)gdInfo);
            linkInfo1.setText(Messages.getString((String)"label.upload.info.1", (Control)linkInfo1));
            linkInfo1.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
            Link linkInfo2 = new Link(panel, 64);
            linkInfo2.setLayoutData((Object)gdInfo);
            linkInfo2.setText(Messages.getString((String)"label.upload.info.2", (Control)linkInfo2));
            linkInfo2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Program.launch((String)INFO);
                }
            });
        }
        return panel;
    }

    private void createTable(Composite panel, ModelItemDTO codeDeclarationItem) {
        List<TeleversementDTO> result = this.uploadUtil.getTeleversements(codeDeclarationItem);
        Label labelTitelTabelle = new Label(panel, 64);
        GridData gdTitelTabelle = new GridData();
        gdTitelTabelle.widthHint = 530;
        gdTitelTabelle.horizontalIndent = 5;
        gdTitelTabelle.verticalIndent = 5;
        labelTitelTabelle.setLayoutData((Object)gdTitelTabelle);
        labelTitelTabelle.setText(Messages.getString((String)"label.upload.televersements.table", (Control)labelTitelTabelle));
        labelTitelTabelle.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
        this.televersementsTable = new Table(panel, 68100);
        GridData gd = new GridData();
        gd.widthHint = 530;
        gd.heightHint = 50;
        gd.horizontalIndent = 5;
        gd.verticalIndent = 5;
        this.televersementsTable.setLayoutData((Object)gd);
        this.televersementsTable.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        this.televersementsTable.setLinesVisible(true);
        this.televersementsTable.setEnabled(true);
        this.televersementsTable.setHeaderVisible(true);
        TableColumn colPrint = new TableColumn(this.televersementsTable, 16384);
        colPrint.setWidth(50);
        colPrint.setText("");
        TableColumn colName = new TableColumn(this.televersementsTable, 16384);
        colName.setWidth(280);
        colName.setText(Messages.getString((String)"label.upload.televersement.table.title.col2"));
        TableColumn colDate = new TableColumn(this.televersementsTable, 16384);
        colDate.setWidth(200);
        colDate.setText(Messages.getString((String)"label.upload.televersement.table.title.col3"));
        this.televersementsViewer = new TableViewer(this.televersementsTable);
        this.televersementsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object rows) {
                if (rows instanceof List) {
                    return ((List)rows).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        });
        this.televersementsViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object row, int col) {
                switch (col) {
                    case 0: {
                        return GuiUtil.getImageRegistry().get("icon.menu.file.show");
                    }
                }
                return null;
            }

            public String getColumnText(Object row, int col) {
                if (row instanceof TeleversementDTO) {
                    TeleversementDTO vDTO = (TeleversementDTO)row;
                    switch (col) {
                        case 0: {
                            return "";
                        }
                        case 1: {
                            return vDTO.getNom();
                        }
                        case 2: {
                            StringBuffer sb = new StringBuffer();
                            sb.append(Messages.getString((String)"label.upload.televersement.table.label.date.1"));
                            sb.append(" ");
                            sb.append(sdfDate.format(vDTO.getDate()));
                            sb.append(" ");
                            sb.append(Messages.getString((String)"label.upload.televersement.table.label.date.2"));
                            sb.append(" ");
                            sb.append(sdfHour.format(vDTO.getDate()));
                            return sb.toString();
                        }
                    }
                }
                return "";
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void removeListener(ILabelProviderListener arg0) {
            }
        });
        this.televersementsViewer.setUseHashlookup(true);
        this.televersementsTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GeUploadDialog.this.showSelectedTeleversement();
            }
        });
        this.televersementsTable.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                GeUploadDialog.this.showSelectedTeleversement();
            }
        });
        this.televersementsViewer.setInput(result);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ModelItemDTO codeDeclarationItem = (ModelItemDTO)TaxmeController.getInstance().getTmoSession().getDataModel().get("Stammdaten.Declaration.CodeDeclaration");
        if ((stateDecla == 1 || stateDecla == 2) && codeDeclarationItem.getValue() != null) {
            this.createButton(parent, 0, Messages.getString((String)"label.button.upload"), true);
        }
        this.createButton(parent, 1, Messages.getString((String)"label.button.cancel"), false);
    }

    protected void okPressed() {
        UploadUtil util = new UploadUtil();
        GeUploadProgressDialog dlg = new GeUploadProgressDialog(Display.getCurrent().getActiveShell());
        try {
            dlg.setBusinessAlert(Messages.getString((String)"label.upload.info"));
            dlg.run(true, true, (IRunnableWithProgress)new Upload(util));
        }
        catch (InvocationTargetException e) {
            String msgKey = e.getCause() instanceof CommunicationException ? "label.application.update.error.communication" : (e.getCause() instanceof ConfigurationException ? "label.application.update.error.communication" : "label.application.update.error");
            DialogUtil.showErrorDialog((String)Messages.getString((String)msgKey));
        }
        catch (InterruptedException e) {
            DialogUtil.showErrorDialog((String)Messages.getString((String)"label.upload.error.1"));
        }
        this.setErreurTeleversement(util.getResultCode());
        this.close();
    }

    void showSelectedTeleversement() {
        TableItem[] selection = this.televersementsTable.getSelection();
        TeleversementDTO dto = (TeleversementDTO)selection[0].getData();
        try {
            UploadUtil.showPdf(dto.getAbsolutPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EnumCodeErreurTeleversement getErreurTeleversement() {
        return this.erreurTeleversement;
    }

    public void setErreurTeleversement(EnumCodeErreurTeleversement erreurTeleversement) {
        this.erreurTeleversement = erreurTeleversement;
    }

    public boolean close() {
        this.getShell().redraw();
        return super.close();
    }

    public static int getStateDecla() {
        return stateDecla;
    }

    private static class Upload
    extends ImmediatelyCancelable {
        private UploadUtil upload;

        public Upload(UploadUtil upload) {
            this.upload = upload;
        }

        protected void runInternal(IProgressMonitor mon) throws Exception {
            mon.beginTask(Messages.getString((String)"label.upload.wait"), -1);
            this.upload.uploadDeclaration(mon);
            mon.done();
        }
    }
}

