/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ActionRegistry;
import ch.dvbern.tax.common.presentation.cd.action.PrintableAction;
import ch.dvbern.tax.common.presentation.cd.action.WizardMultiPrintAction;
import ch.dvbern.tax.common.presentation.cd.dialog.TitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.PrintUtil;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GePrintDialog
extends TitleAreaDialog {
    private List buttonsEinzeln = new ArrayList();
    private List buttonsAlle = new ArrayList();
    private static final int MARGIN_LEFT = 20;
    private static boolean allowMultipleWizardPrint = false;

    public GePrintDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString((String)"title.shell.print.dialog"));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString((String)"title.print.dialog"));
        this.setMessage(Messages.getString((String)"label.print.message"));
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData());
        Label labelAlles = new Label(panel, 64);
        GridData gdAlles = new GridData();
        gdAlles.widthHint = 530;
        labelAlles.setLayoutData((Object)gdAlles);
        labelAlles.setText(Messages.getString((String)"label.print.alleformulare", (Control)labelAlles));
        labelAlles.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
        int stateStek = TaxmeController.getInstance().getWizardDisplayInfoDTO().getNavigationDTO().getState();
        if (stateStek != 1 && stateStek != 2) {
            Label labelWarnung = new Label(panel, 64);
            GridData gdWarnung = new GridData();
            gdWarnung.widthHint = 500;
            labelWarnung.setLayoutData((Object)gdWarnung);
            labelWarnung.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
            labelWarnung.setForeground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED));
            labelWarnung.setText(Messages.getString((String)"label.print.warnung.nicht.gruen", (Control)labelWarnung));
        }
        this.buttonsAlle.clear();
        ActionRegistry reg = ActionRegistry.getInstance();
        for (Action action : reg.getPrintActions()) {
            GridData gd4 = new GridData();
            gd4.horizontalIndent = 20;
            Button buttonAlles = new Button(panel, 32);
            if (stateStek == 1 || stateStek == 2) {
                buttonAlles.setEnabled(true);
            } else {
                buttonAlles.setEnabled(false);
            }
            buttonAlles.setLayoutData((Object)gd4);
            buttonAlles.setText(action.getText());
            buttonAlles.addSelectionListener((SelectionListener)new PrintAllSelectionListener());
            buttonAlles.setData((Object)action);
            this.buttonsAlle.add(buttonAlles);
        }
        GridData gd = new GridData();
        gd.widthHint = 500;
        Label labelUpload = new Label(panel, 64);
        labelUpload.setLayoutData((Object)gd);
        labelUpload.setText(Messages.getString((String)"label.print.warining.upload", (Control)labelUpload));
        labelUpload.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        Label labelEmpty = new Label(panel, 64);
        labelEmpty.setLayoutData((Object)gd);
        labelEmpty.setText("");
        labelEmpty.setFont(GuiUtil.getFontRegistry().get("font.normal"));
        Label labelEinzeln = new Label(panel, 64);
        labelEinzeln.setLayoutData((Object)gd);
        labelEinzeln.setText(Messages.getString((String)"label.print.einzelformulare", (Control)labelEinzeln));
        labelEinzeln.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
        this.buttonsEinzeln.clear();
        List navItems = TaxmeController.getInstance().getTmoSession().getExpertNavigationItems();
        for (ExpertDisplayInfoDTO.NavigationDTO navigationDTO : navItems) {
            GridData gd2 = new GridData();
            gd2.horizontalIndent = 20;
            if (navigationDTO.getPrintState() == 12 || !navigationDTO.isPrintEinzeldruck()) continue;
            Button buttonEinzeln = new Button(panel, 32);
            buttonEinzeln.setLayoutData((Object)gd2);
            buttonEinzeln.setData((Object)navigationDTO);
            buttonEinzeln.setText(Messages.getString((String)navigationDTO.getFormName(), (Control)buttonEinzeln));
            buttonEinzeln.setFont(GuiUtil.getFontRegistry().getItalic("font.normal"));
            if (navigationDTO.getState() == 1 || navigationDTO.getState() == 2) {
                buttonEinzeln.setEnabled(true);
            } else {
                buttonEinzeln.setEnabled(false);
            }
            this.buttonsEinzeln.add(buttonEinzeln);
        }
        return panel;
    }

    protected void okPressed() {
        if (allowMultipleWizardPrint) {
            ArrayList docsForMultiPrint = new ArrayList();
            for (Button button : this.buttonsAlle) {
                if (!button.getSelection() || !(button.getData() instanceof PrintableAction)) continue;
                PrintableAction action = (PrintableAction)button.getData();
                docsForMultiPrint.addAll(action.getFormKeys());
            }
            WizardMultiPrintAction actionMulti = new WizardMultiPrintAction(docsForMultiPrint);
            actionMulti.run();
        } else {
            for (Button button : this.buttonsAlle) {
                if (!button.getSelection()) continue;
                Action action = (Action)button.getData();
                action.run();
                this.close();
                return;
            }
        }
        List checked = this.getChecked();
        if (checked.isEmpty()) {
            this.close();
        } else if (PrintUtil.printForms((List)checked, (boolean)true)) {
            this.close();
        }
    }

    private List getChecked() {
        ArrayList checked = new ArrayList();
        for (Button element : this.buttonsEinzeln) {
            if (!element.getSelection()) continue;
            ExpertDisplayInfoDTO.NavigationDTO navigationDTO = (ExpertDisplayInfoDTO.NavigationDTO)element.getData();
            this.addSubItems(navigationDTO, checked);
        }
        return checked;
    }

    private void addSubItems(ExpertDisplayInfoDTO.NavigationDTO navigationDTO, List items) {
        if (navigationDTO.getSubItems() != null) {
            for (ExpertDisplayInfoDTO.NavigationDTO childDTO : navigationDTO.getSubItems()) {
                this.addSubItems(childDTO, items);
            }
        } else {
            PrintUtil.FormKey key = new PrintUtil.FormKey(navigationDTO.getAccessKey(), 1);
            items.add(key);
        }
    }

    private boolean canShowButtonsEinzeln() {
        for (Button element : this.buttonsAlle) {
            if (!element.getSelection()) continue;
            return false;
        }
        return true;
    }

    private void enableButtonsEinzeln() {
        for (Button element : this.buttonsEinzeln) {
            ExpertDisplayInfoDTO.NavigationDTO navigationDTO = (ExpertDisplayInfoDTO.NavigationDTO)element.getData();
            if (navigationDTO.getState() == 1 || navigationDTO.getState() == 2) {
                element.setEnabled(true);
                continue;
            }
            element.setEnabled(false);
        }
        for (Button button : this.buttonsAlle) {
            button.setEnabled(true);
        }
    }

    private void disableButtonsEinzeln() {
        for (Button element : this.buttonsEinzeln) {
            element.setSelection(false);
            element.setEnabled(false);
        }
    }

    public static void setAllowMultipleWizardPrint(boolean newAllowMultipleWizardPrint) {
        allowMultipleWizardPrint = newAllowMultipleWizardPrint;
    }

    private class PrintAllSelectionListener
    extends SelectionAdapter {
        private PrintAllSelectionListener() {
        }

        public void widgetSelected(SelectionEvent ev) {
            if (allowMultipleWizardPrint) {
                if (!GePrintDialog.this.canShowButtonsEinzeln()) {
                    GePrintDialog.this.disableButtonsEinzeln();
                } else {
                    GePrintDialog.this.enableButtonsEinzeln();
                }
            } else if (((Button)ev.getSource()).getSelection()) {
                GePrintDialog.this.disableButtonsEinzeln();
                for (Button button : GePrintDialog.this.buttonsAlle) {
                    if (ev.getSource() == button) continue;
                    button.setEnabled(false);
                }
            } else {
                GePrintDialog.this.enableButtonsEinzeln();
            }
        }
    }
}

