/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.ValorDTO;
import ch.dvbern.tax.ge.pp.transfer.dto.CommuneDTO;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class DataResourceImpl
implements DataResource {
    private static final int MAX_INPUT_FILE_LINES = 50000;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("dd.MM.yyyy");
    private static final String ENCODING = "ISO-8859-1";
    private static Map cantons;
    private static Map communesPays;
    private static Map communesSuisse;
    private static Map communesGECantonsPays;
    private static Map communesParCanton;
    private static Map communesTotal;
    private static Map categorieSocioProfessionnelle;
    private static Map tauxCapitalisation;
    private static Map valeurFiscaleImmeuble;
    private static Map valoren;
    private static Map impotBaseFortune;
    private static Map impotSupplFortune;
    private static Map bareme;
    private static Map paysDa1;
    private static Map resourcesToPrint;
    private static String fileDelimiter;
    private static String fileDir;
    private static Map fileContents;
    private static String fileCommunesCantonsPays;
    private static String fileCategorieSocioProfessionnelle;
    private static String fileTauxCapitalisation;
    private static String fileImpotBaseFortune;
    private static String fileImpotSupplFortune;
    private static String fileBareme;
    private static String filePaysDa1;
    private static String fileResourcesToPrint;
    private static String fileValoren;
    public static final String CANTONS = "cantons";
    public static final String COMMUNES_PAR_CANTON = "communesParCanton";
    public static final String COMMUNES_TOTAL = "communesTotal";
    public static final String COMMUNES_PAYS = "communesPays";
    public static final String COMMUNES_SUISSE = "communesSuisse";
    public static final String COMMUNESGE_CANTONS_PAYS = "communesGECantonsPays";
    public static final String TAUX_CAPITALISATION = "tauxCapitalisation";
    public static final String VALEUR_FISCALE_IMMEUBLE = "valeurFiscaleImmeuble";
    public static final String APPARTENANCE_AVEC_ENFANTS = "appartenanceAvecEnfants";
    public static final String APPARTENANCE_SANS_ENFANTS = "appartenanceSansEnfants";
    public static final String CATEGORIE_SOCIO_PROFESSIONNELLE = "categorieSocioProfessionnelle";
    public static final String CHOIX_DOMICILE = "choixDomicile";
    public static final String DEGRE_DE_PARENTE = "degreDeParente";
    public static final String IMPOT_BASE_FORTUNE = "impotBaseFortune";
    public static final String IMPOT_SUPPL_FORTUNE = "impotSupplFortune";
    public static final String BAREME = "bareme";
    public static final String PAYS_DA1 = "paysDa1";
    public static final String RESOURCES_TO_PRINT = "resourcesToPrint";
    public static final String VALOR = "valor";
    public static final String VALEUR = "valor";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map get(String code, Object arg1, Object arg2) {
        if (code.equals(CANTONS)) {
            if (cantons == null) {
                this.readCantons();
            }
            return cantons;
        }
        if (code.equals(COMMUNES_PAR_CANTON)) {
            Map m;
            if (communesParCanton == null || communesTotal == null) {
                this.readCommunesParCanton();
            }
            return (m = (Map)communesParCanton.get(arg1)) != null ? m : new HashMap();
        }
        if (code.equals(COMMUNES_TOTAL)) {
            if (communesParCanton == null || communesTotal == null) {
                this.readCommunesParCanton();
            }
            return communesTotal;
        }
        if (code.equals(COMMUNES_PAYS)) {
            if (communesPays == null) {
                this.readCommunesPays();
            }
            return communesPays;
        }
        if (code.equals(COMMUNES_SUISSE)) {
            if (communesSuisse == null) {
                this.readCommunesSuisse();
            }
            return communesSuisse;
        }
        if (code.equals(COMMUNESGE_CANTONS_PAYS)) {
            if (communesGECantonsPays == null) {
                this.readCommunesGECantonsPays();
            }
            return communesGECantonsPays;
        }
        if (code.equals(CATEGORIE_SOCIO_PROFESSIONNELLE)) {
            if (categorieSocioProfessionnelle == null) {
                this.readCategorieSocioProfessionnelle();
            }
            return categorieSocioProfessionnelle;
        }
        if (code.equals(TAUX_CAPITALISATION)) {
            if (tauxCapitalisation == null) {
                this.readTauxCapitalisation();
            }
            return tauxCapitalisation;
        }
        if (code.equals(VALEUR_FISCALE_IMMEUBLE)) {
            if (valeurFiscaleImmeuble == null) {
                this.readTauxCapitalisation();
            }
            return valeurFiscaleImmeuble;
        }
        if (code.equals(IMPOT_BASE_FORTUNE)) {
            this.readImpotBaseFortune();
            return impotBaseFortune;
        }
        if (code.equals(IMPOT_SUPPL_FORTUNE)) {
            this.readImpotSupplFortune();
            return impotSupplFortune;
        }
        if (code.equals(BAREME)) {
            this.readBareme();
            return bareme;
        }
        if (code.equals(PAYS_DA1)) {
            this.readPaysDa1();
            return paysDa1;
        }
        if (code.equals(RESOURCES_TO_PRINT)) {
            if (resourcesToPrint == null) {
                this.readResourcesToPrint();
            }
            return resourcesToPrint;
        }
        if (code.equals("valor")) {
            String string = "valor";
            synchronized ("valor") {
                if (valoren == null) {
                    this.readValoren();
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return valoren;
            }
        }
        if (code.equals("valor")) {
            String string = "valor";
            synchronized ("valor") {
                if (valoren == null) {
                    this.readValoren();
                }
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return valoren;
            }
        }
        if (code.equals("barcode")) {
            return null;
        }
        Map map = fileContents;
        synchronized (map) {
            Map m = (Map)fileContents.get(code);
            if (m == null) {
                m = this.readFile(code);
                fileContents.put(code, m);
            }
            return m;
        }
    }

    private void readImpotBaseFortune() {
        try {
            LinkedHashMap<String, OptionItemDTO> fortuneTmp = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileImpotBaseFortune);
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String montantDeterminant = tokenizer.nextToken();
                String impotAnnuel = tokenizer.nextToken();
                String par1000CHFSupp = tokenizer.nextToken();
                String values = impotAnnuel + "\u00ac\u00a2" + par1000CHFSupp;
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)montantDeterminant, null, values, false);
                fortuneTmp.put(montantDeterminant, optionItemDTO);
                line = in.readLine();
            }
            impotBaseFortune = fortuneTmp;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readImpotSupplFortune() {
        try {
            LinkedHashMap<String, OptionItemDTO> fortuneTmp = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileImpotSupplFortune);
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String montantDeterminant = tokenizer.nextToken();
                String impotAnnuel = tokenizer.nextToken();
                String par1000CHFSupp = tokenizer.nextToken();
                String values = impotAnnuel + "\u00ac\u00a2" + par1000CHFSupp;
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)montantDeterminant, null, values, false);
                fortuneTmp.put(montantDeterminant, optionItemDTO);
                line = in.readLine();
            }
            impotSupplFortune = fortuneTmp;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readBareme() {
        try {
            LinkedHashMap<String, OptionItemDTO> baremeTmp = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileBareme);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    String montantDeterminant = tokenizer.nextToken();
                    String impotSeul = tokenizer.nextToken();
                    String tauxSeul = tokenizer.nextToken();
                    String impotMarie = tokenizer.nextToken();
                    String tauxMarie = tokenizer.nextToken();
                    String values = impotSeul + "\u00ac\u00a2" + tauxSeul + "\u00ac\u00a2" + impotMarie + "\u00ac\u00a2" + tauxMarie;
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)montantDeterminant, null, values, false);
                    baremeTmp.put(montantDeterminant, optionItemDTO);
                    line = in.readLine();
                    continue;
                }
                line = in.readLine();
            }
            bareme = baremeTmp;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCommunesPays() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    String sCodeLieu = tokenizer.nextToken();
                    Long codeLieu = Long.valueOf(sCodeLieu);
                    String lieu = tokenizer.nextToken();
                    String codeEtLieu = tokenizer.nextToken();
                    String listeCommunesPays = tokenizer.nextToken();
                    String listeCommunesSuisse = tokenizer.nextToken();
                    String listeCommunesGECantonsPays = tokenizer.nextToken();
                    if (listeCommunesPays.equals("1")) {
                        OptionItemDTO optionItemDTO = new OptionItemDTO((Object)codeLieu, sCodeLieu, lieu, false);
                        myMap.put(codeLieu.toString(), optionItemDTO);
                        line = in.readLine();
                        continue;
                    }
                    line = in.readLine();
                    continue;
                }
                line = in.readLine();
            }
            communesPays = myMap;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCommunesSuisse() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    String sCodeLieu = tokenizer.nextToken();
                    Long codeLieu = Long.valueOf(sCodeLieu);
                    String lieu = tokenizer.nextToken();
                    String codeEtLieu = tokenizer.nextToken();
                    String listeCommunesPays = tokenizer.nextToken();
                    String listeCommunesSuisse = tokenizer.nextToken();
                    String listeCommunesGECantonsPays = tokenizer.nextToken();
                    if (listeCommunesSuisse.equals("1")) {
                        OptionItemDTO optionItemDTO = new OptionItemDTO((Object)codeLieu, sCodeLieu, lieu, false);
                        myMap.put(codeLieu.toString(), optionItemDTO);
                        line = in.readLine();
                        continue;
                    }
                    line = in.readLine();
                    continue;
                }
                line = in.readLine();
            }
            communesSuisse = myMap;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCommunesGECantonsPays() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCommunesCantonsPays);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    String sCodeLieu = tokenizer.nextToken();
                    Long codeLieu = Long.valueOf(sCodeLieu);
                    String lieu = tokenizer.nextToken();
                    String codeEtLieu = tokenizer.nextToken();
                    String listeCommunesPays = tokenizer.nextToken();
                    String listeCommunesSuisse = tokenizer.nextToken();
                    String listeCommunesGECantonsPays = tokenizer.nextToken();
                    if (listeCommunesGECantonsPays.equals("1")) {
                        OptionItemDTO optionItemDTO = new OptionItemDTO((Object)codeLieu, sCodeLieu, lieu, false);
                        myMap.put(codeLieu.toString(), optionItemDTO);
                        line = in.readLine();
                        continue;
                    }
                    line = in.readLine();
                    continue;
                }
                line = in.readLine();
            }
            communesGECantonsPays = myMap;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCantons() {
        try {
            LinkedHashMap<String, OptionItemDTO> result = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileDir + "kantone.txt");
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                Long key = Long.valueOf(tokenizer.nextToken());
                String kurzBezeichnung = tokenizer.nextToken();
                String bezeichnung = tokenizer.nextToken();
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)kurzBezeichnung, key.toString(), bezeichnung, false);
                result.put(kurzBezeichnung, optionItemDTO);
                line = in.readLine();
            }
            in.close();
            cantons = result;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCommunesParCanton() {
        try {
            LinkedHashMap<String, LinkedHashMap<String, CommuneDTO>> cantons = new LinkedHashMap<String, LinkedHashMap<String, CommuneDTO>>();
            communesTotal = new LinkedHashMap();
            BufferedReader in = DataResourceImpl.getReader(fileDir + "communesParCanton.txt");
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    String sCodeLieu = tokenizer.nextToken();
                    Long codeLieu = Long.valueOf(sCodeLieu);
                    String lieu = tokenizer.nextToken();
                    String codeEtLieu = tokenizer.nextToken();
                    String codeCanton = tokenizer.nextToken();
                    CommuneDTO dto = new CommuneDTO(codeLieu, lieu, codeCanton);
                    LinkedHashMap<String, CommuneDTO> communesDuCanton = (LinkedHashMap<String, CommuneDTO>)cantons.get(codeCanton);
                    if (communesDuCanton == null) {
                        communesDuCanton = new LinkedHashMap<String, CommuneDTO>();
                        cantons.put(codeCanton, communesDuCanton);
                    }
                    communesDuCanton.put(codeLieu.toString(), dto);
                    communesTotal.put(codeLieu.toString(), dto);
                }
                line = in.readLine();
            }
            in.close();
            communesParCanton = cantons;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readCategorieSocioProfessionnelle() {
        try {
            LinkedHashMap<String, OptionItemDTO> kt = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileCategorieSocioProfessionnelle);
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                Long key = Long.valueOf(tokenizer.nextToken());
                String bezeichnung = tokenizer.nextToken();
                String kurzBezeichnung = tokenizer.nextToken();
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)key, kurzBezeichnung, bezeichnung, false);
                kt.put(key.toString(), optionItemDTO);
                line = in.readLine();
            }
            categorieSocioProfessionnelle = kt;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readPaysDa1() {
        try {
            LinkedHashMap<String, OptionItemDTO> result = new LinkedHashMap<String, OptionItemDTO>();
            BufferedReader in = DataResourceImpl.getReader(fileDir + "paysDa1.txt");
            String line = in.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                String key = tokenizer.nextToken();
                String bezeichnung = tokenizer.nextToken();
                OptionItemDTO optionItemDTO = new OptionItemDTO((Object)key, null, bezeichnung, false);
                result.put(key, optionItemDTO);
                line = in.readLine();
            }
            in.close();
            paysDa1 = result;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readResourcesToPrint() {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            BufferedReader br = DataResourceImpl.getReader(fileResourcesToPrint);
            String line = br.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, "=");
                    String key = tokenizer.nextToken();
                    String value = tokenizer.nextToken();
                    result.put(key, value);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        resourcesToPrint = result;
    }

    private void readValoren() {
        try {
            ArrayList<ValorDTO> vDTOs = new ArrayList<ValorDTO>();
            BufferedReader br = DataResourceImpl.getReader(fileValoren);
            br.readLine();
            int line = 0;
            String cur = br.readLine();
            while (cur != null && line++ < 50000) {
                ValorDTO vDTO = this.extractDTO(cur);
                vDTOs.add(vDTO);
                cur = br.readLine();
            }
            br.close();
            Collections.sort(vDTOs, new Comparator(){

                public int compare(Object left, Object right) {
                    return ((ValorDTO)left).getBezeichnung().compareToIgnoreCase(((ValorDTO)right).getBezeichnung());
                }
            });
            valoren = new LinkedHashMap();
            for (ValorDTO vDTO : vDTOs) {
                boolean anwendbar = vDTO.getAnwendbar();
                if (!anwendbar || valoren.containsKey(vDTO.getNummer())) {
                    vDTO = DataResourceImpl.getValueLessValorDTO(vDTO, anwendbar && valoren.containsKey(vDTO.getNummer()));
                }
                valoren.put(vDTO.getNummer(), vDTO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ValorDTO getValueLessValorDTO(ValorDTO template, boolean mehrzeiler) {
        ValorDTO result = new ValorDTO();
        result.setNummer(template.getNummer());
        result.setType(template.getType());
        result.setBezeichnung(template.getBezeichnung());
        result.setWaehrungscode(template.getWaehrungscode());
        if (mehrzeiler) {
            result.setSteuerwert(template.getSteuerwert());
            result.setSicavb(new Boolean(true));
        } else {
            result.setSicavb(new Boolean(false));
        }
        return result;
    }

    private ValorDTO extractDTO(String line) throws Exception {
        ValorDTO result = new ValorDTO();
        String[] props = this.getStringsBetweenTabs(line);
        if (props.length > 0) {
            result.setNummer(this.asLong(props[0]));
        }
        if (props.length > 1) {
            result.setType(this.asInteger(props[1]));
        }
        if (props.length > 2) {
            result.setBezeichnung(this.asString(props[2]));
        }
        if (props.length > 3) {
            result.setSteuerwert(this.asDouble(props[3]));
        }
        if (props.length > 4) {
            result.setZins(this.asDouble(props[4]));
        }
        if (props.length > 5) {
            result.setWaehrungscode(this.asString(props[5]));
        }
        if (props.length > 6) {
            result.setEmissionsjahr(this.asInteger(props[6]));
        }
        if (props.length > 7) {
            result.setRueckzahlung(this.asDate(props[7]));
        }
        if (props.length > 8) {
            result.setTermin(this.asDate(props[8]));
        }
        if (props.length > 9) {
            result.setErtrag(this.asDouble(props[9]));
        }
        if (props.length > 10) {
            result.setSicavb(Boolean.valueOf(props[10]));
        }
        if (props.length > 11) {
            result.setAnwendbar(Boolean.valueOf(props[11]));
        }
        if (props.length > 12) {
            result.setVstUnterliegend(Boolean.valueOf(props[12]));
        }
        return result;
    }

    private void readTauxCapitalisation() {
        try {
            LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
            LinkedHashMap<Long, Double> secondMap = new LinkedHashMap<Long, Double>();
            BufferedReader in = DataResourceImpl.getReader(fileTauxCapitalisation);
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    Long value = Long.valueOf(tokenizer.nextToken());
                    String description = tokenizer.nextToken();
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)value, " ", description, false);
                    myMap.put(value.toString(), optionItemDTO);
                    secondMap.put(value, Double.valueOf(description));
                }
                line = in.readLine();
            }
            tauxCapitalisation = myMap;
            valeurFiscaleImmeuble = secondMap;
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getLocalized(String code, Object arg1, Object arg2) {
        Map map = fileContents;
        synchronized (map) {
            Map m = (Map)fileContents.get(code);
            if (m == null) {
                m = this.readLocalizedFile(code);
                fileContents.put(code, m);
            }
            return m;
        }
    }

    private Map readFile(String code) {
        LinkedHashMap<String, OptionItemDTO> result = new LinkedHashMap<String, OptionItemDTO>();
        try {
            BufferedReader in = DataResourceImpl.getReader(fileDir + code + ".txt");
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    StringTokenizer tokenizer = new StringTokenizer(line, fileDelimiter);
                    String key = tokenizer.nextToken();
                    String value = tokenizer.nextToken();
                    result.put(key, new OptionItemDTO((Object)key, null, value, false));
                }
                line = in.readLine();
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Map readLocalizedFile(String code) {
        HashMap result = new HashMap();
        try {
            String value;
            String key;
            StringTokenizer tokenizer;
            BufferedReader in = DataResourceImpl.getReader(fileDir + code + "_de.txt");
            String line = in.readLine();
            LinkedHashMap<String, OptionItemDTO> properties = new LinkedHashMap<String, OptionItemDTO>();
            while (line != null) {
                if (!line.startsWith("#")) {
                    tokenizer = new StringTokenizer(line, fileDelimiter);
                    key = tokenizer.nextToken();
                    value = tokenizer.nextToken();
                    properties.put(key, new OptionItemDTO((Object)key, null, value, false));
                }
                result.put("de", properties);
                line = in.readLine();
            }
            properties = new LinkedHashMap();
            in = DataResourceImpl.getReader(fileDir + code + "_fr.txt");
            line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    tokenizer = new StringTokenizer(line, fileDelimiter);
                    key = tokenizer.nextToken();
                    value = tokenizer.nextToken();
                    properties.put(key, new OptionItemDTO((Object)key, null, value, false));
                }
                result.put("fr", properties);
                line = in.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String[] getStringsBetweenTabs(String line) {
        ArrayList<String> result = new ArrayList<String>();
        int begin = 0;
        int end = line.indexOf(9);
        while (end >= 0) {
            result.add(line.substring(begin, end));
            begin = ++end;
            end = line.indexOf(9, begin);
        }
        result.add(line.substring(begin));
        return result.toArray(new String[0]);
    }

    private Integer asInteger(String prop) {
        Integer result = null;
        String s = this.formatPropertyString(prop);
        if (s.length() > 0) {
            result = new Integer(s);
        }
        return result;
    }

    private Long asLong(String prop) {
        Long result = null;
        String s = this.formatPropertyString(prop);
        if (s.length() > 0) {
            result = new Long(s);
        }
        return result;
    }

    private Double asDouble(String prop) {
        Double result = null;
        String s = this.formatPropertyString(prop);
        if (s.length() > 0) {
            result = new Double(s);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date asDate(String prop) throws Exception {
        Date result = null;
        String s = this.formatPropertyString(prop);
        if (s.length() > 0) {
            SimpleDateFormat simpleDateFormat = SDF;
            synchronized (simpleDateFormat) {
                result = SDF.parse(s);
            }
        }
        return result;
    }

    private String asString(String prop) {
        return this.formatPropertyString(prop);
    }

    private String formatPropertyString(String prop) {
        if (prop == null) {
            return "";
        }
        String s = prop.trim();
        if (s.length() > 1 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        return s.trim();
    }

    private static BufferedReader getReader(String fileName) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(fileName));
        InputStreamReader isr = new InputStreamReader((InputStream)fis, ENCODING);
        BufferedReader br = new BufferedReader(isr);
        return br;
    }

    public String translate(Locale arg0, String arg1) {
        return null;
    }

    static {
        fileDelimiter = "\t";
        fileDir = "config/cd/resources/";
        fileContents = new HashMap();
        fileCommunesCantonsPays = fileDir + "communesCantonsPays.txt";
        fileCategorieSocioProfessionnelle = fileDir + "categorieSocioProfessionnelle.txt";
        fileTauxCapitalisation = fileDir + "tauxCapitalisation.txt";
        fileImpotBaseFortune = fileDir + "impotBaseFortune.txt";
        fileImpotSupplFortune = fileDir + "impotSupplFortune.txt";
        fileBareme = fileDir + "bareme.txt";
        filePaysDa1 = fileDir + "paysDa1.txt";
        fileResourcesToPrint = fileDir + "resourcesToPrint.txt";
        fileValoren = fileDir + "valoren.txt";
    }
}

