/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.validators;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.ValorDTO;
import java.util.Map;

public class VerifyValorNumber
implements Validator {
    private Integer type;
    private DataResource dataResource;
    private Reference steuerjahr;
    private Reference valorNummer;
    private Reference commandItem;
    private String message;

    public VerifyValorNumber(DataResource dataResource, Reference steuerjahr, Reference valorNummer, Reference commandItem, String message) {
        this.dataResource = dataResource;
        this.steuerjahr = steuerjahr;
        this.valorNummer = valorNummer;
        this.commandItem = commandItem;
        this.message = message;
    }

    public VerifyValorNumber(int type, DataResource dataResource, Reference steuerjahr, Reference valorNummer, Reference commandItem, String message) {
        this.type = new Integer(type);
        this.dataResource = dataResource;
        this.steuerjahr = steuerjahr;
        this.valorNummer = valorNummer;
        this.commandItem = commandItem;
        this.message = message;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.steuerjahr.registerListenerOnReference(logicModel, logicModelItem, false);
        this.valorNummer.registerListenerOnReference(logicModel, logicModelItem, false);
        this.commandItem.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        String command = "";
        ModelItemDTO miDTO = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.commandItem.getName(), (String)dataModelKey));
        if (miDTO != null && miDTO.getValue() != null) {
            command = miDTO.getValue().toString();
        }
        if ("doSearch".equalsIgnoreCase(command)) {
            Long sj = null;
            miDTO = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.steuerjahr.getName(), (String)dataModelKey));
            if (miDTO != null && miDTO.getValue() instanceof Number) {
                sj = new Long(((Number)miDTO.getValue()).longValue());
            }
            Long vn = null;
            miDTO = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.valorNummer.getName(), (String)dataModelKey));
            if (miDTO != null && miDTO.getValue() instanceof String) {
                vn = new Long((String)miDTO.getValue());
            }
            if (miDTO != null && miDTO.getValue() instanceof Number) {
                vn = new Long(((Number)miDTO.getValue()).longValue());
            }
            ValorDTO vDTO = (ValorDTO)this.dataResource.get("valor", (Object)sj, null).get(vn);
            if (this.type == null && vDTO == null) {
                modelItemDTO = modelItemDTO.clone(4, this.message, null, 4);
            }
            if (this.type != null && vDTO != null && this.type.equals(vDTO.getType())) {
                modelItemDTO = this.message != null && this.message.startsWith("error") ? modelItemDTO.clone(4, this.message, null, 4) : modelItemDTO.clone(1, this.message, null, 2);
            }
        }
        return modelItemDTO;
    }
}

