/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.validators;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.ValorDTO;
import java.util.Map;

public class EvaluateFromValorNumber
implements Validator {
    private String code;
    private DataResource dataResource;
    private Reference steuerjahr;
    private Reference valorNummer;
    private Reference commandItem;
    private String message;
    private boolean doSetValue;
    private Reference doSetValueRef;

    public EvaluateFromValorNumber(String code, DataResource dataResource, Reference steuerjahr, Reference valorNummer, Reference commandItem, String message) {
        this(code, dataResource, steuerjahr, valorNummer, commandItem, message, true, null);
    }

    public EvaluateFromValorNumber(String code, DataResource dataResource, Reference steuerjahr, Reference valorNummer, Reference commandItem, String message, boolean doSetValue, Reference doSetValueRef) {
        this.code = code;
        this.dataResource = dataResource;
        this.steuerjahr = steuerjahr;
        this.valorNummer = valorNummer;
        this.commandItem = commandItem;
        this.message = message;
        this.doSetValue = doSetValue;
        this.doSetValueRef = doSetValueRef;
    }

    public void initializeReferences(Map logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.steuerjahr.registerListenerOnReference(logicModel, logicModelItem, false);
        this.valorNummer.registerListenerOnReference(logicModel, logicModelItem, false);
        this.commandItem.registerListenerOnReference(logicModel, logicModelItem, false);
        if (this.doSetValueRef != null) {
            this.doSetValueRef.registerListenerOnReference(logicModel, logicModelItem, false);
        }
    }

    public ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO modelItemDTO) {
        ModelItemDTO doSetValueDTO;
        if (this.doSetValueRef != null && (doSetValueDTO = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.doSetValueRef.getName(), (String)dataModelKey))) != null && doSetValueDTO.getValue() != null && (Boolean)doSetValueDTO.getValue() != this.doSetValue) {
            return modelItemDTO;
        }
        String command = "";
        ModelItemDTO miDTO = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.commandItem.getName(), (String)dataModelKey));
        if (miDTO != null && miDTO.getValue() != null) {
            command = miDTO.getValue().toString();
        }
        if ("doSearch".equalsIgnoreCase(command)) {
            Long sj = null;
            miDTO = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.steuerjahr.getName(), (String)dataModelKey));
            if (miDTO != null && miDTO.getValue() instanceof Number) {
                sj = new Long(((Number)miDTO.getValue()).longValue());
            }
            Long vn = null;
            miDTO = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.valorNummer.getName(), (String)dataModelKey));
            if (miDTO != null && miDTO.getValue() instanceof String) {
                vn = new Long((String)miDTO.getValue());
            }
            if (miDTO != null && miDTO.getValue() instanceof Number) {
                vn = new Long(((Number)miDTO.getValue()).longValue());
            }
            if (vn != null) {
                ValorDTO vDTO = (ValorDTO)this.dataResource.get("valor", (Object)sj, null).get(vn);
                Object newValue = null;
                if (vDTO != null) {
                    this.message = vDTO.getSicavb() != false ? "warning.titres.titres.basedonnee.plusieurslignes" : null;
                    if ("Designation".equalsIgnoreCase(this.code)) {
                        newValue = vDTO.getBezeichnung();
                    }
                    if ("RevenusAvecIAParAction".equalsIgnoreCase(this.code)) {
                        switch (vDTO.getType()) {
                            case 1: {
                                newValue = vDTO.getSicavb() == false ? (newValue = vDTO.getErtrag()) : null;
                                break;
                            }
                            case 2: {
                                if (vDTO.getZins() != null) {
                                    if (vDTO.getErtrag() == 0.0) {
                                        newValue = null;
                                        break;
                                    }
                                    newValue = vDTO.getSicavb() == false ? (newValue = new Double(vDTO.getZins() / 100.0)) : null;
                                    break;
                                }
                                newValue = null;
                                break;
                            }
                            case 3: {
                                newValue = null;
                                break;
                            }
                        }
                    }
                    if ("RevenusSansIAParAction".equalsIgnoreCase(this.code)) {
                        switch (vDTO.getType()) {
                            case 1: {
                                newValue = vDTO.getSicavb() == false ? (newValue = vDTO.getErtrag()) : null;
                                break;
                            }
                            case 2: {
                                if (vDTO.getZins() != null) {
                                    if (vDTO.getErtrag() == 0.0) {
                                        newValue = null;
                                        break;
                                    }
                                    newValue = vDTO.getSicavb() == false ? (newValue = new Double(vDTO.getZins() / 100.0)) : null;
                                    break;
                                }
                                newValue = null;
                                break;
                            }
                            case 3: {
                                newValue = null;
                                break;
                            }
                        }
                    }
                    if ("FortuneImposableParAction".equalsIgnoreCase(this.code)) {
                        switch (vDTO.getType()) {
                            case 1: {
                                newValue = vDTO.getSicavb() == false ? (newValue = vDTO.getSteuerwert()) : null;
                                break;
                            }
                            case 2: {
                                if (vDTO.getZins() != null) {
                                    newValue = vDTO.getSicavb() == false ? (newValue = new Double(vDTO.getSteuerwert() / 100.0)) : null;
                                    break;
                                }
                                newValue = null;
                                break;
                            }
                            case 3: {
                                newValue = null;
                                break;
                            }
                        }
                    }
                    if ("IASoumisOuiNon".equalsIgnoreCase(this.code)) {
                        newValue = vDTO.getVstUnterliegend();
                    }
                    if (this.message != null) {
                        modelItemDTO = modelItemDTO.clone(newValue, 1, this.message, null, 2);
                        modelItemDTO.setTouched();
                    } else {
                        modelItemDTO = modelItemDTO.clone(newValue);
                    }
                }
            }
        }
        return modelItemDTO;
    }
}

