/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.modelitems;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.calculimpot.CentimesAdditionnelsPartPrivilegieeModel;
import ch.dvbern.tax.ge.pp.calculimpot.GemeindeSteuer;
import ch.dvbern.tax.ge.pp.calculimpot.GemeindeSteuerModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SteuerberchnungItem
extends LogicModelItem {
    private LogicModelItem.ProtectedMap dataModel;
    private Reference sourceItems;
    private boolean DEBUG = false;
    private long veranlagungsgemeindeCode = 0L;
    private GemeindeSteuer gemeindeSteuer = null;
    private static long GEMEINDE_CODE_PREFIX = 6600L;
    private static long COMMUNE_PAR_DEFAUT = 6621L;
    private double impotCantonalSurRevenuParCommune = 0.0;
    private double impotCantonalSurFortuneParCommune = 0.0;
    private double totalImpotCommunal = 0.0;
    private double partPrivilegiee = 0.0;
    private double centimesAdditionnels = 0.0;
    private double impotPrivilegieRevenu = 0.0;
    private double soldeImpotBaseSurRevenu = 0.0;
    private double impotBaseSurFortune = 0.0;
    private double impotPrivilegieFortune = 0.0;
    private double soldeImpotBaseSurFortune = 0.0;
    private double impotCommunal = 0.0;
    private Reference table;
    private Reference column1;
    private Reference column2;
    private Reference column3;
    private Reference column4;
    private Reference column5;
    private Reference column6;
    private Reference column7;

    public SteuerberchnungItem(String name, Reference sourceItems, Reference table, Reference column1, Reference column2, Reference column3, Reference column4, Reference column5, Reference column6, Reference column7) {
        super(name, null, null, true, "false", true);
        this.sourceItems = sourceItems;
        this.column1 = column1;
        this.column2 = column2;
        this.column3 = column3;
        this.column4 = column4;
        this.column5 = column5;
        this.column6 = column6;
        this.column7 = column7;
        this.table = table;
    }

    protected void additionalInitializeReferences(Map logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        this.sourceItems.registerListenerOnReference(logicModel, (LogicModelItem)this, false);
        this.table.initializeReference(logicModel, (LogicModelItem)this, false);
        this.column1.initializeReference(logicModel, (LogicModelItem)this, true);
        this.column2.initializeReference(logicModel, (LogicModelItem)this, true);
        this.column3.initializeReference(logicModel, (LogicModelItem)this, true);
        this.column4.initializeReference(logicModel, (LogicModelItem)this, true);
        this.column5.initializeReference(logicModel, (LogicModelItem)this, true);
        this.column6.initializeReference(logicModel, (LogicModelItem)this, true);
        this.column7.initializeReference(logicModel, (LogicModelItem)this, true);
    }

    public Long buildGemeindeCode(int aGemeindeIndex) {
        long gemeindeCodePrefix = GEMEINDE_CODE_PREFIX;
        return new Long((long)aGemeindeIndex + gemeindeCodePrefix + 1L);
    }

    protected boolean hasAnInitialGreenState() {
        return true;
    }

    public boolean isReadonly() {
        return true;
    }

    public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        this.dataModel = dataModel;
        this.sourceItems.getReference().setValue(dataModel, this.sourceItems.getName(), new ModelItemDTO(null), "false");
        this.clearTable(dataModel);
        int currentRow = 90000;
        this.initialize();
        this.determineVeranlagungsgemeinde();
        this.gemeindeSteuer = new GemeindeSteuer(dataModel, this.getVeranlagungsgemeindeCode());
        this.gemeindeSteuer.setNettoEinkommenUndVermoegenProGemeinde();
        this.setPartPrivilegiee(this.getVeranlagungsgemeindeCode());
        if (this.DEBUG) {
            System.out.println("part privil\u00e9gi\u00e9e : " + this.getVeranlagungsgemeindeCode() + ", " + this.partPrivilegiee);
        }
        this.setCentimesAdditionnels(this.getVeranlagungsgemeindeCode());
        if (this.DEBUG) {
            System.out.println("centimes additionnels : " + this.getVeranlagungsgemeindeCode() + ", " + this.centimesAdditionnels);
        }
        double ibr = this.getItemDoubleValue("Recapitulation.CalculImpot.ImpotDeBaseSurRevenu");
        this.setImpotPrivilegieRevenu(ibr, this.partPrivilegiee);
        if (this.DEBUG) {
            System.out.println("Impot privil\u00e9gi\u00e9 sur Revenu: " + this.getImpotPrivilegieRevenu());
        }
        this.createTableCell(this.column1, dataModel, currentRow, new Long(this.getVeranlagungsgemeindeCode()));
        this.createTableCell(this.column2, dataModel, currentRow, new Long(0L));
        this.createTableCell(this.column3, dataModel, currentRow, new Long(0L));
        this.createTableCell(this.column4, dataModel, currentRow, new Double(this.impotPrivilegieRevenu));
        this.setSoldeImpotBaseSurRevenu(ibr - this.getImpotPrivilegieRevenu());
        if (this.DEBUG) {
            System.out.println("solde impot base sur revenu : " + this.getSoldeImpotBaseSurRevenu());
        }
        this.impotBaseSurFortune = this.getItemDoubleValue("Recapitulation.CalculImpot.ImpotDeBaseSurFortune");
        this.setImpotPrivilegieFortune(this.impotBaseSurFortune, this.partPrivilegiee);
        if (this.DEBUG) {
            System.out.println("impot privil\u00e9gi\u00e9 sur la fortune : " + this.getImpotPrivilegieFortune());
        }
        this.createTableCell(this.column5, dataModel, currentRow, new Double(this.getImpotPrivilegieFortune()));
        this.setSoldeImpotBaseSurFortune(this.impotBaseSurFortune - this.getImpotPrivilegieFortune());
        if (this.DEBUG) {
            System.out.println("solde impot base sur fortune : " + this.getSoldeImpotBaseSurFortune());
        }
        this.createTableCell(this.column6, dataModel, currentRow, new Double(this.centimesAdditionnels));
        if (this.DEBUG) {
            System.out.println("Centimes additionnels : " + this.centimesAdditionnels);
        }
        this.setImpotCommunal(this.getImpotPrivilegieRevenu() + this.getImpotPrivilegieFortune(), this.centimesAdditionnels);
        if (this.DEBUG) {
            System.out.println("imp\u00f4t communaux : " + this.getImpotCommunal());
        }
        this.addTotalImpotCommunal(this.getImpotCommunal());
        this.createTableCell(this.column7, dataModel, currentRow, new Double(this.getImpotCommunal()));
        double revenuImposableCommune = this.gemeindeSteuer.getNettoEinkommenFuerEinGemeinde(this.getVeranlagungsgemeindeCode());
        if (this.DEBUG) {
            System.out.println("revenu imposable commune : " + revenuImposableCommune);
        }
        this.setImpotCantonalSurRevenuParCommune(this.soldeImpotBaseSurRevenu, revenuImposableCommune, this.getTotalBesteuerbarEinkommen());
        if (this.DEBUG) {
            System.out.println("imp\u00f4t cantonal sur Revenu : " + this.getImpotCantonalSurRevenuParCommune());
        }
        long fortuneImposableCommune = this.gemeindeSteuer.getNettoVermoegenFuerEinGemeinde(this.getVeranlagungsgemeindeCode());
        if (this.DEBUG) {
            System.out.println("fortune imposable commune : " + fortuneImposableCommune);
        }
        this.setImpotCantonalSurFortuneParCommune(this.soldeImpotBaseSurFortune, fortuneImposableCommune, this.getTotalBesteuerbarVermoegen());
        if (this.DEBUG) {
            System.out.println("imp\u00f4t cantonal sur Fortune : " + this.getImpotCantonalSurFortuneParCommune());
        }
        this.centimesAdditionnels = this.getCentimesAdditionnels(this.getVeranlagungsgemeindeCode());
        this.setImpotCommunal(this.getImpotCantonalSurRevenuParCommune() + this.getImpotCantonalSurFortuneParCommune(), this.centimesAdditionnels);
        if (this.DEBUG) {
            System.out.println("Imp\u00f4t communal : " + this.getImpotCommunal());
        }
        this.addTotalImpotCommunal(this.getImpotCommunal());
        this.createTableCell(this.column1, dataModel, ++currentRow, new Long(this.getVeranlagungsgemeindeCode()));
        if (revenuImposableCommune > 0.0) {
            this.createTableCell(this.column2, dataModel, currentRow, new Double(revenuImposableCommune));
        } else {
            this.createTableCell(this.column2, dataModel, currentRow, null);
        }
        if (fortuneImposableCommune > 0L) {
            this.createTableCell(this.column3, dataModel, currentRow, new Double(fortuneImposableCommune));
        } else {
            this.createTableCell(this.column3, dataModel, currentRow, null);
        }
        this.createTableCell(this.column4, dataModel, currentRow, new Double(this.getImpotCantonalSurRevenuParCommune()));
        this.createTableCell(this.column5, dataModel, currentRow, new Double(this.getImpotCantonalSurFortuneParCommune()));
        this.createTableCell(this.column6, dataModel, currentRow, new Double(this.centimesAdditionnels));
        this.createTableCell(this.column7, dataModel, currentRow, new Double(this.getImpotCommunal()));
        if (this.DEBUG) {
            System.out.println("Commune : " + this.getVeranlagungsgemeindeCode());
            System.out.println("Revenu imposable : " + revenuImposableCommune);
            System.out.println("Fortune imposable : " + fortuneImposableCommune);
            System.out.println("Impot cantonal sur le revenu : " + this.getImpotCantonalSurRevenuParCommune());
            System.out.println("Impot cantonal sur la fortune : " + this.getImpotCantonalSurFortuneParCommune());
            System.out.println("Taux communal : " + this.centimesAdditionnels);
            System.out.println("Impot communal : " + this.getImpotCommunal());
        }
        int i = 0;
        while ((long)i < this.gemeindeSteuer.getAnzahlGemeinde()) {
            long communeDeDomicile = this.getVeranlagungsgemeindeCode() - GEMEINDE_CODE_PREFIX - 1L;
            revenuImposableCommune = this.gemeindeSteuer.getNettoEinkommenFuerEinGemeinde(i);
            fortuneImposableCommune = this.gemeindeSteuer.getNettoVermoegeFuerEinGemeinde(i);
            if ((long)i != communeDeDomicile && (revenuImposableCommune > 0.0 || fortuneImposableCommune > 0L)) {
                this.setImpotCantonalSurRevenuParCommune(this.soldeImpotBaseSurRevenu, revenuImposableCommune, this.getTotalBesteuerbarEinkommen());
                this.setImpotCantonalSurFortuneParCommune(this.soldeImpotBaseSurFortune, fortuneImposableCommune, this.getTotalBesteuerbarVermoegen());
                this.centimesAdditionnels = this.getCentimesAdditionnels(i);
                this.setImpotCommunal(this.getImpotCantonalSurRevenuParCommune() + this.getImpotCantonalSurFortuneParCommune(), this.centimesAdditionnels);
                this.addTotalImpotCommunal(this.getImpotCommunal());
                this.createTableCell(this.column1, dataModel, currentRow += i + 1, this.buildGemeindeCode(i));
                if (revenuImposableCommune > 0.0) {
                    this.createTableCell(this.column2, dataModel, currentRow, new Double(revenuImposableCommune));
                } else {
                    this.createTableCell(this.column2, dataModel, currentRow, null);
                }
                if (fortuneImposableCommune > 0L) {
                    this.createTableCell(this.column3, dataModel, currentRow, new Double(fortuneImposableCommune));
                } else {
                    this.createTableCell(this.column3, dataModel, currentRow, null);
                }
                this.createTableCell(this.column4, dataModel, currentRow, new Double(this.getImpotCantonalSurRevenuParCommune()));
                this.createTableCell(this.column5, dataModel, currentRow, new Double(this.getImpotCantonalSurFortuneParCommune()));
                this.createTableCell(this.column6, dataModel, currentRow, new Double(this.centimesAdditionnels));
                this.createTableCell(this.column7, dataModel, currentRow, new Double(this.getImpotCommunal()));
                if (this.DEBUG) {
                    System.out.println("Commune : " + this.buildGemeindeCode(i));
                    System.out.println("Revenu imposable : " + revenuImposableCommune);
                    System.out.println("Fortune imposable : " + fortuneImposableCommune);
                    System.out.println("Impot cantonal sur le revenu : " + this.getImpotCantonalSurRevenuParCommune());
                    System.out.println("Impot cantonal sur la fortune : " + this.getImpotCantonalSurFortuneParCommune());
                    System.out.println("Taux communal : " + this.centimesAdditionnels);
                    System.out.println("Impot communal : " + this.getImpotCommunal());
                }
            }
            ++i;
        }
        if (this.DEBUG) {
            System.out.println("Calcul correct : " + GemeindeSteuerModel.singleton().isSteuerBerechnungCorrect());
        }
    }

    private void clearTable(LogicModelItem.ProtectedMap dataModel) {
        this.table.getReference().deleteSubValues(dataModel, this.table.getReference().getName(), true, "true");
    }

    private void createTableCell(Reference column, LogicModelItem.ProtectedMap dataModel, int row, Object value) {
        String key = EngineUtil.mergeModelKey((String)column.getReference().getName(), (String)(this.table.getReference().getName() + "." + row));
        ModelItemDTO mi = new ModelItemDTO(value);
        mi.setTouched();
        column.getReference().setValue(dataModel, key, mi, "true");
    }

    public long getTotalBesteuerbarVermoegen() {
        return this.gemeindeSteuer.getTotalNettoVermoegen();
    }

    private void setImpotPrivilegieRevenu(double montant, double taux) {
        this.impotPrivilegieRevenu = montant * taux;
    }

    private void setImpotPrivilegieFortune(double montant, double taux) {
        this.impotPrivilegieFortune = montant * this.partPrivilegiee;
    }

    public long getTotalBesteuerbarEinkommen() {
        return this.gemeindeSteuer.getTotalNettoEinkommen();
    }

    public double getImpotPrivilegieRevenu() {
        return this.impotPrivilegieRevenu;
    }

    public double getImpotPrivilegieFortune() {
        return this.impotPrivilegieFortune;
    }

    private void setImpotCommunal(double montant, double taux) {
        this.impotCommunal = montant * taux / 100.0;
    }

    private void addTotalImpotCommunal(double impotCommunal) {
        this.totalImpotCommunal += impotCommunal;
    }

    private void setImpotCantonalSurRevenuParCommune(double soldeImpotDeBase, double montantImposableCommune, long TotalMontantImposable) {
        if (TotalMontantImposable != 0L) {
            this.impotCantonalSurRevenuParCommune = soldeImpotDeBase * montantImposableCommune / (double)TotalMontantImposable;
        }
    }

    public double getCentimesAdditionnels(int gemeindeIndex) {
        double steuer = 0.0;
        long gemeindeCodePrefix = GEMEINDE_CODE_PREFIX;
        long gemeindeCode = (long)(gemeindeIndex + 1) + gemeindeCodePrefix;
        steuer = CentimesAdditionnelsPartPrivilegieeModel.singleton().getCentimesAdditionnels(gemeindeCode);
        return steuer;
    }

    public double getCentimesAdditionnels(long gemeindeCode) {
        double steuer = 0.0;
        steuer = CentimesAdditionnelsPartPrivilegieeModel.singleton().getCentimesAdditionnels(gemeindeCode);
        return steuer;
    }

    private void setSoldeImpotBaseSurRevenu(double newSoldeImpotBaseSurRevenu) {
        this.soldeImpotBaseSurRevenu = newSoldeImpotBaseSurRevenu;
    }

    public double getSoldeImpotBaseSurRevenu() {
        return this.soldeImpotBaseSurRevenu;
    }

    private void setSoldeImpotBaseSurFortune(double newSoldeImpotBaseSurFortune) {
        this.soldeImpotBaseSurFortune = newSoldeImpotBaseSurFortune;
    }

    public double getSoldeImpotBaseSurFortune() {
        return this.soldeImpotBaseSurFortune;
    }

    private void setPartPrivilegiee(long gemeindeCode) {
        this.partPrivilegiee = CentimesAdditionnelsPartPrivilegieeModel.singleton().getPartPrivilegiee(gemeindeCode);
    }

    private void setCentimesAdditionnels(long gemeindeCode) {
        this.centimesAdditionnels = CentimesAdditionnelsPartPrivilegieeModel.singleton().getCentimesAdditionnels(gemeindeCode);
    }

    public double getImpotCantonalSurFortuneParCommune() {
        return this.impotCantonalSurFortuneParCommune;
    }

    private void setImpotCantonalSurFortuneParCommune(double soldeImpotDeBase, double montantImposableCommune, long TotalMontantImposable) {
        if (TotalMontantImposable != 0L) {
            this.impotCantonalSurFortuneParCommune = soldeImpotDeBase * montantImposableCommune / (double)TotalMontantImposable;
        }
    }

    public void determineVeranlagungsgemeinde() {
        long communeFinAnnee = 0L;
        long communeDomicile = 0L;
        communeFinAnnee = this.getItemLongValue("Stammdaten.AdresseFinAnnee.Commune");
        communeDomicile = this.getItemLongValue("Stammdaten.Declaration.CommuneTaxation");
        if (communeFinAnnee != 0L) {
            if (GemeindeSteuerModel.singleton().isGemeindeInGenf(communeFinAnnee)) {
                this.setVeranlagungsgemeindeCode(communeFinAnnee);
                GemeindeSteuerModel.singleton().modifySteuerBerechnungCorrect(true);
            } else {
                this.setVeranlagungsgemeindeCode(COMMUNE_PAR_DEFAUT);
                GemeindeSteuerModel.singleton().modifySteuerBerechnungCorrect(false);
            }
        } else if (communeDomicile != 0L) {
            if (GemeindeSteuerModel.singleton().isGemeindeInGenf(communeDomicile)) {
                this.setVeranlagungsgemeindeCode(communeDomicile);
                GemeindeSteuerModel.singleton().modifySteuerBerechnungCorrect(true);
            } else {
                this.setVeranlagungsgemeindeCode(COMMUNE_PAR_DEFAUT);
                GemeindeSteuerModel.singleton().modifySteuerBerechnungCorrect(false);
            }
        }
    }

    public void setVeranlagungsgemeindeCode(int aVeranlagungsgemeindeIndex) {
        long gemeindeCodePrefix = GEMEINDE_CODE_PREFIX;
        this.veranlagungsgemeindeCode = (long)aVeranlagungsgemeindeIndex + gemeindeCodePrefix + 1L;
    }

    public void setVeranlagungsgemeindeCode(long aVeranlagungsgemeindeCode) {
        this.veranlagungsgemeindeCode = aVeranlagungsgemeindeCode;
    }

    protected boolean getItemBoolean(String dmk) {
        Object value = this.getValue(dmk, this.dataModel);
        if (null != value) {
            return (Boolean)value;
        }
        return false;
    }

    protected long getItemLongValue(String dmk) {
        Object value = this.getValue(dmk, this.dataModel);
        if (value != null && value instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    protected double getItemDoubleValue(String dmk) {
        Object value = this.getValue(dmk, this.dataModel);
        if (value != null && value instanceof Double) {
            return ((Double)value).longValue();
        }
        return 0.0;
    }

    protected Object getValue(String dmk, LogicModelItem.ProtectedMap dm) {
        ModelItemDTO mi = dm.get((Object)dmk);
        if (mi != null) {
            return mi.getValue();
        }
        return null;
    }

    protected int valueToInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Number Format Exception ", e);
        }
    }

    protected Collection getTableRowIndexes(String dmk, LogicModelItem.ProtectedMap dm) {
        Set set = (Set)this.getValue(dmk, dm);
        if (set == null || set.isEmpty()) {
            return set;
        }
        ArrayList sortedKeys = new ArrayList(set);
        Collections.sort(sortedKeys);
        return sortedKeys;
    }

    public long getVeranlagungsgemeindeCode() {
        if (this.veranlagungsgemeindeCode == 0L) {
            return COMMUNE_PAR_DEFAUT;
        }
        return this.veranlagungsgemeindeCode;
    }

    public GemeindeSteuer getGemeindeSteuer() {
        return this.gemeindeSteuer;
    }

    public double getImpotBaseSurFortune() {
        return this.getItemDoubleValue("Recapitulation.CalculImpot.FortuneImpotDeBase");
    }

    public double getImpotCantonalSurRevenuParCommune() {
        return this.impotCantonalSurRevenuParCommune;
    }

    public double getImpotCommunal() {
        return this.impotCommunal;
    }

    public void initialize() {
        this.totalImpotCommunal = 0.0;
        this.veranlagungsgemeindeCode = 0L;
        this.partPrivilegiee = 0.0;
        this.centimesAdditionnels = 0.0;
        this.impotPrivilegieRevenu = 0.0;
        this.soldeImpotBaseSurRevenu = 0.0;
        this.impotBaseSurFortune = 0.0;
        this.impotPrivilegieFortune = 0.0;
        this.soldeImpotBaseSurFortune = 0.0;
        this.impotCommunal = 0.0;
        this.impotCantonalSurRevenuParCommune = 0.0;
        this.impotCantonalSurFortuneParCommune = 0.0;
        GemeindeSteuerModel.singleton().initializeSteuerBerechnungCorrect(true);
        GemeindeSteuerModel.singleton().initializeContribuableNormal(true);
        CentimesAdditionnelsPartPrivilegieeModel.singleton().initialize();
    }
}

