/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.expertdisplay;

import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.util.ZipHelper;
import ch.dvbern.tax.ge.pp.engine.expertdisplay.BarcodeHelper;
import ch.dvbern.tax.ge.pp.engine.expertdisplay.BarcodeItem;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Random;

public class GePPBarcodeGenerator
implements Barcode2DGenerator {
    private static final String ENCODING = "UTF-8";
    private Random random = new Random();
    private String lastname;
    private String firstname;
    private String codeDeclaration;

    public byte[] generateId(ExpertDisplayModel.RequestContext req) {
        byte[] id = new byte[4];
        id[0] = 3;
        id[1] = 1;
        byte[] rand = new byte[2];
        this.random.nextBytes(rand);
        id[2] = rand[0];
        id[3] = rand[1];
        return id;
    }

    public byte getContentType() {
        return 0;
    }

    public byte[] generateData(ExpertDisplayModel.RequestContext requestContext) {
        ExpertDisplayModel.ProtectedMap dataModel = requestContext.getDataModel();
        Map logicModel = requestContext.getLogicModelItems();
        try {
            byte[] data = this.generateBarcodeContent(dataModel, logicModel);
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] generateBarcodeContent(ExpertDisplayModel.ProtectedMap dataModel, Map logicModel) throws Exception {
        String anneeTaxation = this.getStringValue(dataModel, "Stammdaten.Declaration.PeriodeTaxation");
        String firstname = this.getStringValue(dataModel, "Stammdaten.Contribuable.Prenom");
        String lastname = this.getStringValue(dataModel, "Stammdaten.Contribuable.Nom");
        String addr = this.getStringValue(dataModel, "Stammdaten.Declaration.RueNo");
        String zip = this.getStringValue(dataModel, "Stammdaten.Declaration.Npa");
        String city = this.getStringValue(dataModel, "Stammdaten.Declaration.Localite");
        String noContribuable = this.getStringValue(dataModel, "Stammdaten.Declaration.NoContribuableBarcode");
        String codeDeclaration = this.getStringValue(dataModel, "Stammdaten.Declaration.CodeDeclarationBarcode");
        this.lastname = lastname;
        this.firstname = firstname;
        this.codeDeclaration = codeDeclaration;
        firstname = BarcodeItem.encode(firstname);
        lastname = BarcodeItem.encode(lastname);
        addr = BarcodeItem.encode(addr);
        zip = BarcodeItem.encode(zip);
        city = BarcodeItem.encode(city);
        String content = BarcodeHelper.generate(dataModel, logicModel, anneeTaxation, firstname, lastname, addr, zip, city, noContribuable, codeDeclaration);
        byte[] data = content.getBytes(ENCODING);
        String sDebugEnabled = TaxmeConfig.getString((String)"DebugEnabled");
        if (sDebugEnabled != null && sDebugEnabled.equals("true")) {
            this.createAsciiFile(noContribuable, data);
        }
        String filename = noContribuable.concat(".xml");
        return ZipHelper.zip((byte[])data, (String)filename);
    }

    private String getStringValue(ExpertDisplayModel.ProtectedMap dataModel, String key) {
        ModelItemDTO mi = dataModel.get((Object)key);
        if (mi != null && mi.getValue() != null) {
            return mi.getValue().toString();
        }
        return "";
    }

    private void createAsciiFile(String zpv, byte[] content) {
        try {
            FileOutputStream os = new FileOutputStream(zpv + "interface.xml");
            os.write(content);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public String getCodeDeclaration() {
        return this.codeDeclaration;
    }
}

