/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.expertdisplay;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class BarcodeItem
implements Comparable {
    private String formular;
    private String code;
    private String format;
    private Object value;
    private String key;
    private boolean isWarning;
    private List indizes;

    public BarcodeItem(String formular, String code, String format, Object val, String key, List indizes, boolean isWarning) {
        this.code = code;
        this.format = format;
        this.formular = formular;
        this.key = key;
        this.indizes = indizes;
        this.isWarning = isWarning;
        this.value = this.convertValue(val);
    }

    public BarcodeItem(String formular, String code, String format, Object val, String key, List indizes) {
        this.code = code;
        this.format = format;
        this.formular = formular;
        this.value = this.convertValue(val);
        this.key = key;
        this.indizes = indizes;
        this.isWarning = false;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormular() {
        return this.formular;
    }

    public void setFormular(String formular) {
        this.formular = formular;
    }

    public String getValue() {
        return (String)this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    private String convertValue(Object val) {
        if (this.getFormat().equals("A")) {
            return BarcodeItem.encode(val.toString());
        }
        if (this.getFormat().startsWith("F")) {
            int numberAfterComa = Integer.parseInt(this.getFormat().substring(1));
            StringBuffer buf = new StringBuffer("0.");
            for (int i = 0; i < numberAfterComa; ++i) {
                buf.append("0");
            }
            DecimalFormatSymbols symbol = new DecimalFormatSymbols();
            symbol.setDecimalSeparator('.');
            DecimalFormat df = new DecimalFormat(buf.toString(), symbol);
            return df.format(((Number)val).doubleValue());
        }
        if (this.getFormat().equals("N")) {
            return val.toString();
        }
        if (this.getFormat().equals("D")) {
            Date dateToDisplay = (Date)val;
            return new SimpleDateFormat("yyyyMMdd").format(dateToDisplay);
        }
        if (this.getFormat().equals("DM")) {
            Date dateToDisplay = (Date)val;
            return new SimpleDateFormat("ddMM").format(dateToDisplay);
        }
        if (this.getFormat().equals("C")) {
            System.out.println("this.getCode() = " + this.getCode());
            if (this.getCode().equals("2.1.1_1")) {
                if (val instanceof Long) {
                    long longValue = (Long)val;
                    if (longValue == 1L) {
                        return "AS";
                    }
                    if (longValue == 2L) {
                        return "AL";
                    }
                    return BarcodeItem.encode(val.toString());
                }
                return "";
            }
            return "";
        }
        return BarcodeItem.encode(val.toString());
    }

    public String getCodeF() {
        StringTokenizer token;
        String code = this.getCode();
        if (code.indexOf("-") != -1) {
            token = new StringTokenizer(code, "-");
        } else if (code.indexOf("_") != -1) {
            token = new StringTokenizer(code, "_");
        } else if (code.indexOf("*") != -1) {
            token = new StringTokenizer(code, "*");
        } else {
            return code;
        }
        return token.nextToken();
    }

    public String getCodeC() {
        StringTokenizer token;
        String code = this.getCode();
        if (code.indexOf("-") != -1) {
            token = new StringTokenizer(code, "-");
        } else if (code.indexOf("_") != -1) {
            token = new StringTokenizer(code, "_");
        } else if (code.indexOf("*") != -1) {
            token = new StringTokenizer(code, "*");
        } else {
            return code;
        }
        token.nextToken();
        return token.nextToken();
    }

    public int compareTo(Object toCompare) {
        if (this.getKey() != null && ((BarcodeItem)toCompare).getKey() != null) {
            return this.getKey().compareTo(((BarcodeItem)toCompare).getKey());
        }
        return 0;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List getIndizes() {
        return this.indizes;
    }

    public void setIndizes(List indizes) {
        this.indizes = indizes;
    }

    public static String encode(String parm) {
        StringBuffer buffer = new StringBuffer(parm);
        int index = 0;
        for (int i = 0; i < buffer.length(); ++i) {
            if (buffer.toString().indexOf("&", index) == -1) continue;
            buffer.replace(buffer.toString().indexOf("&", index), buffer.toString().indexOf("&", index) + 1, "&amp;");
            index = buffer.toString().indexOf("&", index) + 1;
        }
        while (buffer.toString().indexOf("'") != -1) {
            buffer.replace(buffer.toString().indexOf("'"), buffer.toString().indexOf("'") + 1, "&apos;");
            index = buffer.toString().indexOf("'") + 1;
        }
        while (buffer.toString().indexOf("<") != -1) {
            buffer.replace(buffer.toString().indexOf("<"), buffer.toString().indexOf("<") + 1, "&lt;");
            index = buffer.toString().indexOf("<") + 1;
        }
        while (buffer.toString().indexOf(">") != -1) {
            buffer.replace(buffer.toString().indexOf(">"), buffer.toString().indexOf(">") + 1, "&gt;");
            index = buffer.toString().indexOf(">") + 1;
        }
        while (buffer.toString().indexOf("\"") != -1) {
            buffer.replace(buffer.toString().indexOf("\""), buffer.toString().indexOf("\"") + 1, "&quot;");
            index = buffer.toString().indexOf("\"") + 1;
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getFormular() + " " + this.getCode() + " " + this.getFormat() + " " + this.getValue();
    }
}

