/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.expertdisplay;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.engine.expertdisplay.BarcodeItem;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;

class BarcodeHelper {
    protected static final char SPACE = ' ';
    protected static final String CRLF = "\r\n";
    protected static final String QUOTE = "\"";
    protected static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    protected static final String BEGIN_DOC = "<doc>";
    protected static final String END_DOC = "</doc>";
    protected static final String INTERFACE_HEADER = "ii";
    protected static final String INTERFACE_DEF = "id";
    protected static final String BEGIN_FORMULAR_HEADER = "<fh id=";
    protected static final String END_FORMULAR_HEADER = "</fh>";
    protected static final String FORMULAR_DESC = "desc=";
    protected static final String BEGIN_FORMULAR_DATA = "<fd>";
    protected static final String END_FORMULAR_DATA = "</fd>";
    protected static final String BEGIN_TABLE = "<tb>";
    protected static final String END_TABLE = "</tb>";
    protected static final String BEGIN_TABLE_ROW = "<td>";
    protected static final String END_TABLE_ROW = "</td>";
    protected static final String BEGIN_TAG = "<";
    protected static final String END_TAG = "/>";
    protected static final String END_LINE_TAG = ">";
    protected static final String PROVIDER_GETAX = "GeTax";
    protected static final String PERIOD = "period=";
    protected static final String DATE_NOW = "dategeneration=";
    protected static final String PROVIDER = "provider=";
    protected static final String VERSION = "version=";
    protected static final String DEPARTDECES = "departdeces=";
    protected static final String FIRSTNAME = "firstname=";
    protected static final String LASTNAME = "lastname=";
    protected static final String ADDRESS = "addr=";
    protected static final String ZIP = "zip=";
    protected static final String CITY = "city=";
    protected static final String NO_CONTRIBUABLE = "sno=";
    protected static final String CODE_DECLARATION = "iddecla=";
    protected static final String BEGIN_FIELD = "<dr f=";
    protected static final String CODE = "c=";
    protected static final String VALUE = "v=";

    private BarcodeHelper() {
    }

    public static String generate(ExpertDisplayModel.ProtectedMap dataModel, Map logicModel, String anneeTaxation, String firstname, String lastname, String addr, String zip, String city, String noContribuable, String codeDeclaration) throws Exception {
        String now = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
        String provider = PROVIDER_GETAX;
        String version = BarcodeHelper.getBarcodeVersion(anneeTaxation);
        StringBuffer buf = new StringBuffer();
        buf.append(BarcodeHelper.generateBeginDoc());
        buf.append(BarcodeHelper.generateBeginFile(anneeTaxation, now, provider, version));
        buf.append(BarcodeHelper.generateTaxInformation(firstname, lastname, addr, zip, city, noContribuable, codeDeclaration));
        BarcodeStructure barcodeStructure = BarcodeHelper.generateBarcodeStructure();
        BarcodeHelper.generateBarcodeData(barcodeStructure, dataModel, logicModel);
        BarcodeHelper.writeBarcodeData(buf, barcodeStructure.getRoot());
        buf.append(BarcodeHelper.generateEndDoc());
        return buf.toString();
    }

    private static String getBarcodeVersion(String anneeTaxation) {
        StringBuffer buf = new StringBuffer();
        String version = TaxmeConfig.getApplicationVersion();
        int dot = version.indexOf(".");
        buf.append(anneeTaxation);
        buf.append("-");
        buf.append(version.substring(dot - 1));
        return buf.toString();
    }

    private static void writeBarcodeData(StringBuffer buf, Map barcodeData) {
        for (Object o : barcodeData.values()) {
            if (o instanceof BarcodeLevelFormular) {
                BarcodeLevelFormular blf = (BarcodeLevelFormular)o;
                for (Map tableEntryData : ((Map)o).values()) {
                    buf.append(BarcodeHelper.generateBeginFormular(blf.formKey, blf.formName));
                    BarcodeHelper.writeBarcodeData(buf, tableEntryData);
                    buf.append(BarcodeHelper.generateEndFormular());
                }
                continue;
            }
            if (o instanceof Map) {
                buf.append(BarcodeHelper.generateTableBegin());
                for (Map tableEntryData : ((Map)o).values()) {
                    buf.append(BarcodeHelper.generateTableLineBegin());
                    BarcodeHelper.writeBarcodeData(buf, tableEntryData);
                    buf.append(BarcodeHelper.generateTableLineEnd());
                }
                buf.append(BarcodeHelper.generateTableEnd());
                continue;
            }
            if (o instanceof BarcodeItem) {
                buf.append(BarcodeHelper.generateField((BarcodeItem)o));
                continue;
            }
            if (o == null) continue;
            buf.append(o.toString());
        }
    }

    private static void generateBarcodeData(BarcodeStructure barcodeStructure, ExpertDisplayModel.ProtectedMap dataModel, Map logicModel) {
        LinkedList set = new LinkedList(dataModel.keySet());
        Collections.sort(set);
        for (String dmk : set) {
            ModelItemDTO modelItemDTO = dataModel.get((Object)dmk);
            LogicModelItem logicModelItem = (LogicModelItem)logicModel.get(EngineUtil.removeTableIndices((String)dmk));
            if (logicModelItem == null) continue;
            List pkts = logicModelItem.getPersistenceKeyTemplates();
            BarcodeItem item = null;
            for (String persistenceKey : pkts) {
                Object value;
                if (persistenceKey.indexOf(";") < 0) continue;
                persistenceKey = EngineUtil.convertPersistenceKey((String)persistenceKey, (String)dmk);
                StringTokenizer tokenizer2 = new StringTokenizer(persistenceKey, ";");
                String formular = tokenizer2.nextToken();
                String code = tokenizer2.nextToken();
                String format = tokenizer2.nextToken();
                if (modelItemDTO == null) continue;
                boolean isWarning = modelItemDTO.getState() == 2;
                LinkedList<Long> indizes = new LinkedList<Long>();
                if (tokenizer2.hasMoreTokens()) {
                    String next = tokenizer2.nextToken();
                    if (next.length() == 10) {
                        indizes.add(Long.valueOf(next.substring(0, 5)));
                        next = next.substring(5);
                    }
                    indizes.add(Long.valueOf(next));
                }
                if ((value = modelItemDTO.getValue()) == null || value.equals("0")) continue;
                item = new BarcodeItem(formular, code, format, value, dmk, indizes, isWarning);
                System.out.println(item);
                StringBuffer sb = new StringBuffer(formular).append(";").append(code);
                Map itemLevel = BarcodeHelper.getItemLevel(barcodeStructure, sb.toString(), indizes);
                if (itemLevel == null) continue;
                System.out.println(sb);
                itemLevel.put(sb.toString(), item);
            }
        }
    }

    private static Map getItemLevel(BarcodeStructure barcodeStructure, String key, List indizes) {
        List levels = (List)barcodeStructure.getItems().get(key);
        if (levels == null) {
            return null;
        }
        LinkedHashMap result = barcodeStructure.getRoot();
        for (int i = 1; i < levels.size(); ++i) {
            BarcodeLevel barcodeLevel = (BarcodeLevel)levels.get(i);
            Map indexMap = (Map)result.get(barcodeLevel.getKey());
            if (indexMap == null) {
                indexMap = barcodeLevel.getLevelMap();
                result.put(barcodeLevel.getKey(), indexMap);
            }
            try {
                Object index = indizes.get(i - 1);
                LinkedHashMap currentLevel = (LinkedHashMap)indexMap.get(index);
                if (currentLevel == null) {
                    currentLevel = new LinkedHashMap(barcodeLevel);
                    indexMap.put(index, currentLevel);
                }
                result = currentLevel;
                continue;
            }
            catch (IndexOutOfBoundsException ioobe) {
                System.out.println("warning: missing index in structure " + key);
                return null;
            }
        }
        return result;
    }

    private static BarcodeStructure generateBarcodeStructure() throws Exception {
        File barcodeDefinition = new File("config/cd/resources/barcode.txt");
        BarcodeLevel rootLevel = new BarcodeLevel("root");
        Stack<BarcodeLevel> levelStack = new Stack<BarcodeLevel>();
        levelStack.push(rootLevel);
        int structureId = 0;
        LinkedHashMap barcodeItems = new LinkedHashMap();
        String currentFormKey = null;
        String currentFormName = null;
        boolean isDokumentMehrfachvorkommen = false;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(barcodeDefinition))));
        String line = reader.readLine();
        while (line != null) {
            if (!line.startsWith("#")) {
                BarcodeLevel newLevel;
                if (line.startsWith("<Form")) {
                    StringTokenizer sk = new StringTokenizer(line, ";");
                    sk.nextToken();
                    String formKey = sk.nextToken();
                    String formName = sk.nextToken();
                    currentFormKey = formKey;
                    currentFormName = formName;
                    if (sk.hasMoreTokens()) {
                        isDokumentMehrfachvorkommen = true;
                    } else {
                        ((BarcodeLevel)levelStack.peek()).put("FB" + structureId++, BarcodeHelper.generateBeginFormular(formKey, formName));
                    }
                } else if (line.equals("</Form>")) {
                    if (!isDokumentMehrfachvorkommen) {
                        ((BarcodeLevel)levelStack.peek()).put("FE" + structureId++, BarcodeHelper.generateEndFormular());
                    } else {
                        isDokumentMehrfachvorkommen = false;
                    }
                } else if (line.startsWith("<form-table")) {
                    newLevel = new BarcodeLevelFormular("TFC" + structureId++, currentFormKey, currentFormName);
                    ((BarcodeLevel)levelStack.peek()).put(newLevel.getKey(), null);
                    levelStack.push(newLevel);
                } else if (line.startsWith("</form-table")) {
                    levelStack.pop();
                } else if (line.equals("<table>")) {
                    newLevel = new BarcodeLevel("TC" + structureId++);
                    ((BarcodeLevel)levelStack.peek()).put(newLevel.getKey(), null);
                    levelStack.push(newLevel);
                } else if (line.equals("</table>")) {
                    levelStack.pop();
                } else {
                    ((BarcodeLevel)levelStack.peek()).put(line, null);
                    barcodeItems.put(line, new LinkedList(levelStack));
                }
            }
            line = reader.readLine();
        }
        reader.close();
        return new BarcodeStructure(barcodeItems, rootLevel);
    }

    private static String generateBeginDoc() {
        StringBuffer buf = new StringBuffer();
        buf.append(XML_VERSION);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateBeginFile(String period, String date, String provider, String version) {
        StringBuffer buf = new StringBuffer();
        buf.append(BEGIN_DOC);
        buf.append(CRLF);
        buf.append(BEGIN_TAG);
        buf.append(INTERFACE_HEADER);
        buf.append(' ');
        buf.append(PERIOD);
        buf.append(QUOTE + period + QUOTE);
        buf.append(' ');
        buf.append(DATE_NOW);
        buf.append(QUOTE + date + QUOTE);
        buf.append(' ');
        buf.append(PROVIDER);
        buf.append(QUOTE + provider + QUOTE);
        buf.append(' ');
        buf.append(VERSION);
        buf.append(QUOTE + version + QUOTE);
        buf.append(' ');
        buf.append(DEPARTDECES);
        buf.append("\"0\"");
        buf.append(END_TAG);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTaxInformation(String firstname, String lastname, String addr, String zip, String city, String noContribuable, String codeDeclaration) {
        StringBuffer buf = new StringBuffer();
        buf.append(BEGIN_TAG);
        buf.append(INTERFACE_DEF);
        buf.append(' ');
        buf.append("firstname=\"" + firstname + QUOTE + ' ');
        buf.append("lastname=\"" + lastname + QUOTE + ' ');
        buf.append(ADDRESS);
        buf.append(QUOTE + addr + QUOTE + ' ');
        buf.append(ZIP);
        buf.append(QUOTE + zip + QUOTE + ' ');
        buf.append(CITY);
        buf.append(QUOTE + city + QUOTE + ' ');
        buf.append(NO_CONTRIBUABLE);
        buf.append(QUOTE + noContribuable + QUOTE + ' ');
        if (codeDeclaration != null && !codeDeclaration.equals("")) {
            buf.append(CODE_DECLARATION);
            buf.append(QUOTE + codeDeclaration + QUOTE + ' ');
        }
        buf.append(END_TAG);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateEndDoc() {
        StringBuffer buf = new StringBuffer();
        buf.append(END_DOC);
        return buf.toString();
    }

    private static String generateBeginFormular(String formularId, String formularDesc) {
        StringBuffer buf = new StringBuffer();
        buf.append(BEGIN_FORMULAR_HEADER);
        buf.append(QUOTE + formularId + QUOTE + ' ');
        buf.append(FORMULAR_DESC);
        buf.append(QUOTE + formularDesc + QUOTE);
        buf.append(END_LINE_TAG);
        buf.append(CRLF);
        buf.append(BEGIN_FORMULAR_DATA);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateEndFormular() {
        StringBuffer buf = new StringBuffer();
        buf.append(END_FORMULAR_DATA);
        buf.append(CRLF);
        buf.append(END_FORMULAR_HEADER);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableBegin() {
        StringBuffer buf = new StringBuffer();
        buf.append(BEGIN_TABLE);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableEnd() {
        StringBuffer buf = new StringBuffer();
        buf.append(END_TABLE);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableLineBegin() {
        StringBuffer buf = new StringBuffer();
        buf.append(BEGIN_TABLE_ROW);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableLineEnd() {
        StringBuffer buf = new StringBuffer();
        buf.append(END_TABLE_ROW);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateField(BarcodeItem item) {
        StringBuffer buf = new StringBuffer();
        buf.append(BEGIN_FIELD);
        buf.append(QUOTE + item.getCodeF() + QUOTE);
        buf.append(' ');
        buf.append(CODE);
        buf.append(QUOTE + item.getCodeC() + QUOTE);
        buf.append(' ');
        buf.append(VALUE);
        buf.append(QUOTE + item.getValue() + QUOTE);
        buf.append(END_TAG);
        buf.append(CRLF);
        return buf.toString();
    }

    static class BarcodeLevelFormular
    extends BarcodeLevel {
        private static final long serialVersionUID = 1L;
        private String formKey;
        private String formName;

        BarcodeLevelFormular(String key, String formKey, String formName) {
            super(key);
            this.formKey = formKey;
            this.formName = formName;
        }

        private BarcodeLevelFormular(String formKey, String formName) {
            this.formKey = formKey;
            this.formName = formName;
        }

        public Map getLevelMap() {
            return new BarcodeLevelFormular(this.formKey, this.formName);
        }
    }

    static class BarcodeLevel
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private String key;

        BarcodeLevel(String key) {
            this.key = key;
        }

        public BarcodeLevel() {
        }

        public String getKey() {
            return this.key;
        }

        public Map getLevelMap() {
            return new LinkedHashMap();
        }
    }

    static class BarcodeStructure {
        private Map items;
        private BarcodeLevel root;

        BarcodeStructure(Map items, BarcodeLevel root) {
            this.items = items;
            this.root = root;
        }

        public BarcodeLevel getRoot() {
            return this.root;
        }

        public Map getItems() {
            return this.items;
        }
    }
}

