/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import java.util.Map;
import java.util.StringTokenizer;

public class CFDetermineImpotSupplFortune
implements CalcItem {
    DataResource dataResource;
    Object[] stufen;

    public CFDetermineImpotSupplFortune(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        Map optionMap;
        Object fortuneObj = stack.pop();
        long fortune = 0L;
        long type = 0L;
        if (fortuneObj != null && fortuneObj instanceof Number) {
            fortune = ((Number)fortuneObj).longValue();
        }
        if ((optionMap = this.dataResource.get("impotSupplFortune", null, null)) != null) {
            this.stufen = optionMap.keySet().toArray();
            long montant = fortune - fortune % 10L;
            double impot = 0.0;
            double y1 = 0.0;
            String stufe = this.getStufe(montant);
            if (stufe != null) {
                long milliersSupplementaires = montant - Long.parseLong(stufe);
                double impotAnnuel = Double.parseDouble(this.getImpotAnnuel(montant));
                double montantParMilleFrancsSupp = Double.parseDouble(this.getMontantParMilleFrancsSupp(montant));
                impot = impotAnnuel + (double)milliersSupplementaires * montantParMilleFrancsSupp / 1000.0;
            }
            double d = Math.round(impot * 20.0);
            stack.push((Object)new Double(d / 20.0));
        }
    }

    private String getStufe(long montant) {
        long maxStufe = -1L;
        for (int i = 1; i < this.stufen.length; ++i) {
            long currentStuffe = Long.parseLong((String)this.stufen[i]);
            long stufeBefore = Long.parseLong((String)this.stufen[i - 1]);
            if (currentStuffe > maxStufe) {
                maxStufe = currentStuffe;
            }
            if (currentStuffe <= montant) continue;
            if (i == 0) {
                return null;
            }
            return String.valueOf(stufeBefore);
        }
        return String.valueOf(maxStufe);
    }

    public String getImpotAnnuel(long montant) {
        String stufe = this.getStufe(montant);
        OptionItemDTO item = (OptionItemDTO)this.dataResource.get("impotSupplFortune", null, null).get(stufe);
        String impotAnnuel = null;
        if (item != null) {
            String values = (String)item.getText();
            StringTokenizer tokenizer = new StringTokenizer(values, "\u00ac\u00a2");
            impotAnnuel = tokenizer.nextToken();
            String par1000CHFSupp = tokenizer.nextToken();
        }
        return impotAnnuel;
    }

    public String getMontantParMilleFrancsSupp(long montant) {
        String stufe = this.getStufe(montant);
        OptionItemDTO item = (OptionItemDTO)this.dataResource.get("impotSupplFortune", null, null).get(stufe);
        String par1000CHFSupp = null;
        if (item != null) {
            String values = (String)item.getText();
            StringTokenizer tokenizer = new StringTokenizer(values, "\u00ac\u00a2");
            String impotAnnuel = tokenizer.nextToken();
            par1000CHFSupp = tokenizer.nextToken();
        }
        return par1000CHFSupp;
    }
}

