/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import java.util.Map;
import java.util.StringTokenizer;

public class CFDetermineImpotSelonBareme
implements CalcItem {
    DataResource dataResource;
    Object[] stufen;

    public CFDetermineImpotSelonBareme(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        Object baremeObj = stack.pop();
        Object montantObj = stack.pop();
        int MARIE = 2;
        long montant = 0L;
        long bareme = 0L;
        double steuer = 0.0;
        if (montantObj != null && montantObj instanceof Number) {
            montant = ((Number)montantObj).longValue();
        }
        if (baremeObj != null && baremeObj instanceof Number) {
            bareme = ((Number)baremeObj).longValue();
        }
        Map optionMap = this.dataResource.get("bareme", null, null);
        if (montant == 0L) {
            stack.push((Object)new Double(0.0));
        } else if (optionMap != null) {
            this.stufen = optionMap.keySet().toArray();
            if (bareme == (long)MARIE) {
                steuer = Double.parseDouble(this.getImpotMarie(montant));
                if (steuer > 0.0) {
                    double weitere = 0.0;
                    long stufe = Long.parseLong(this.getStufe(montant));
                    if (stufe != montant) {
                        weitere = this.getTauxTrancheMarie(montant);
                    }
                    steuer += (double)(montant - stufe) * weitere / 100.0;
                }
            } else {
                steuer = Double.parseDouble(this.getImpotSeul(montant));
                if (steuer > 0.0) {
                    double weitere = 0.0;
                    long stufe = Long.parseLong(this.getStufe(montant));
                    if (stufe != montant) {
                        weitere = this.getTauxTrancheSeul(montant);
                    }
                    steuer += (double)(montant - stufe) * weitere / 100.0;
                }
            }
            stack.push((Object)new Double(steuer));
        }
    }

    public String getImpotSeul(long lEinkommen) {
        OptionItemDTO item = null;
        String stufe = this.getStufe(lEinkommen);
        String impotSeul = null;
        if (stufe != null) {
            item = (OptionItemDTO)this.dataResource.get("bareme", null, null).get(stufe);
        }
        if (item != null) {
            String values = (String)item.getText();
            StringTokenizer tokenizer = new StringTokenizer(values, "\u00ac\u00a2");
            impotSeul = tokenizer.nextToken();
            String tauxSeul = tokenizer.nextToken();
            String impotMarie = tokenizer.nextToken();
            String tauxMarie = tokenizer.nextToken();
        } else {
            impotSeul = "0";
        }
        return impotSeul;
    }

    public String getImpotMarie(long lEinkommen) {
        OptionItemDTO item = null;
        String stufe = this.getStufe(lEinkommen);
        String impotMarie = null;
        if (stufe != null) {
            item = (OptionItemDTO)this.dataResource.get("bareme", null, null).get(stufe);
        }
        if (item != null) {
            String values = (String)item.getText();
            StringTokenizer tokenizer = new StringTokenizer(values, "\u00ac\u00a2");
            String impotSeul = tokenizer.nextToken();
            String tauxSeul = tokenizer.nextToken();
            impotMarie = tokenizer.nextToken();
            String tauxMarie = tokenizer.nextToken();
        } else {
            impotMarie = "0";
        }
        return impotMarie;
    }

    public String getStufe(long lEinkommen) {
        long maxStufe = -1L;
        for (int i = 0; i < this.stufen.length; ++i) {
            long currentStufe = Long.parseLong((String)this.stufen[i]);
            if (currentStufe > maxStufe) {
                maxStufe = currentStufe;
            }
            if (currentStufe <= lEinkommen) continue;
            if (i == 0) {
                return null;
            }
            return String.valueOf(Long.parseLong((String)this.stufen[i - 1]));
        }
        return String.valueOf(maxStufe);
    }

    public String getStufeSuperior(long lEinkommen) {
        long maxStufe = -1L;
        for (int i = 0; i < this.stufen.length; ++i) {
            long currentStufe = Long.parseLong((String)this.stufen[i]);
            if (currentStufe > maxStufe) {
                maxStufe = currentStufe;
            }
            if (currentStufe <= lEinkommen) continue;
            if (i == 0) {
                return null;
            }
            return String.valueOf(currentStufe);
        }
        return String.valueOf(maxStufe);
    }

    public String getTauxMarie(long lEinkommen) {
        OptionItemDTO item = null;
        String stufe = this.getStufe(lEinkommen);
        String tauxMarie = null;
        if (stufe != null) {
            item = (OptionItemDTO)this.dataResource.get("bareme", null, null).get(stufe);
        }
        if (item != null) {
            String values = (String)item.getText();
            StringTokenizer tokenizer = new StringTokenizer(values, "\u00ac\u00a2");
            String impotSeul = tokenizer.nextToken();
            String tauxSeul = tokenizer.nextToken();
            String impotMarie = tokenizer.nextToken();
            tauxMarie = tokenizer.nextToken();
        } else {
            tauxMarie = "0";
        }
        return tauxMarie;
    }

    public String getTauxSeul(long lEinkommen) {
        OptionItemDTO item = null;
        String stufe = this.getStufe(lEinkommen);
        String tauxSeul = null;
        if (stufe != null) {
            item = (OptionItemDTO)this.dataResource.get("bareme", null, null).get(stufe);
        }
        if (item != null) {
            String values = (String)item.getText();
            StringTokenizer tokenizer = new StringTokenizer(values, "\u00ac\u00a2");
            String impotSeul = tokenizer.nextToken();
            tauxSeul = tokenizer.nextToken();
            String impotMarie = tokenizer.nextToken();
            String tauxMarie = tokenizer.nextToken();
        } else {
            tauxSeul = "0";
        }
        return tauxSeul;
    }

    public double getTauxTrancheMarie(long lEinkommen) {
        String stufe = this.getStufe(lEinkommen);
        String stufeSup = this.getStufeSuperior(lEinkommen);
        double taux = 0.0;
        if (stufe != null && stufeSup != null) {
            long trancheRevenu = Long.parseLong(stufeSup) - Long.parseLong(stufe);
            double impotTranche = Double.parseDouble(this.getImpotMarie(lEinkommen + trancheRevenu)) - Double.parseDouble(this.getImpotMarie(lEinkommen));
            taux = impotTranche / (double)trancheRevenu * 100.0;
        }
        return taux;
    }

    public double getTauxTrancheSeul(long lEinkommen) {
        String stufe = this.getStufe(lEinkommen);
        String stufeSup = this.getStufeSuperior(lEinkommen);
        double taux = 0.0;
        if (stufe != null && stufeSup != null) {
            long trancheRevenu = Long.parseLong(stufeSup) - Long.parseLong(stufe);
            double impotTranche = Double.parseDouble(this.getImpotSeul(lEinkommen + trancheRevenu)) - Double.parseDouble(this.getImpotSeul(lEinkommen));
            taux = impotTranche / (double)trancheRevenu * 100.0;
        }
        return taux;
    }
}

