/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot;

public class GemeindeSteuerModel {
    private static GemeindeSteuerModel gemeindeSteuerModel = null;
    private boolean steuerBerechnungCorrect = true;
    private boolean contribuableNormal = true;
    private long[][] values = new long[46][26];
    private long veranlagungsgemeinde;
    public static final int ANZAHL_RUBRIK = 26;
    public static final int ANZAHL_GEMEINDE = 46;
    public static final long GEMEINDE_CODE_PREFIX = 6600L;
    public static final long FIRST_GE_GEMEINDE_INDEX = 0L;
    public static final long LAST_GE_GEMEINDE_INDEX = 45L;
    public static final long FIRST_GE_GEMEINDE_CODE = 6601L;
    public static final long LAST_GE_GEMEINDE_CODE = 6645L;
    public static final int EINK_UNSELBST_MANN = 0;
    public static final int EINK_UNSELBST_FRAU = 1;
    public static final int EINK_SELBST_MANN = 2;
    public static final int EINK_SELBST_FRAU = 3;
    public static final int VERM_SELBST_MANN = 4;
    public static final int VERM_SELBST_FRAU = 5;
    public static final int EINK_LIEGENSCHAFT = 6;
    public static final int VERM_LIEGENSCHAFT = 7;
    public static final int EINK_ANDERE = 8;
    public static final int VERM_ANDERE = 9;
    public static final int ABZUEGE_EINK_SELBST_MANN = 10;
    public static final int ABZUEGE_EINK_SELBST_FRAU = 11;
    public static final int ABZUEGE_VERM_SELBST_MANN = 12;
    public static final int ABZUEGE_VERM_SELBST_FRAU = 13;
    public static final int ABZUEGE_LIEGENSCHAFT = 14;
    public static final int ENTSPRECHEND_EINK_UNSELBST_MANN = 15;
    public static final int ENTSPRECHEND_EINK_UNSELBST_FRAU = 16;
    public static final int ENTSPRECHEND_EINK_UNSELBST = 17;
    public static final int EINKOMMEN_MINUS_ABZUEGE = 18;
    public static final int VERTEILUNG_NEGATIV_EINKOMMEN = 20;
    public static final int EINKOMMEN_VOR_ANDERE_ABZUEGE = 22;
    public static final int NETTO_EINKOMMEN = 24;
    public static final int NETTO_VERMOEGEN = 25;

    public void addItem(long gemeindeCode, int aRubrik, long aValue) {
        int gemeindeIndex = 0;
        long prefix = 6600L;
        if (gemeindeCode == 0L) {
            return;
        }
        if (this.isGemeindeInGenf(gemeindeCode)) {
            gemeindeIndex = (int)(gemeindeCode - prefix);
            long[] lArray = this.values[gemeindeIndex - 1];
            int n = aRubrik;
            lArray[n] = lArray[n] + aValue;
            this.modifySteuerBerechnungCorrect(true);
        } else {
            gemeindeIndex = (int)(this.getveranlagungsgemeinde() - prefix);
            long[] lArray = this.values[gemeindeIndex - 1];
            int n = aRubrik;
            lArray[n] = lArray[n] + aValue;
            this.modifySteuerBerechnungCorrect(false);
        }
    }

    public void addItem(int gemeinde, int aRubrik, long aValue) {
        if (this.isGemeindeInGenf(gemeinde)) {
            long[] lArray = this.values[gemeinde];
            int n = aRubrik;
            lArray[n] = lArray[n] + aValue;
            this.modifySteuerBerechnungCorrect(true);
        } else {
            int gemeindeIndex = 0;
            long prefix = 6600L;
            gemeindeIndex = (int)(this.getveranlagungsgemeinde() - prefix);
            long[] lArray = this.values[gemeindeIndex - 1];
            int n = aRubrik;
            lArray[n] = lArray[n] + aValue;
            this.modifySteuerBerechnungCorrect(false);
        }
    }

    public long[] getAllRubrikForOneGemeinde(int gemeinde) {
        long[] temp = new long[26];
        for (int i = 0; i < 26; ++i) {
            temp[i] = this.values[gemeinde][i];
        }
        return temp;
    }

    public long getItem(int gemeinde, int rubrik) {
        return this.values[gemeinde][rubrik];
    }

    public long getItem(long gemeindeCode, int rubrik) {
        int gemeindeIndex = 0;
        long prefix = 6600L;
        gemeindeIndex = (int)(gemeindeCode - prefix);
        try {
            return this.values[gemeindeIndex - 1][rubrik];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    public long[] getOneRubrikForAllGemeinde(int rubrik) {
        long[] temp = new long[46];
        for (int i = 0; i < 46; ++i) {
            temp[i] = this.values[i][rubrik];
        }
        return temp;
    }

    public long getSummeEinerRubrik(int rubrik) {
        long summe = 0L;
        for (int i = 0; i < 46; ++i) {
            summe += this.values[i][rubrik];
        }
        return summe;
    }

    public long getTotalEinkommenMinusAbzuege() {
        long summe = 0L;
        for (int i = 0; i < 46; ++i) {
            if (this.values[i][18] <= 0L) continue;
            summe += this.values[i][18];
        }
        return summe;
    }

    public long getveranlagungsgemeinde() {
        return this.veranlagungsgemeinde;
    }

    public void initialize() {
        for (int i = 0; i < 46; ++i) {
            for (int j = 0; j < 26; ++j) {
                this.setItem(i, j, 0L);
            }
        }
    }

    public void initializeContribuableNormal(boolean newContribuableNormal) {
        this.contribuableNormal = newContribuableNormal;
    }

    public void initializeSteuerBerechnungCorrect(boolean newSteuerBerechnungCorrect) {
        this.steuerBerechnungCorrect = newSteuerBerechnungCorrect;
    }

    public boolean isContribuableNormal() {
        return this.contribuableNormal;
    }

    public boolean isGemeindeInGenf(long gemeindeCode) {
        return gemeindeCode >= 6601L && gemeindeCode <= 6645L;
    }

    public boolean isGemeindeInGenf(int gemeindeIndex) {
        return (long)gemeindeIndex >= 0L && (long)gemeindeIndex <= 45L;
    }

    public boolean isSteuerBerechnungCorrect() {
        return this.steuerBerechnungCorrect;
    }

    public void modifyContribuableNormal(boolean newContribuableNormal) {
        this.contribuableNormal &= newContribuableNormal;
    }

    public void modifySteuerBerechnungCorrect(boolean newSteuerBerechnungCorrect) {
        this.steuerBerechnungCorrect &= newSteuerBerechnungCorrect;
    }

    public void setItem(int gemeinde, int aRubrik, long aValue) {
        if (this.isGemeindeInGenf(gemeinde)) {
            this.values[gemeinde][aRubrik] = aValue;
            this.modifySteuerBerechnungCorrect(true);
        } else {
            int gemeindeIndex = 0;
            long prefix = 6600L;
            gemeindeIndex = (int)(this.getveranlagungsgemeinde() - prefix);
            this.values[gemeindeIndex - 1][aRubrik] = aValue;
            this.modifySteuerBerechnungCorrect(false);
        }
    }

    public void setItem(long gemeindeCode, int aRubrik, long aValue) {
        int gemeindeIndex = 0;
        long prefix = 6600L;
        if (gemeindeCode == 0L) {
            return;
        }
        if (this.isGemeindeInGenf(gemeindeCode)) {
            gemeindeIndex = (int)(gemeindeCode - prefix);
            this.values[gemeindeIndex - 1][aRubrik] = aValue;
            this.modifySteuerBerechnungCorrect(true);
        } else {
            gemeindeIndex = (int)(this.getveranlagungsgemeinde() - prefix);
            this.values[gemeindeIndex - 1][aRubrik] = aValue;
            this.modifySteuerBerechnungCorrect(false);
        }
    }

    public void setveranlagungsgemeinde(long aGemeindeCode) {
        this.veranlagungsgemeinde = aGemeindeCode;
    }

    public static GemeindeSteuerModel singleton() {
        if (gemeindeSteuerModel == null) {
            gemeindeSteuerModel = new GemeindeSteuerModel();
        }
        return gemeindeSteuerModel;
    }
}

