/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.calculimpot.GemeindeSteuerModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;

public class GemeindeSteuer {
    private static final Logger log = Logger.getLogger(GemeindeSteuer.class);
    private LogicModelItem.ProtectedMap dataModel = null;
    GemeindeSteuerModel aGemeindeSteuerModel = null;

    public GemeindeSteuer() {
    }

    public GemeindeSteuer(LogicModelItem.ProtectedMap dataModel, long aGemeindeCode) {
        this.dataModel = dataModel;
        this.aGemeindeSteuerModel = GemeindeSteuerModel.singleton();
        this.aGemeindeSteuerModel.setveranlagungsgemeinde(aGemeindeCode);
    }

    public GemeindeSteuerModel getAGemeindeSteuerModel() {
        return this.aGemeindeSteuerModel;
    }

    public long getAnzahlGemeinde() {
        return 46L;
    }

    public long getNettoEinkommenFuerEinGemeinde(int gemeindeIndex) {
        return this.aGemeindeSteuerModel.getItem(gemeindeIndex, 24);
    }

    public long getNettoEinkommenFuerEinGemeinde(long gemeindeCode) {
        return this.aGemeindeSteuerModel.getItem(gemeindeCode, 24);
    }

    public long getNettoVermoegeFuerEinGemeinde(int gemeindeIndex) {
        return this.aGemeindeSteuerModel.getItem(gemeindeIndex, 25);
    }

    public long getNettoVermoegenFuerEinGemeinde(long gemeindeCode) {
        return this.aGemeindeSteuerModel.getItem(gemeindeCode, 25);
    }

    public long getTotalNettoEinkommen() {
        return this.aGemeindeSteuerModel.getSummeEinerRubrik(24);
    }

    public long getTotalNettoVermoegen() {
        return this.aGemeindeSteuerModel.getSummeEinerRubrik(25);
    }

    protected Collection getTableRowIndexes(String dmk, LogicModelItem.ProtectedMap dm) {
        Set set = (Set)this.getValue(dmk, dm);
        if (set == null || set.isEmpty()) {
            return set;
        }
        ArrayList sortedKeys = new ArrayList(set);
        Collections.sort(sortedKeys);
        return sortedKeys;
    }

    protected Object getValue(String dmk, LogicModelItem.ProtectedMap dm) {
        ModelItemDTO mi = dm.get((Object)dmk);
        if (mi != null) {
            return mi.getValue();
        }
        return null;
    }

    protected long getItemLongValue(String dmk) {
        Object value = this.getValue(dmk, this.dataModel);
        if (value != null && value instanceof Long) {
            return (Long)value;
        }
        return 0L;
    }

    public void setNettoEinkommenUndVermoegenProGemeinde() {
        long summeVermoegen;
        int i;
        int i2;
        long deduction;
        long fortune;
        long revenu;
        long value;
        long commune;
        String basekey;
        int i3;
        this.aGemeindeSteuerModel.initialize();
        String tableName = null;
        Collection coll = null;
        long autreRevenuGeneve = 0L;
        long autreFortuneGeneve = 0L;
        if (log.isDebugEnabled()) {
            log.debug((Object)"----------------------------------------");
            log.debug((Object)"setNettoEinkommenUndVermoegenProGemeinde");
            log.debug((Object)"----------------------------------------");
        }
        if ((coll = this.getTableRowIndexes(tableName = "Revenu.ActiviteDependantContribuable.ActiviteDependantContribuable", this.dataModel)) != null && !coll.isEmpty()) {
            for (String key : coll) {
                String basekey2 = tableName + "." + key;
                long commune2 = this.getItemLongValue(basekey2 + ".Commune");
                long value2 = this.getItemLongValue(basekey2 + ".RevenuBrut");
                this.aGemeindeSteuerModel.addItem(commune2, 0, value2);
            }
        }
        long bonus = 0L;
        long communeBonus = 0L;
        long tantiemes = 0L;
        long communeTantiemes = 0L;
        long actions = 0L;
        long communeActions = 0L;
        long vacances = 0L;
        long communeVacances = 0L;
        long prestations = 0L;
        long communePrestations = 0L;
        long autreRevenu = 0L;
        long autreFortune = 0L;
        long autreCommune = 0L;
        long deductionActiviteDependanteContribuable = 0L;
        long deductionActiviteDependanteConjoint = 0L;
        bonus = this.getItemLongValue("Revenu.AutresRevenusContribuable.BonusRevenu");
        communeBonus = this.getItemLongValue("Revenu.AutresRevenusContribuable.BonusCommune");
        this.aGemeindeSteuerModel.addItem(communeBonus, 0, bonus);
        tantiemes = this.getItemLongValue("Revenu.AutresRevenusContribuable.TantiemesRevenu");
        communeTantiemes = this.getItemLongValue("Revenu.AutresRevenusContribuable.TantiemesCommune");
        this.aGemeindeSteuerModel.addItem(communeTantiemes, 0, tantiemes);
        actions = this.getItemLongValue("Revenu.AutresRevenusContribuable.ActionsRevenu");
        communeActions = this.getItemLongValue("Revenu.AutresRevenusContribuable.ActionsCommune");
        this.aGemeindeSteuerModel.addItem(communeActions, 0, actions);
        vacances = this.getItemLongValue("Revenu.AutresRevenusContribuable.VacancesRevenu");
        communeVacances = this.getItemLongValue("Revenu.AutresRevenusContribuable.VacancesCommune");
        this.aGemeindeSteuerModel.addItem(communeVacances, 0, vacances);
        prestations = this.getItemLongValue("Revenu.AutresRevenusContribuable.PrestationsRevenu");
        communePrestations = this.getItemLongValue("Revenu.AutresRevenusContribuable.PrestationsCommune");
        this.aGemeindeSteuerModel.addItem(communePrestations, 0, prestations);
        if (log.isDebugEnabled()) {
            i3 = 0;
            while (true) {
                if (i3 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i3, 0) != 0L) {
                    log.debug((Object)("Revenu d\u00e9pendant Contribuable [" + i3 + "] : " + this.aGemeindeSteuerModel.getItem(i3, 0)));
                }
                ++i3;
            }
        }
        if ((coll = this.getTableRowIndexes(tableName = "Revenu.ActiviteDependantConjoint.ActiviteDependantConjoint", this.dataModel)) != null && !coll.isEmpty()) {
            for (String key : coll) {
                basekey = tableName + "." + key;
                commune = this.getItemLongValue(basekey + ".Commune");
                value = this.getItemLongValue(basekey + ".RevenuBrut");
                this.aGemeindeSteuerModel.addItem(commune, 1, value);
            }
        }
        bonus = this.getItemLongValue("Revenu.AutresRevenusConjoint.BonusRevenu");
        communeBonus = this.getItemLongValue("Revenu.AutresRevenusConjoint.BonusCommune");
        this.aGemeindeSteuerModel.addItem(communeBonus, 1, bonus);
        tantiemes = this.getItemLongValue("Revenu.AutresRevenusConjoint.TantiemesRevenu");
        communeTantiemes = this.getItemLongValue("Revenu.AutresRevenusConjoint.TantiemesCommune");
        this.aGemeindeSteuerModel.addItem(communeTantiemes, 1, tantiemes);
        actions = this.getItemLongValue("Revenu.AutresRevenusConjoint.ActionsRevenu");
        communeActions = this.getItemLongValue("Revenu.AutresRevenusConjoint.ActionsCommune");
        this.aGemeindeSteuerModel.addItem(communeActions, 1, actions);
        vacances = this.getItemLongValue("Revenu.AutresRevenusConjoint.VacancesRevenu");
        communeVacances = this.getItemLongValue("Revenu.AutresRevenusConjoint.VacancesCommune");
        this.aGemeindeSteuerModel.addItem(communeVacances, 1, vacances);
        prestations = this.getItemLongValue("Revenu.AutresRevenusConjoint.PrestationsRevenu");
        communePrestations = this.getItemLongValue("Revenu.AutresRevenusConjoint.PrestationsCommune");
        this.aGemeindeSteuerModel.addItem(communePrestations, 1, prestations);
        if (log.isDebugEnabled()) {
            i3 = 0;
            while (true) {
                if (i3 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i3, 1) != 0L) {
                    log.debug((Object)("Revenu d\u00e9pendant Conjoint [" + i3 + "] : " + this.aGemeindeSteuerModel.getItem(i3, 1)));
                }
                ++i3;
            }
        }
        if ((coll = this.getTableRowIndexes(tableName = "Revenu.ActiviteIndependante.Independant", this.dataModel)) != null && !coll.isEmpty()) {
            for (String key : coll) {
                basekey = tableName + "." + key;
                commune = this.getItemLongValue(basekey + ".CoordonneesEntreprise.Commune");
                revenu = this.getItemLongValue(basekey + ".PertesEtProfits.BeneficeNet");
                fortune = this.getItemLongValue(basekey + ".Bilan.TotalCapital");
                deduction = this.getItemLongValue(basekey + ".Deductions.TotalDeductionsICC");
                this.aGemeindeSteuerModel.addItem(commune, 2, revenu);
                this.aGemeindeSteuerModel.addItem(commune, 4, fortune);
                this.aGemeindeSteuerModel.addItem(commune, 10, deduction);
            }
        }
        if (log.isDebugEnabled()) {
            int i4 = 0;
            while (true) {
                if (i4 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i4, 2) != 0L) {
                    log.debug((Object)("Revenu ind\u00e9pendant Contribuable [" + i4 + "] : " + this.aGemeindeSteuerModel.getItem(i4, 2)));
                }
                if (this.aGemeindeSteuerModel.getItem(i4, 4) != 0L) {
                    log.debug((Object)("Fortune ind\u00e9pendant Contribuable [" + i4 + "] : " + this.aGemeindeSteuerModel.getItem(i4, 4)));
                }
                if (this.aGemeindeSteuerModel.getItem(i4, 10) != 0L) {
                    log.debug((Object)("D\u00e9duction sur revenu ind\u00e9pendant Contribuable [" + i4 + "] : " + this.aGemeindeSteuerModel.getItem(i4, 10)));
                }
                ++i4;
            }
        }
        if ((coll = this.getTableRowIndexes(tableName = "Immeubles.ImmeublesOccupes.ImmeublesOccupes", this.dataModel)) != null && !coll.isEmpty()) {
            for (String key : coll) {
                basekey = tableName + "." + key;
                commune = this.getItemLongValue(basekey + ".CommunesPays");
                revenu = this.getItemLongValue(basekey + ".ValeurLocativeCantonale");
                fortune = this.getItemLongValue(basekey + ".CapitalApresAbattement");
                deduction = this.getItemLongValue(basekey + ".MontantForfaitaireOuEffectifICC");
                this.aGemeindeSteuerModel.addItem(commune, 6, revenu);
                this.aGemeindeSteuerModel.addItem(commune, 7, fortune);
                this.aGemeindeSteuerModel.addItem(commune, 14, deduction);
            }
        }
        if ((coll = this.getTableRowIndexes(tableName = "Immeubles.ImmeublesLoues.ImmeublesLoues", this.dataModel)) != null && !coll.isEmpty()) {
            for (String key : coll) {
                basekey = tableName + "." + key;
                commune = this.getItemLongValue(basekey + ".CommunesPays");
                revenu = this.getItemLongValue(basekey + ".LoyersEncaissesICC");
                fortune = this.getItemLongValue(basekey + ".MontantLoyersCapitalisesOuFortuneImmeuble");
                deduction = this.getItemLongValue(basekey + ".MontantEffectifICC");
                this.aGemeindeSteuerModel.addItem(commune, 6, revenu);
                this.aGemeindeSteuerModel.addItem(commune, 7, fortune);
                this.aGemeindeSteuerModel.addItem(commune, 14, deduction);
            }
        }
        if ((coll = this.getTableRowIndexes(tableName = "Immeubles.ImmeublesCommerciaux.ImmeublesCommerciaux", this.dataModel)) != null && !coll.isEmpty()) {
            for (String key : coll) {
                basekey = tableName + "." + key;
                commune = this.getItemLongValue(basekey + ".CommunesPays");
                revenu = this.getItemLongValue(basekey + ".LoyersEncaissesICC");
                fortune = this.getItemLongValue(basekey + ".CapitalSelonEstimation");
                deduction = this.getItemLongValue(basekey + ".MontantEffectifICC");
                this.aGemeindeSteuerModel.addItem(commune, 6, revenu);
                this.aGemeindeSteuerModel.addItem(commune, 7, fortune);
                this.aGemeindeSteuerModel.addItem(commune, 14, deduction);
            }
        }
        if ((coll = this.getTableRowIndexes(tableName = "Immeubles.ImmeublesPPE.ImmeublesPPE", this.dataModel)) != null && !coll.isEmpty()) {
            for (String key : coll) {
                basekey = tableName + "." + key;
                commune = this.getItemLongValue(basekey + ".CommunesPays");
                revenu = this.getItemLongValue(basekey + ".ValeurLocativeApresAbattementICC");
                fortune = this.getItemLongValue(basekey + ".CapitalApresAbattement");
                deduction = this.getItemLongValue(basekey + ".MontantForfaitaireOuEffectifICC");
                this.aGemeindeSteuerModel.addItem(commune, 6, revenu);
                this.aGemeindeSteuerModel.addItem(commune, 7, fortune);
                this.aGemeindeSteuerModel.addItem(commune, 14, deduction);
            }
        }
        if ((coll = this.getTableRowIndexes(tableName = "Immeubles.ImmeublesHLM.ImmeublesHLM", this.dataModel)) != null && !coll.isEmpty()) {
            for (String key : coll) {
                basekey = tableName + "." + key;
                commune = this.getItemLongValue(basekey + ".CommunesPays");
                revenu = this.getItemLongValue(basekey + ".LoyersEncaissesICC");
                fortune = this.getItemLongValue(basekey + ".EtatDesLoyersCapitalises");
                deduction = this.getItemLongValue(basekey + ".MontantEffectifICC");
                this.aGemeindeSteuerModel.addItem(commune, 6, revenu);
                this.aGemeindeSteuerModel.addItem(commune, 7, fortune);
                this.aGemeindeSteuerModel.addItem(commune, 14, deduction);
            }
        }
        if (log.isDebugEnabled()) {
            int i5 = 0;
            while (true) {
                if (i5 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i5, 6) != 0L) {
                    log.debug((Object)("Revenu sur immeubles [" + i5 + "] : " + this.aGemeindeSteuerModel.getItem(i5, 6)));
                }
                if (this.aGemeindeSteuerModel.getItem(i5, 7) != 0L) {
                    log.debug((Object)("Fortune sur immeubles [" + i5 + "] : " + this.aGemeindeSteuerModel.getItem(i5, 7)));
                }
                if (this.aGemeindeSteuerModel.getItem(i5, 14) != 0L) {
                    log.debug((Object)("D\u00e9ductions sur immeubles [" + i5 + "] : " + this.aGemeindeSteuerModel.getItem(i5, 14)));
                }
                ++i5;
            }
            log.debug((Object)("Revenu total immeubles : " + this.aGemeindeSteuerModel.getSummeEinerRubrik(6)));
            log.debug((Object)("Fortune total immeubles : " + this.aGemeindeSteuerModel.getSummeEinerRubrik(7)));
            log.debug((Object)("D\u00e9duction total immeubles : " + this.aGemeindeSteuerModel.getSummeEinerRubrik(14)));
        }
        autreCommune = this.getItemLongValue("AutreRevenuEtFortune.Autres.RevenuCommuneContribuable");
        autreRevenu = this.getItemLongValue("AutreRevenuEtFortune.Autres.RevenuContribuable");
        if (this.aGemeindeSteuerModel.isGemeindeInGenf(autreCommune)) {
            this.aGemeindeSteuerModel.addItem(autreCommune, 8, autreRevenu);
            autreRevenuGeneve += autreRevenu;
        }
        autreCommune = this.getItemLongValue("AutreRevenuEtFortune.Autres.RevenuCommuneConjoint");
        autreRevenu = this.getItemLongValue("AutreRevenuEtFortune.Autres.RevenuConjoint");
        if (this.aGemeindeSteuerModel.isGemeindeInGenf(autreCommune)) {
            this.aGemeindeSteuerModel.addItem(autreCommune, 8, autreRevenu);
            autreRevenuGeneve += autreRevenu;
        }
        autreCommune = this.getItemLongValue("AutreRevenuEtFortune.Autres.RevenuCommuneEnfants");
        autreRevenu = this.getItemLongValue("AutreRevenuEtFortune.Autres.RevenuEnfants");
        if (this.aGemeindeSteuerModel.isGemeindeInGenf(autreCommune)) {
            this.aGemeindeSteuerModel.addItem(autreCommune, 8, autreRevenu);
            autreRevenuGeneve += autreRevenu;
        }
        autreCommune = this.getItemLongValue("AutreRevenuEtFortune.Autres.FortuneCommuneContribuable");
        autreFortune = this.getItemLongValue("AutreRevenuEtFortune.Autres.FortuneContribuable");
        if (this.aGemeindeSteuerModel.isGemeindeInGenf(autreCommune)) {
            this.aGemeindeSteuerModel.addItem(autreCommune, 9, autreFortune);
            autreFortuneGeneve += autreFortune;
        }
        autreCommune = this.getItemLongValue("AutreRevenuEtFortune.Autres.FortuneCommuneConjoint");
        autreFortune = this.getItemLongValue("AutreRevenuEtFortune.Autres.FortuneConjoint");
        if (this.aGemeindeSteuerModel.isGemeindeInGenf(autreCommune)) {
            this.aGemeindeSteuerModel.addItem(autreCommune, 9, autreFortune);
            autreFortuneGeneve += autreFortune;
        }
        autreCommune = this.getItemLongValue("AutreRevenuEtFortune.Autres.FortuneCommuneEnfants");
        autreFortune = this.getItemLongValue("AutreRevenuEtFortune.Autres.FortuneEnfants");
        if (this.aGemeindeSteuerModel.isGemeindeInGenf(autreCommune)) {
            this.aGemeindeSteuerModel.addItem(autreCommune, 9, autreFortune);
            autreFortuneGeneve += autreFortune;
        }
        if (log.isDebugEnabled()) {
            int i6 = 0;
            while (true) {
                if (i6 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i6, 8) != 0L) {
                    log.debug((Object)("Autres revenus \u00e0 Gen\u00e8ve [" + i6 + "] : " + this.aGemeindeSteuerModel.getItem(i6, 8)));
                }
                ++i6;
            }
            i6 = 0;
            while (true) {
                if (i6 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i6, 9) != 0L) {
                    log.debug((Object)("Autres fortunes \u00e0 G\u00e8n\u00e8ve [" + i6 + "] : " + this.aGemeindeSteuerModel.getItem(i6, 9)));
                }
                ++i6;
            }
        }
        long summeEinkommenUnselbstMann = this.aGemeindeSteuerModel.getSummeEinerRubrik(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total des revenus d\u00e9pendants Monsieur : " + summeEinkommenUnselbstMann));
        }
        deductionActiviteDependanteContribuable = this.getItemLongValue("Recapitulation.Deductions.DeductionRevenuDependantContribuableICC");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total des d\u00e9ductions non localis\u00e9es Monsieur : " + deductionActiviteDependanteContribuable));
        }
        if (summeEinkommenUnselbstMann > 0L) {
            int i7 = 0;
            while (true) {
                if (i7 < 46) {
                    long value3 = this.aGemeindeSteuerModel.getItem(i7, 0) - deductionActiviteDependanteContribuable * this.aGemeindeSteuerModel.getItem(i7, 0) / summeEinkommenUnselbstMann;
                    this.aGemeindeSteuerModel.setItem(i7, 15, value3);
                    ++i7;
                    continue;
                }
                break;
            }
        } else {
            this.aGemeindeSteuerModel.setItem(this.aGemeindeSteuerModel.getveranlagungsgemeinde(), 15, 0L - deductionActiviteDependanteContribuable);
        }
        if (log.isDebugEnabled()) {
            int i8 = 0;
            while (true) {
                if (i8 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i8, 15) != 0L) {
                    log.debug((Object)("Revenu de Monsieur apr\u00e8s affectation des d\u00e9ductions au prorata [" + i8 + "] : " + this.aGemeindeSteuerModel.getItem(i8, 15)));
                }
                ++i8;
            }
        }
        long summeEinkommenUnselbstFrau = this.aGemeindeSteuerModel.getSummeEinerRubrik(1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total des revenus d\u00e9pendants Madame : " + summeEinkommenUnselbstFrau));
        }
        deductionActiviteDependanteConjoint = this.getItemLongValue("Recapitulation.Deductions.DeductionRevenuDependantConjointICC");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Total des d\u00e9ductions non localis\u00e9es Madame: " + deductionActiviteDependanteConjoint));
        }
        if (summeEinkommenUnselbstFrau > 0L) {
            i2 = 0;
            while (true) {
                if (i2 < 46) {
                    value = this.aGemeindeSteuerModel.getItem(i2, 1) - deductionActiviteDependanteConjoint * this.aGemeindeSteuerModel.getItem(i2, 1) / summeEinkommenUnselbstFrau;
                    this.aGemeindeSteuerModel.setItem(i2, 16, value);
                    ++i2;
                    continue;
                }
                break;
            }
        } else {
            this.aGemeindeSteuerModel.setItem(this.aGemeindeSteuerModel.getveranlagungsgemeinde(), 16, 0L - deductionActiviteDependanteConjoint);
        }
        if (log.isDebugEnabled()) {
            i2 = 0;
            while (true) {
                if (i2 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i2, 16) != 0L) {
                    log.debug((Object)("Revenu de Madame apr\u00e8s affectation des d\u00e9ductions au prorata [" + i2 + "] : " + this.aGemeindeSteuerModel.getItem(i2, 16)));
                }
                ++i2;
            }
        }
        i2 = 0;
        while (true) {
            if (i2 >= 46) break;
            long contribuable = this.aGemeindeSteuerModel.getItem(i2, 15);
            long conjoint = this.aGemeindeSteuerModel.getItem(i2, 16);
            this.aGemeindeSteuerModel.setItem(i2, 17, contribuable + conjoint);
            ++i2;
        }
        if (log.isDebugEnabled()) {
            i2 = 0;
            while (true) {
                if (i2 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i2, 17) != 0L) {
                    log.debug((Object)("Revenu de Monsieur ET Madame apr\u00e8s affectation des d\u00e9ductions au prorata [" + i2 + "] : " + this.aGemeindeSteuerModel.getItem(i2, 17)));
                }
                ++i2;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("   14.00 : " + this.getItemLongValue("Recapitulation.RevenuEtFortune.RevenuMobilierNonCommerciauxTotalICC")));
            log.debug((Object)(" - 56.20 : " + this.getItemLongValue("Recapitulation.Deductions.DeductionRevenuMobiliersEtTitresICC")));
            log.debug((Object)(" + 13.00 : " + this.getItemLongValue("Recapitulation.RevenuEtFortune.RevenuPrestationsICC")));
            log.debug((Object)(" + 17.00 : " + this.getItemLongValue("Recapitulation.RevenuEtFortune.RevenuRentesAvsAiICC")));
            log.debug((Object)(" + 16.00 : " + this.getItemLongValue("Recapitulation.RevenuEtFortune.RevenuAutresICC")));
            log.debug((Object)(" - autre revenu gen\u00e8ve : " + autreRevenuGeneve));
            log.debug((Object)(" + 11.50 : " + this.getItemLongValue("Revenu.AutresRevenusContribuable.PerteDeSalaire")));
            log.debug((Object)(" + 21.50 : " + this.getItemLongValue("Revenu.AutresRevenusConjoint.PerteDeSalaire")));
            log.debug((Object)(" + 11.51 : " + this.getItemLongValue("Revenu.AutresRevenusContribuable.RevenuMinimum")));
            log.debug((Object)(" + 21.51 : " + this.getItemLongValue("Revenu.AutresRevenusConjoint.RevenuMinimum")));
            log.debug((Object)("- 59.10 : " + this.getItemLongValue("Recapitulation.Deductions.FraisDeGardeICC")));
        }
        long andereEinkVeranlagungsgemeinde = this.getItemLongValue("Recapitulation.RevenuEtFortune.RevenuMobilierNonCommerciauxTotalICC") - this.getItemLongValue("Recapitulation.Deductions.DeductionRevenuMobiliersEtTitresICC") + this.getItemLongValue("Recapitulation.RevenuEtFortune.RevenuPrestationsICC") + this.getItemLongValue("Recapitulation.RevenuEtFortune.RevenuRentesAvsAiICC") + this.getItemLongValue("AutreRevenuEtFortune.TotalAutresRevenus") - autreRevenuGeneve + this.getItemLongValue("Revenu.AutresRevenusContribuable.PerteDeSalaire") + this.getItemLongValue("Revenu.AutresRevenusConjoint.PerteDeSalaire") + this.getItemLongValue("Revenu.AutresRevenusContribuable.RevenuMinimum") + this.getItemLongValue("Revenu.AutresRevenusConjoint.RevenuMinimum") - this.getItemLongValue("Recapitulation.Deductions.FraisDeGardeICC");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Autres revenus attribu\u00e9s \u00e0 la commune de domicile : " + andereEinkVeranlagungsgemeinde));
        }
        this.aGemeindeSteuerModel.addItem(this.aGemeindeSteuerModel.getveranlagungsgemeinde(), 17, andereEinkVeranlagungsgemeinde);
        if (log.isDebugEnabled()) {
            int i9 = 0;
            while (true) {
                if (i9 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i9, 17) != 0L) {
                    log.debug((Object)("Revenu de Monsieur ET Madame apr\u00e8s affectation des autres revenus de la commune de domicile [" + i9 + "] : " + this.aGemeindeSteuerModel.getItem(i9, 17)));
                }
                ++i9;
            }
        }
        long andereAbzuegeEink = this.getItemLongValue("Recapitulation.Deductions.PrimesAssuranceICC") + this.getItemLongValue("Recapitulation.Deductions.PensionsICC") + this.getItemLongValue("Recapitulation.Deductions.RentesViageresPayeesICC") + this.getItemLongValue("Recapitulation.Deductions.InteretsEtDettesICC") + this.getItemLongValue("Recapitulation.Deductions.AutresDeductionsICC") + this.getItemLongValue("Recapitulation.Deductions.FraisHandicapICC") + this.getItemLongValue("Recapitulation.Deductions.PertesReporteesContribuableICC") + this.getItemLongValue("Recapitulation.Deductions.PertesReporteesConjointICC") + this.getItemLongValue("Recapitulation.Deductions.FraisMedicauxICC") + this.getItemLongValue("Recapitulation.Deductions.DonsICC");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Autres d\u00e9ductions sur revenu non localis\u00e9es : " + andereAbzuegeEink));
        }
        long andereVermVeranlagungsgemeinde = this.getItemLongValue("Recapitulation.RevenuEtFortune.FortunePrestationsICC") + this.getItemLongValue("Recapitulation.RevenuEtFortune.FortuneMobilierNonCommerciauxTotal") + this.getItemLongValue("AutreRevenuEtFortune.TotalAutreFortune") - autreFortuneGeneve + this.getItemLongValue("Recapitulation.RevenuEtFortune.FortuneRachatAssuranceVieICC");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Autres fortune attribu\u00e9es \u00e0 la commune de domicile : " + andereVermVeranlagungsgemeinde));
        }
        long andereAbzuegeVerm = this.getItemLongValue("Recapitulation.Deductions.FortuneRentesViageresPayeesICC") + this.getItemLongValue("Recapitulation.Deductions.FortuneInteretsEtDettesICC") + this.getItemLongValue("Recapitulation.Deductions.FortunePertesReporteesContribuableICC") + this.getItemLongValue("Recapitulation.Deductions.FortunePertesReporteesConjointICC") + this.getItemLongValue("Recapitulation.Deductions.DeductionSocialeICC");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Autres d\u00e9duction sur fortune non localis\u00e9es : " + andereAbzuegeVerm));
        }
        int i10 = 0;
        while (true) {
            if (i10 >= 46) break;
            this.aGemeindeSteuerModel.setItem(i10, 25, this.aGemeindeSteuerModel.getItem(i10, 4) + this.aGemeindeSteuerModel.getItem(i10, 5) + this.aGemeindeSteuerModel.getItem(i10, 7) + this.aGemeindeSteuerModel.getItem(i10, 9));
            ++i10;
        }
        if (log.isDebugEnabled()) {
            i10 = 0;
            while (true) {
                if (i10 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i10, 25) != 0L) {
                    log.debug((Object)("Fortune totale brutte [" + i10 + "] : " + this.aGemeindeSteuerModel.getItem(i10, 25)));
                }
                ++i10;
            }
        }
        this.aGemeindeSteuerModel.addItem(this.aGemeindeSteuerModel.getveranlagungsgemeinde(), 25, andereVermVeranlagungsgemeinde);
        if (log.isDebugEnabled()) {
            i10 = 0;
            while (true) {
                if (i10 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i10, 25) != 0L) {
                    log.debug((Object)("Fortune total apr\u00e8s affectation des autres fortune de la commune de domicile [" + i10 + "] : " + this.aGemeindeSteuerModel.getItem(i10, 25)));
                }
                ++i10;
            }
        }
        i10 = 0;
        while (true) {
            if (i10 >= 46) break;
            this.aGemeindeSteuerModel.setItem(i10, 18, this.aGemeindeSteuerModel.getItem(i10, 17) + this.aGemeindeSteuerModel.getItem(i10, 2) + this.aGemeindeSteuerModel.getItem(i10, 3) - this.aGemeindeSteuerModel.getItem(i10, 10) - this.aGemeindeSteuerModel.getItem(i10, 11) + this.aGemeindeSteuerModel.getItem(i10, 6) - this.aGemeindeSteuerModel.getItem(i10, 14) + this.aGemeindeSteuerModel.getItem(i10, 8));
            ++i10;
        }
        if (log.isDebugEnabled()) {
            i10 = 0;
            while (true) {
                if (i10 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i10, 18) != 0L) {
                    log.debug((Object)("Solde du revenu apr\u00e8s d\u00e9duction directement li\u00e9es [" + i10 + "] : " + this.aGemeindeSteuerModel.getItem(i10, 18)));
                }
                ++i10;
            }
        }
        i10 = 0;
        while (true) {
            if (i10 >= 46) break;
            long einkommenMinusAbzuegeA = this.aGemeindeSteuerModel.getItem(i10, 18);
            if (einkommenMinusAbzuegeA < 0L) {
                int j = 0;
                while (true) {
                    if (j >= 46) break;
                    long einkommenMinusAbzuegeB = this.aGemeindeSteuerModel.getItem(j, 18);
                    if (i10 != j && einkommenMinusAbzuegeB > 0L) {
                        long abzuege = Math.round((float)Math.abs(einkommenMinusAbzuegeA) * (float)einkommenMinusAbzuegeB / (float)this.aGemeindeSteuerModel.getTotalEinkommenMinusAbzuege());
                        this.aGemeindeSteuerModel.setItem(j, 20, abzuege);
                    }
                    ++j;
                }
                this.aGemeindeSteuerModel.setItem(i10, 20, 0L);
                this.aGemeindeSteuerModel.setItem(i10, 18, 0L);
            }
            ++i10;
        }
        if (log.isDebugEnabled()) {
            i10 = 0;
            while (true) {
                if (i10 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i10, 20) != 0L) {
                    log.debug((Object)("R\u00e9partition du revenu n\u00e9gatif[" + i10 + "]" + this.aGemeindeSteuerModel.getItem(i10, 20)));
                }
                ++i10;
            }
        }
        i10 = 0;
        while (true) {
            if (i10 >= 46) break;
            long einkommenMinusAbzuege = this.aGemeindeSteuerModel.getItem(i10, 18);
            long verteilungNegativEinkommen = this.aGemeindeSteuerModel.getItem(i10, 20);
            this.aGemeindeSteuerModel.setItem(i10, 22, einkommenMinusAbzuege - verteilungNegativEinkommen);
            ++i10;
        }
        if (log.isDebugEnabled()) {
            i10 = 0;
            while (true) {
                if (i10 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i10, 22) != 0L) {
                    log.debug((Object)("Sous-total avant r\u00e9partition autres d\u00e9ductions[" + i10 + "]" + this.aGemeindeSteuerModel.getItem(i10, 22)));
                }
                ++i10;
            }
        }
        long summeEinkommenVorAndereAbzuege = this.aGemeindeSteuerModel.getSummeEinerRubrik(22);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Somme des revenus avant r\u00e9partition des autres d\u00e9ductions : " + summeEinkommenVorAndereAbzuege));
        }
        if (summeEinkommenVorAndereAbzuege > 0L) {
            i = 0;
            while (true) {
                if (i >= 46) break;
                float prozent = (float)this.aGemeindeSteuerModel.getItem(i, 22) / (float)summeEinkommenVorAndereAbzuege;
                long entsprechendAndereAbzuege = (long)(prozent * (float)andereAbzuegeEink);
                long einkommenVorAndereAbzuege = this.aGemeindeSteuerModel.getItem(i, 22);
                if (log.isDebugEnabled()) {
                    if (this.aGemeindeSteuerModel.getItem(i, 22) != 0L) {
                        log.debug((Object)("REVENU AVANT DEDUCTION[" + i + "] : " + einkommenVorAndereAbzuege));
                        log.debug((Object)("DEDUCTION AU PRORATA[" + i + "] : " + entsprechendAndereAbzuege));
                    }
                }
                if (einkommenVorAndereAbzuege - entsprechendAndereAbzuege > 0L) {
                    this.aGemeindeSteuerModel.setItem(i, 24, einkommenVorAndereAbzuege - entsprechendAndereAbzuege);
                } else {
                    this.aGemeindeSteuerModel.setItem(i, 24, 0L);
                }
                if (log.isDebugEnabled()) {
                    if (this.aGemeindeSteuerModel.getItem(i, 24) != 0L) {
                        log.debug((Object)("REVENU NET APRES DEDUCTION[" + i + "] : " + this.aGemeindeSteuerModel.getItem(i, 24)));
                    }
                }
                ++i;
            }
        }
        if (log.isDebugEnabled()) {
            i = 0;
            while (true) {
                if (i >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i, 24) != 0L) {
                    log.debug((Object)("Revenu net apr\u00e8s d\u00e9ductions non localis\u00e9es[" + i + "] : " + this.aGemeindeSteuerModel.getItem(i, 24)));
                }
                ++i;
            }
        }
        if ((summeVermoegen = this.aGemeindeSteuerModel.getSummeEinerRubrik(25)) > 0L) {
            int i11 = 0;
            while (true) {
                if (i11 >= 46) break;
                float prozent = (float)this.aGemeindeSteuerModel.getItem(i11, 25) / (float)summeVermoegen;
                long entsprechendAndereAbzuege = (long)(prozent * (float)andereAbzuegeVerm);
                long vermoegen = this.aGemeindeSteuerModel.getItem(i11, 25);
                if (vermoegen - entsprechendAndereAbzuege > 0L) {
                    this.aGemeindeSteuerModel.setItem(i11, 25, vermoegen - entsprechendAndereAbzuege);
                } else {
                    this.aGemeindeSteuerModel.setItem(i11, 25, 0L);
                }
                ++i11;
            }
        }
        if (log.isDebugEnabled()) {
            int i12 = 0;
            while (true) {
                if (i12 >= 46) break;
                if (this.aGemeindeSteuerModel.getItem(i12, 25) != 0L) {
                    log.debug((Object)("Fortune nette [" + i12 + "] : " + this.aGemeindeSteuerModel.getItem(i12, 25)));
                }
                ++i12;
            }
        }
    }
}

