/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.ConstructionException;
import ch.dvbern.lib.resource.construct.ObjectConstructor;
import ch.dvbern.lib.resource.construct.xml.ClassLoaderResourceLocator;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.lib.resource.construct.xml.ResourceChangeListener;
import ch.dvbern.lib.resource.construct.xml.ResourceChangedEvent;
import ch.dvbern.lib.resource.construct.xml.ResourceNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLObjectConstructor
implements ObjectConstructor,
ResourceChangeListener {
    private Map cachedObjects = null;
    private final ParserFactory factory;

    public XMLObjectConstructor() {
        this(new ParserFactory(new ClassLoaderResourceLocator()));
    }

    public XMLObjectConstructor(ParserFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.cachedObjects = new HashMap();
        this.factory = factory;
        factory.getResourceLocator().addResourceChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object construct(String objectId, boolean newInstance) throws ConstructionException {
        Map map;
        Object obj = null;
        if (!newInstance) {
            map = this.cachedObjects;
            synchronized (map) {
                obj = this.cachedObjects.get(objectId);
            }
        }
        if (obj == null) {
            obj = this.parse(objectId, this.factory);
            map = this.cachedObjects;
            synchronized (map) {
                this.cachedObjects.put(objectId, obj);
            }
        }
        return obj;
    }

    private Object parse(String objectId, ParserFactory parserFactory) throws ConstructionException {
        try {
            InputStream ins = parserFactory.getResourceLocator().getResourceAsStream(objectId);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(ins);
            Element root = new Element(doc.getDocumentElement());
            return parserFactory.getParser(root.getNodeName()).parse(root, parserFactory).getObject();
        }
        catch (SAXException ex) {
            throw new ConstructionException("parsing of file with id=" + objectId + " NOT successfull", ex);
        }
        catch (IOException ex) {
            throw new ConstructionException("parsing of file with id=" + objectId + " NOT successfull", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ConstructionException("parsing of file with id=" + objectId + " NOT successfull", ex);
        }
        catch (ParserNotRegisteredException ex) {
            throw new ConstructionException("no parser found for root-element", ex);
        }
        catch (ElementParserException ex) {
            throw new ConstructionException("root-element could NOT have been parsed", ex);
        }
        catch (ResourceNotFoundException ex) {
            throw new ConstructionException("resource with id=" + objectId + " not found", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(ResourceChangedEvent event) {
        String resource = event.getResourceName();
        Map map = this.cachedObjects;
        synchronized (map) {
            if (this.cachedObjects.get(resource) != null) {
                this.cachedObjects.remove(resource);
            }
        }
    }

    public void resourceRemoved(ResourceChangedEvent event) {
        this.resourceChanged(event);
    }
}

