/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ParserAlreadyRegisteredException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.lib.resource.construct.xml.VariableAlreadyDefinedException;
import ch.dvbern.lib.resource.construct.xml.VariableNotDefinedException;
import java.util.HashMap;
import java.util.Map;

public class ScopeParserFactory
extends ParserFactory {
    private ParserFactory factory;
    private Map varScope;

    public ScopeParserFactory(ParserFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Constructor argument must not be null");
        }
        this.factory = factory;
        this.varScope = new HashMap();
    }

    public ElementParser getParser(String elementName) throws ParserNotRegisteredException {
        return this.factory.getParser(elementName);
    }

    public void registerParser(String elementName, ElementParser parser) throws ParserAlreadyRegisteredException {
        this.factory.registerParser(elementName, parser);
    }

    public ClassObjectPair getVariableCOP(String varName) throws VariableNotDefinedException {
        ClassObjectPair value = (ClassObjectPair)this.varScope.get(varName);
        if (value == null && this.factory instanceof ScopeParserFactory) {
            value = ((ScopeParserFactory)this.factory).getVariableCOP(varName);
        }
        if (value == null) {
            throw new VariableNotDefinedException("variable with name=" + varName + " not defined");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVariableCOP(String varName, ClassObjectPair cop) throws VariableAlreadyDefinedException {
        Map map = this.varScope;
        synchronized (map) {
            if (this.varScope.get(varName) != null) {
                throw new VariableAlreadyDefinedException("A variable with name=" + varName + " is already defined");
            }
            this.varScope.put(varName, cop);
        }
    }
}

