/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.ConstructionException;
import ch.dvbern.lib.resource.construct.xml.ClassFactory;
import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.PrimObjectFactory;

public class PrimParser
implements ElementParser {
    public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
        String elementName = element.getNodeName();
        if (!(elementName.equals("string") || elementName.equals("int") || elementName.equals("long") || elementName.equals("short") || elementName.equals("float") || elementName.equals("double") || elementName.equals("boolean") || elementName.equals("char"))) {
            throw new ElementParserException("null-parser can not handle elements with the name=" + elementName);
        }
        Class klass = null;
        Object value = null;
        try {
            klass = ClassFactory.getKlass(elementName);
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("ClassFactory could NOT load Class with type=" + elementName, ex);
        }
        String strValue = element.getAttribute("value");
        if (strValue == null) {
            throw new ElementParserException("definition of argument NOT correct (value must NOT be null)");
        }
        try {
            value = PrimObjectFactory.getWrapper(elementName, strValue);
        }
        catch (ConstructionException ex) {
            throw new ElementParserException(ex);
        }
        return new ClassObjectPair(klass, value);
    }
}

