/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ResourceChangeListener;
import ch.dvbern.lib.resource.construct.xml.ResourceChangedEvent;
import ch.dvbern.lib.resource.construct.xml.ResourceLocator;
import ch.dvbern.lib.resource.construct.xml.ResourceNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FilePathResourceLocator
implements ResourceLocator {
    private final String path;
    private final HashSet listeners;
    private final HashSet files;
    private final ResourceChecker resourceChecker;

    public FilePathResourceLocator(String path) {
        this(path, 10000L);
    }

    public FilePathResourceLocator(String path, long resChangeCheckPeriod) {
        this.path = path;
        this.listeners = new HashSet();
        this.files = new HashSet();
        this.resourceChecker = new ResourceChecker(resChangeCheckPeriod);
        Thread thread = new Thread(this.resourceChecker);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(String resourceName) throws ResourceNotFoundException {
        try {
            File file = new File(this.path, resourceName);
            HashSet hashSet = this.files;
            synchronized (hashSet) {
                if (!this.files.contains(file)) {
                    this.files.add(file);
                }
            }
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new ResourceNotFoundException("resource=" + resourceName + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceChangeListener(ResourceChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        HashSet hashSet = this.listeners;
        synchronized (hashSet) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceChangeListener(ResourceChangeListener listener) {
        HashSet hashSet = this.listeners;
        synchronized (hashSet) {
            if (this.listeners.contains(listener)) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyResourceChange(String resource) {
        ResourceChangedEvent event = new ResourceChangedEvent(this, resource);
        Set clone = null;
        HashSet hashSet = this.listeners;
        synchronized (hashSet) {
            clone = (Set)this.listeners.clone();
        }
        Iterator i = clone.iterator();
        while (i.hasNext()) {
            ResourceChangeListener listener = (ResourceChangeListener)i.next();
            try {
                listener.resourceChanged(event);
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyResourceRemoved(String resource) {
        ResourceChangedEvent event = new ResourceChangedEvent(this, resource);
        Set clone = null;
        HashSet hashSet = this.listeners;
        synchronized (hashSet) {
            clone = (Set)this.listeners.clone();
        }
        Iterator i = clone.iterator();
        while (i.hasNext()) {
            ResourceChangeListener listener = (ResourceChangeListener)i.next();
            try {
                listener.resourceRemoved(event);
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void stopResourceChecker() {
        this.resourceChecker.stopChecker();
    }

    private class ResourceChecker
    implements Runnable {
        private long lastCheck = System.currentTimeMillis();
        private long checkPeriod;
        private boolean run;

        public ResourceChecker(long checkPeriod) {
            this.checkPeriod = checkPeriod;
            this.run = true;
        }

        public void stopChecker() {
            this.run = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.run) {
                long tmpCheck = System.currentTimeMillis();
                Set clone = null;
                HashSet hashSet = FilePathResourceLocator.this.files;
                synchronized (hashSet) {
                    clone = (Set)FilePathResourceLocator.this.files.clone();
                }
                Iterator i = clone.iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    if (!file.exists()) {
                        FilePathResourceLocator.this.notifyResourceRemoved(file.getName());
                        continue;
                    }
                    if (file.lastModified() < this.lastCheck) continue;
                    FilePathResourceLocator.this.notifyResourceChange(file.getName());
                }
                this.lastCheck = tmpCheck;
                try {
                    Thread.sleep(this.checkPeriod);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

