/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ClassFactory;
import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import java.util.List;

public class CastParser
implements ElementParser {
    public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
        String elementName = element.getNodeName();
        if (!elementName.equals("cast")) {
            throw new ElementParserException("cast-parser can not handle elements with the name=" + elementName);
        }
        ClassObjectPair retVal = null;
        String className = element.getAttribute("class");
        List children = element.getChildElements();
        if (children.size() != 1) {
            throw new ElementParserException("a cast-tag must have exactly ONE child");
        }
        Element child = (Element)children.get(0);
        try {
            ClassObjectPair cop = factory.getParser(child.getNodeName()).parse(child, factory);
            Class klass = ClassFactory.getKlass(className);
            retVal = new ClassObjectPair(klass, cop.getObject());
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("could not find class for name=" + className, ex);
        }
        catch (ParserNotRegisteredException ex) {
            throw new ElementParserException("could not find a parser for cast-child", ex);
        }
        return retVal;
    }
}

