/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.resource.construct.xml;

import ch.dvbern.lib.resource.construct.xml.ClassFactory;
import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import java.lang.reflect.Array;
import java.util.List;

public class ArrayParser
implements ElementParser {
    public ClassObjectPair parse(Element element, ParserFactory factory) throws ElementParserException {
        String elementName = element.getNodeName();
        if (!elementName.equals("array")) {
            throw new ElementParserException("array-parser can not handle elements with the name=" + elementName);
        }
        String type = element.getAttribute("elementtype");
        Class arrayClass = null;
        try {
            arrayClass = ClassFactory.getKlass(type);
        }
        catch (ClassNotFoundException ex) {
            throw new ElementParserException("ArrayParser: ClassFactory could NOT create array-class for type=" + type, ex);
        }
        List arrayChildren = element.getChildElements();
        Object array = Array.newInstance(arrayClass, arrayChildren.size());
        for (int i = 0; i < arrayChildren.size(); ++i) {
            Element el = (Element)arrayChildren.get(i);
            try {
                ClassObjectPair cop = factory.getParser(el.getNodeName()).parse(el, factory);
                Array.set(array, i, cop.getObject());
                continue;
            }
            catch (ParserNotRegisteredException ex) {
                throw new ElementParserException("ArrayParser: could NOT find parser for name=" + el.getNodeName(), ex);
            }
            catch (Exception ex) {
                throw new ElementParserException("ArrayParser: Could NOT set value into array", ex);
            }
        }
        Class<?> klass = array.getClass();
        return new ClassObjectPair(klass, array);
    }
}

