/*
 * Copyright © 2009 DV Bern AG, Switzerland
 *
 * Das vorliegende Dokument, einschliesslich aller seiner Teile, ist urheberrechtlich
 * geschuetzt. Jede Verwertung ist ohne Zustimmung der DV Bern AG unzulaessig. Dies gilt
 * insbesondere fuer Vervielfaeltigungen, die Einspeicherung und Verarbeitung in
 * elektronischer Form. Wird das Dokument einem Kunden im Rahmen der Projektarbeit zur
 * Ansicht uebergeben ist jede weitere Verteilung durch den Kunden an Dritte untersagt.
 *
 * $Id$
 */
package ch.dvbern.datatypes;

/**
 * Sozialversicherungsnummer (neue AHV-Nummer)
 *
 * @author beph
 */
public final class SozialversicherungsNummer extends AbstractPruefzifferNummer implements
		Comparable<SozialversicherungsNummer> {

	/**
	 *
	 */
	private static final long serialVersionUID = 923267806499518804L;
	private static final long MAX_VALUE = 9999999999999L;
	private static final long MIN_VALUE = 1000000000000L;

	/**
	 * Konstruktor einer neuen Sozialversicherungsnummer anhand eines long.
	 *
	 * @param nummer
	 */
	public SozialversicherungsNummer(final long nummer) {

		super(nummer, MIN_VALUE, MAX_VALUE);
	}

	/**
	 * Konstruktor einer Sozialversicherungsnummer anhand eines Strings.
	 *
	 * @param nummer
	 */
	public SozialversicherungsNummer(final String nummer) {

		super(nummer, MIN_VALUE, MAX_VALUE);
	}

	/**
	 * Berechnet die Pruefziffer.
	 */
	@Override
	protected int berechnePruefziffer(final long nummer) {

		long n = nummer / 10;
		int pruefziffer = 0;
		int z = 1;
		while (n > 0) {
			long ziffer = n % 10;
			pruefziffer = incrementPruefziffer(pruefziffer, (int) ziffer, z);
			z++;
			n /= 10;
		}
		int returnValue = 0;
		if (pruefziffer % 10 != 0) {
			returnValue = 10 - pruefziffer % 10;
		}
		return returnValue;
	}

	private int incrementPruefziffer(final int pruefziffer, final int ziffer, final int z) {
		int increment = ziffer;
		if (z % 2 != 0) {
			increment *= 3;
		}
		return pruefziffer + increment;
	}

	@Override
	public String toString() {

		StringBuilder sb = new StringBuilder(Long.toString(getNummer()));
		sb.insert(3, ".");
		sb.insert(8, ".");
		sb.insert(13, ".");
		return sb.toString();
	}

	/*
	 * (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(final SozialversicherungsNummer o) {
		int returnValue = 0;
		if (this.getNummer() != o.getNummer()) {
			if (this.getNummer() - o.getNummer() > 0) {
				returnValue = -1;
			} else {
				returnValue = 1;
			}
		}
		return returnValue;
	}

}
