/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.vision.recognition;

import com.java4less.vision.recognition.ImageObject;
import com.java4less.vision.recognition.Line;
import com.java4less.vision.recognition.Point;
import com.java4less.vision.util.ImageDebugger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;

public class Barcode1DObject {
    public Vector bars = new Vector();
    public Point corner1 = new Point(0.0, 0.0);
    public Point corner2 = new Point(0.0, 0.0);
    public Point corner3 = new Point(0.0, 0.0);
    public Point corner4 = new Point(0.0, 0.0);
    double[] barWidths;
    private int flag = 0;
    double firstBarAngle = 0.0;
    public double pdf417BarcodeWidthCorrection = 0.0;

    public Barcode1DObject(Vector bars) {
        double angle;
        this.bars = bars;
        ImageObject object1 = (ImageObject)bars.elementAt(0);
        ImageObject object2 = (ImageObject)bars.elementAt(bars.size() - 1);
        this.firstBarAngle = angle = object1.getPA().getAngle() - 90.0;
        double len = object1.getLength();
        double ystep = len * Math.cos(Math.toRadians(angle));
        double xstep = len * Math.sin(Math.toRadians(angle));
        this.corner1 = object1.nearestCorner;
        this.corner2 = new Point(Math.round(this.corner1.x - xstep), Math.round(this.corner1.y + ystep));
        this.corner3 = object2.farestCorner;
        this.corner4 = new Point(Math.round(this.corner3.x + xstep), Math.round(this.corner3.y - ystep));
    }

    public Vector getLines() {
        Vector<Line> v = new Vector<Line>();
        for (int i = 0; i < this.bars.size(); ++i) {
            ImageObject object1 = (ImageObject)this.bars.elementAt(i);
            v.add(object1.getPA());
        }
        return v;
    }

    public Line[] getBarsArray() {
        Line[] a = new Line[this.bars.size()];
        for (int i = 0; i < this.bars.size(); ++i) {
            ImageObject object1 = (ImageObject)this.bars.elementAt(i);
            a[i] = object1.getPA();
        }
        return a;
    }

    public double getOrientation() {
        return ((ImageObject)this.bars.elementAt(0)).getPA().getAngle();
    }

    public double getHeight() {
        return ((ImageObject)this.bars.elementAt(0)).getLength();
    }

    public void setWidths(double[] w) {
        this.barWidths = w;
    }

    public double[] getWidths() {
        return this.barWidths;
    }

    public void setFlag(int f) {
        this.flag = f;
    }

    public int getFlag() {
        return this.flag;
    }

    public double getFirstBarAngle() {
        return this.firstBarAngle;
    }

    public void exportToPNG(String file, BufferedImage backImage) throws IOException {
        ImageDebugger debugger = new ImageDebugger(backImage);
        for (int i = 0; i < this.bars.size(); ++i) {
            Line l = ((ImageObject)this.bars.elementAt(i)).getPA();
            debugger.exportLine(l);
        }
        debugger.export(file);
    }
}

