/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ZipHelper {
    private ZipHelper() {
    }

    public static void zip(@Nonnull Path source, @Nonnull Path zipFile) throws IOException {
        Objects.requireNonNull(source, "Source file or directory cannot be null.");
        Objects.requireNonNull(zipFile, "Target zip file cannot be null.");
        ZipHelper.zip(source, source.getParent(), zipFile);
    }

    public static void zip(@Nonnull Path source, final @Nullable Path relativeTo, @Nonnull Path zipFile) throws IOException {
        Objects.requireNonNull(source, "Source file or directory cannot be null.");
        Objects.requireNonNull(zipFile, "Target zip file cannot be null.");
        if (relativeTo != null && !source.startsWith(relativeTo)) {
            throw new IllegalArgumentException("Relative-to must point to a parent of the source directory.");
        }
        try (final ZipOutputStream zipStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(zipFile, new OpenOption[0])));){
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return this.addEntry(dir, true);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    return this.addEntry(file, false);
                }

                private FileVisitResult addEntry(Path path, boolean isDirectory) throws IOException {
                    if (!isDirectory && path.equals(relativeTo)) {
                        throw new IOException("Relative-to must point to a directory.");
                    }
                    Path target = relativeTo != null ? relativeTo.relativize(path) : path;
                    Object entryName = target.toString().replaceAll("\\\\", "/");
                    if (isDirectory) {
                        entryName = (String)entryName + "/";
                    }
                    zipStream.putNextEntry(new ZipEntry((String)entryName));
                    if (!isDirectory) {
                        Files.copy(path, zipStream);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void unzip(@Nonnull Path zipFile, @Nonnull Path target) throws IOException {
        Objects.requireNonNull(zipFile, "Zip file cannot be null.");
        Objects.requireNonNull(target, "Target directory cannot be null.");
        try (ZipInputStream zipStream = new ZipInputStream(new BufferedInputStream(Files.newInputStream(zipFile, new OpenOption[0])));){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    Files.createDirectories(target.resolve(entry.getName()), new FileAttribute[0]);
                    continue;
                }
                Files.copy(zipStream, target.resolve(entry.getName().replace("\\", File.separator)), new CopyOption[0]);
            }
        }
    }
}

