/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.upload;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.FSDocumentStore;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.PrepareUploadTask;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadRequest;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadResultDTO;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadWSClient;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

class UploadTask
implements IRunnableWithProgress {
    private final UploadRequest request;
    private final byte[] signature;
    private final FSDocumentStore documentStore;
    private volatile UploadResultDTO uploadResult;

    UploadTask(@Nonnull UploadRequest request, @Nonnull FSDocumentStore documentStore, @Nullable byte[] signature) {
        Objects.requireNonNull(request, "Upload request cannot be null.");
        Objects.requireNonNull(documentStore, "Document store cannot be null.");
        this.request = request;
        this.documentStore = documentStore;
        this.signature = signature;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        UploadResultDTO result;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.translate((String)"release.progress", (Object[])new Object[0]), (int)100);
        ByteArrayOutputStream pdfBuffer = new ByteArrayOutputStream(524288);
        ByteArrayOutputStream barcodeBuffer = new ByteArrayOutputStream(131072);
        PrepareUploadTask task = new PrepareUploadTask(this.request.getBarcodeConfiguration(), (OutputStream)barcodeBuffer, (OutputStream)pdfBuffer);
        task.run((IProgressMonitor)subMonitor.newChild(5));
        byte[] pdf = pdfBuffer.toByteArray();
        byte[] barcode = barcodeBuffer.toByteArray();
        try {
            result = new UploadWSClient().upload((IProgressMonitor)subMonitor.newChild(95), this.request, this.signature, barcode, pdf, this.documentStore);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new InvocationTargetException(e);
        }
        this.uploadResult = result;
    }

    public UploadResultDTO getUploadResult() {
        return this.uploadResult;
    }
}

