/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.upload;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadHistoryEntry;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UploadResultStore {
    private static final Logger LOG = LoggerFactory.getLogger(UploadResultStore.class);
    private static final Pattern NAME_FILTERING = Pattern.compile("[\\W]");
    private static final int NAME_MAX_LENGTH = 4;
    private static final Pattern FILE_NAME_PTN = Pattern.compile("\\d{4}-(\\w{0,4}-\\w{0,4})_(.+?)_(\\d{3}\\.\\d{2}\\.\\d{4}(-\\d)?).pdf");
    private static final String DATE_FMT_STRING = "yyyyMMdd'-'HHmmss";
    private static final ThreadLocal<MessageFormat> FILE_NAME_FMT = new ThreadLocal<MessageFormat>(){

        @Override
        protected MessageFormat initialValue() {
            return new MessageFormat("{0,number,#}-{1}-{2}_{3,date,yyyyMMdd'-'HHmmss}_{4}.pdf", GeConstants.DEFAULT_LOCALE);
        }
    };
    private static final DateTimeFormatter FILE_NAME_DATE_FMT = DateTimeFormatter.ofPattern("yyyyMMdd'-'HHmmss").withLocale(GeConstants.DEFAULT_LOCALE).withZone(ApplicationConfig.TIMEZONE.toZoneId());
    private final Path storeDir;

    private UploadResultStore(Path storeDir) throws IOException {
        assert (storeDir != null);
        this.storeDir = storeDir;
        Files.createDirectories(storeDir, new FileAttribute[0]);
    }

    public Path save(byte[] pageSynthese, String firstName, String lastName, String taxPayerNumber, long timestamp) throws IOException {
        if (pageSynthese == null || firstName == null || lastName == null || taxPayerNumber == null) {
            throw new NullPointerException("Invalid null argument");
        }
        Path summaryPage = this.storeDir.resolve(this.constructFileName(lastName, firstName, taxPayerNumber, timestamp));
        Files.write(summaryPage, pageSynthese, new OpenOption[0]);
        return summaryPage;
    }

    private String constructFileName(String lastName, String firstName, String taxPayerNumber, long timestamp) {
        assert (lastName != null && firstName != null && taxPayerNumber != null);
        return FILE_NAME_FMT.get().format(new Object[]{ApplicationConfig.getInstance().getJahr(), UploadResultStore.sanitizeName(lastName), UploadResultStore.sanitizeName(firstName), timestamp, taxPayerNumber});
    }

    private static String sanitizeName(String name) {
        assert (name != null);
        if (name.length() > 4) {
            name = name.substring(0, 4);
        }
        return NAME_FILTERING.matcher(name).replaceAll("");
    }

    @Nonnull
    public List<UploadHistoryEntry> getHistory(@Nonnull String taxPayerNumber) throws IOException {
        Objects.requireNonNull(taxPayerNumber, "Taxpayer number cannot be null");
        ArrayList<UploadHistoryEntry> result = new ArrayList<UploadHistoryEntry>();
        Files.list(this.storeDir).forEach(file -> {
            String fileName = file.getFileName().toString();
            Matcher m = FILE_NAME_PTN.matcher(fileName);
            if (!m.matches()) {
                LOG.warn("Ignoring file with unknown file name syntax: {}", (Object)fileName);
                return;
            }
            String fileCodeDeclaration = m.group(3);
            if (taxPayerNumber.equals(fileCodeDeclaration)) {
                Instant timestamp;
                try {
                    timestamp = LocalDateTime.parse(m.group(2), FILE_NAME_DATE_FMT).atZone(ApplicationConfig.TIMEZONE.toZoneId()).toInstant();
                }
                catch (DateTimeParseException e) {
                    LOG.warn("Ignoring file with unparsable date: {}", (Object)fileName);
                    return;
                }
                UploadHistoryEntry dto = new UploadHistoryEntry(timestamp, (Path)file);
                result.add(dto);
            }
        });
        LOG.debug("{} summary pdf found for taxpayer number code {}", (Object)result.size(), (Object)taxPayerNumber);
        return result;
    }

    @Nonnull
    public static synchronized UploadResultStore getInstance(Path storeDir) throws IOException {
        return new UploadResultStore(Objects.requireNonNull(storeDir, "Store location cannot be null."));
    }
}

