/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.upload;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpMainhelpAction;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.LaunchUtil;
import ch.dvbern.tax.ge.pp.presentation.cd.upload.UploadHistoryEntry;
import ch.dvbern.tax.ge.pp.presentation.cd.util.GeResources;
import ch.dvbern.tax.ge.pp.upload.ReleaseMode;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class UploadHistoryDialog
extends Dialog {
    private final ReleaseMode releaseMode;
    private final List<UploadHistoryEntry> history;
    private TableViewer uploadTableViewer;

    public UploadHistoryDialog(@Nullable Shell parentShell, ReleaseMode releaseMode, List<UploadHistoryEntry> history) {
        super(parentShell);
        this.releaseMode = Objects.requireNonNull(releaseMode, "Release mode cannot be null.");
        this.history = Objects.requireNonNull(history, "History list cannot be null.");
        if (releaseMode != ReleaseMode.DEPOT && releaseMode != ReleaseMode.SOUMISSION) {
            throw new IllegalArgumentException("Invalid release mode for an upload: " + String.valueOf(releaseMode));
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.translate((String)(this.releaseMode == ReleaseMode.DEPOT ? "release.history.title.depot" : "release.history.title.tlv"), (Object[])new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        this.createTable(panel);
        GridDataFactory gdFty = GridDataFactory.swtDefaults().hint(530, -1);
        Label labelEmpty = new Label(panel, 64);
        labelEmpty.setLayoutData((Object)gdFty.create());
        labelEmpty.setText(Messages.translate((String)"label.empty", (Object[])new Object[]{labelEmpty}));
        Link helpLnk = new Link(panel, 64);
        helpLnk.setLayoutData((Object)gdFty.create());
        helpLnk.setText(Messages.translate((String)(this.releaseMode == ReleaseMode.DEPOT ? "release.history.helpLnk.depot" : "release.history.helpLnk.tlv"), (Object[])new Object[0]));
        helpLnk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HelpMainhelpAction help = new HelpMainhelpAction(UploadHistoryDialog.this.getShell(), event.text);
                help.run();
            }
        });
        return panel;
    }

    private void createTable(Composite panel) {
        Label labelTitelTabelle = new Label(panel, 64);
        labelTitelTabelle.setLayoutData((Object)GridDataFactory.swtDefaults().indent(5, 5).create());
        labelTitelTabelle.setText(Messages.translate((String)(this.releaseMode == ReleaseMode.DEPOT ? "release.history.table.depot" : "release.history.table.tlv"), (Object[])new Object[0]));
        GeResources.setBoldFont((Control)labelTitelTabelle);
        this.uploadTableViewer = new TableViewer(panel, 68100);
        Table uploadTable = this.uploadTableViewer.getTable();
        uploadTable.setLayoutData((Object)GridDataFactory.swtDefaults().indent(5, 5).hint(-1, 150).create());
        uploadTable.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        uploadTable.setLinesVisible(true);
        uploadTable.setHeaderVisible(true);
        TableViewerColumn colPrintViewer = new TableViewerColumn(this.uploadTableViewer, 16384);
        colPrintViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return GuiUtil.getImageRegistry().get("icon.menu.file.show");
            }

            public String getText(Object element) {
                return "";
            }
        });
        uploadTable.addListener(3, event -> {
            Point click = new Point(event.x, event.y);
            TableItem item = uploadTable.getItem(click);
            if (item != null && item.getBounds(0).contains(click)) {
                LaunchUtil.launchPdfReader((String)((UploadHistoryEntry)item.getData()).getFile().toString());
            }
        });
        TableColumn colPrint = colPrintViewer.getColumn();
        colPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection selected = (IStructuredSelection)UploadHistoryDialog.this.uploadTableViewer.getSelection();
                assert (!selected.isEmpty());
                LaunchUtil.launchPdfReader((String)((UploadHistoryEntry)selected.getFirstElement()).getFile().toString());
            }
        });
        colPrint.setText("");
        colPrint.setResizable(false);
        TableViewerColumn colNameViewer = new TableViewerColumn(this.uploadTableViewer, 16384);
        colNameViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((UploadHistoryEntry)element).getFile().getFileName().toString();
            }
        });
        TableColumn colName = colNameViewer.getColumn();
        colName.setWidth(280);
        colName.setText(Messages.translate((String)"release.history.table.name", (Object[])new Object[0]));
        TableViewerColumn colDateViewer = new TableViewerColumn(this.uploadTableViewer, 16384);
        colDateViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return Messages.translate((String)"release.history.date", (Object[])new Object[]{Date.from(((UploadHistoryEntry)element).getTimestamp())});
            }
        });
        TableColumn colDate = colDateViewer.getColumn();
        colDate.setWidth(200);
        colDate.setText(Messages.translate((String)"release.history.table.timestamp", (Object[])new Object[0]));
        this.uploadTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.uploadTableViewer.setUseHashlookup(true);
        Collections.sort(this.history, (entry1, entry2) -> entry2.getTimestamp().compareTo(entry1.getTimestamp()));
        this.uploadTableViewer.setInput(this.history);
        colPrint.pack();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.translate((String)(this.releaseMode == ReleaseMode.DEPOT ? "release.history.upload.depot" : "release.history.upload.tlv"), (Object[])new Object[0]), true);
        this.createButton(parent, 1, Messages.translate((String)"label.button.cancel", (Object[])new Object[0]), false);
    }
}

