/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.upload;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.Taxme;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpMainhelpAction;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.ge.pp.presentation.cd.GeTaxWindow;
import ch.dvbern.tax.ge.pp.presentation.cd.util.GeResources;
import ch.dvbern.tax.ge.pp.upload.ReleaseMode;
import javax.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseDialog
extends Dialog {
    private static final Logger LOG = LoggerFactory.getLogger(ReleaseDialog.class);
    private final boolean withAttachments;
    private final boolean readyForRelease;
    private final boolean codeDeclaAvailable;
    private final boolean codeDeclaCorrect;
    private ReleaseMode releaseMode;

    public ReleaseDialog(Shell parentShell, boolean withAttachments, boolean readyForRelease, boolean codeDeclaAvailable, boolean codeDeclaCorrect) {
        super(parentShell);
        this.withAttachments = withAttachments;
        this.readyForRelease = readyForRelease;
        this.codeDeclaAvailable = codeDeclaAvailable;
        this.codeDeclaCorrect = codeDeclaCorrect;
    }

    @Nullable
    public ReleaseMode getReleaseMode() {
        return this.releaseMode;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.translate((String)"release.dialog.title", (Object[])new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        int upperPanelsWidth = 370;
        int upperPanelsTextWidth = 355;
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        Label introLbl = new Label(mainPanel, 0);
        introLbl.setText(Messages.translate((String)"release.dialog.intro", (Object[])new Object[0]));
        introLbl.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        GridDataFactory upperPanelsGdFty = GridDataFactory.fillDefaults().align(4, 4).grab(true, true);
        GridDataFactory upperPanelsChildGdFty = GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, false);
        GridDataFactory lblGdFty = GridDataFactory.swtDefaults().align(0x1000000, 128).hint(355, -1).grab(true, false);
        SelectionListener openHelpLst = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                HelpMainhelpAction help = new HelpMainhelpAction(ReleaseDialog.this.getShell(), event.text);
                help.run();
            }
        };
        GridLayoutFactory upperPanelGLFty = GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(true).spacing(0, 10).extendedMargins(0, 0, 10, 10);
        Composite depotPanel = new Composite(mainPanel, 2048);
        depotPanel.setLayoutData((Object)upperPanelsGdFty.create());
        depotPanel.setLayout((Layout)upperPanelGLFty.create());
        Label depotTitleLbl = new Label(depotPanel, 0x1000040);
        depotTitleLbl.setLayoutData((Object)upperPanelsChildGdFty.copy().hint(370, -1).align(4, 0x1000000).create());
        depotTitleLbl.setText(Messages.translate((String)"release.dialog.depot", (Object[])new Object[0]));
        depotTitleLbl.setFont(GeResources.Font.DIALOG_TITLE.get());
        Button depotBtn = new Button(depotPanel, 8);
        depotBtn.setText(Messages.translate((String)"release.dialog.depot.btn", (Object[])new Object[0]));
        depotBtn.setLayoutData((Object)upperPanelsChildGdFty.create());
        depotBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ReleaseDialog.this.setReleaseMode(ReleaseMode.DEPOT);
            }
        });
        Image img = GeResources.Icon.EDEMARCHES.get();
        Rectangle imgBounds = img.getBounds();
        Composite depotLblPanel = new Composite(depotPanel, 0);
        depotLblPanel.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).create());
        this.addBullet(depotLblPanel);
        Label depotLbl = new Label(depotLblPanel, 64);
        depotLbl.setText(Messages.translate((String)"release.dialog.depot.label.1", (Object[])new Object[0]));
        depotLbl.setLayoutData((Object)lblGdFty.create());
        this.addBullet(depotLblPanel);
        StyledText depotStyledLbl = new StyledText(depotLblPanel, 64);
        String lblText1 = Messages.translate((String)"release.dialog.depot.label.2a", (Object[])new Object[0]);
        depotStyledLbl.setText(lblText1 + "\u00a0" + Messages.translate((String)"release.dialog.depot.label.2b", (Object[])new Object[0]));
        StyleRange style = new StyleRange();
        depotStyledLbl.setBackground(this.getShell().getBackground());
        style.start = lblText1.length();
        style.length = 1;
        style.metrics = new GlyphMetrics(imgBounds.height, 0, imgBounds.width);
        depotStyledLbl.setStyleRange(style);
        depotStyledLbl.setLayoutData((Object)lblGdFty.create());
        depotStyledLbl.addPaintObjectListener(event -> {
            GC gc = event.gc;
            StyleRange style1 = event.style;
            int start = style1.start;
            if (start == lblText1.length()) {
                int x = event.x;
                int y = event.y + event.ascent - style1.metrics.ascent + 3;
                gc.drawImage(img, x, y);
            }
        });
        depotStyledLbl.setEditable(false);
        depotStyledLbl.setEnabled(false);
        Link depotHelpLnk = new Link(depotPanel, 0);
        depotHelpLnk.setText(Messages.translate((String)"release.dialog.depot.help", (Object[])new Object[0]));
        depotHelpLnk.addSelectionListener(openHelpLst);
        Composite tlvPanel = new Composite(mainPanel, 2048);
        tlvPanel.setLayoutData((Object)upperPanelsGdFty.create());
        tlvPanel.setLayout((Layout)upperPanelGLFty.create());
        Label tlvTitleLbl = new Label(tlvPanel, 0x1000040);
        tlvTitleLbl.setFont(GeResources.Font.DIALOG_TITLE.get());
        tlvTitleLbl.setText(Messages.translate((String)"release.dialog.tlv", (Object[])new Object[0]));
        tlvTitleLbl.setLayoutData((Object)upperPanelsChildGdFty.copy().hint(370, -1).grab(true, false).align(4, 0x1000000).create());
        Button tlvBtn = new Button(tlvPanel, 8);
        tlvBtn.setLayoutData((Object)upperPanelsChildGdFty.create());
        tlvBtn.setText(Messages.translate((String)"release.dialog.tlv.btn", (Object[])new Object[0]));
        tlvBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ReleaseDialog.this.setReleaseMode(ReleaseMode.SOUMISSION);
            }
        });
        Composite tlvLblPanel = new Composite(tlvPanel, 0);
        tlvLblPanel.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).create());
        tlvLblPanel.setLayoutData((Object)upperPanelsChildGdFty.create());
        this.addBullet(tlvLblPanel);
        Label tlvLbl = new Label(tlvLblPanel, 64);
        tlvLbl.setText(Messages.translate((String)"release.dialog.tlv.label.1", (Object[])new Object[0]));
        tlvLbl.setLayoutData((Object)lblGdFty.create());
        this.addBullet(tlvLblPanel);
        tlvLbl = new Label(tlvLblPanel, 64);
        tlvLbl.setText(Messages.translate((String)"release.dialog.tlv.label.2", (Object[])new Object[0]));
        tlvLbl.setLayoutData((Object)lblGdFty.create());
        this.addBullet(tlvLblPanel);
        tlvLbl = new Label(tlvLblPanel, 64);
        tlvLbl.setText(Messages.translate((String)"release.dialog.tlv.label.3", (Object[])new Object[0]));
        tlvLbl.setLayoutData((Object)lblGdFty.create());
        Link tlvHelpLnk = new Link(tlvPanel, 0);
        tlvHelpLnk.setText(Messages.translate((String)"release.dialog.tlv.help", (Object[])new Object[0]));
        tlvHelpLnk.addSelectionListener(openHelpLst);
        tlvHelpLnk.setLayoutData((Object)upperPanelsChildGdFty.create());
        int lblHeight = Math.max(depotPanel.computeSize((int)-1, (int)-1).y, tlvPanel.computeSize((int)-1, (int)-1).y);
        depotPanel.setLayoutData((Object)GridDataFactory.swtDefaults().hint(-1, lblHeight).create());
        tlvPanel.setLayoutData((Object)GridDataFactory.swtDefaults().hint(-1, lblHeight).create());
        int mainPanelWidth = mainPanel.computeSize((int)-1, (int)-1).x;
        Composite printPanel = new Composite(mainPanel, 2048);
        printPanel.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        printPanel.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        Label printTitleLbl = new Label(printPanel, 64);
        printTitleLbl.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        printTitleLbl.setText(Messages.translate((String)"release.dialog.print", (Object[])new Object[0]));
        printTitleLbl.setFont(GeResources.Font.DIALOG_TITLE.get());
        Label printLbl = new Label(printPanel, 64);
        printLbl.setText(Messages.translate((String)"release.dialog.print.label", (Object[])new Object[0]));
        printLbl.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).hint(mainPanelWidth, -1).create());
        Link printLnk = new Link(printPanel, 0);
        printLnk.setText(Messages.translate((String)"release.dialog.print.help", (Object[])new Object[0]));
        printLnk.addSelectionListener(openHelpLst);
        Button printBtn = new Button(printPanel, 72);
        printBtn.setText(Messages.translate((String)"release.dialog.print.btn", (Object[])new Object[0]));
        printBtn.setLayoutData((Object)GridDataFactory.swtDefaults().hint(150, -1).align(131072, 0x1000000).grab(true, false).create());
        printBtn.setFont(GeResources.Font.SMALL.get());
        printBtn.addSelectionListener((SelectionListener)new ReleaseButtonListener(ReleaseMode.PRINT){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                ReleaseDialog.this.setReleaseMode(ReleaseMode.PRINT);
            }
        });
        printBtn.setEnabled(this.isPrintBarcodeEnabled());
        mainPanel.layout();
        return mainPanel;
    }

    private boolean isPrintBarcodeEnabled() {
        boolean departDeces;
        Taxme taxmeWindow = TaxmeController.getInstance().getApp();
        boolean bl = departDeces = taxmeWindow != null && ((GeTaxWindow)taxmeWindow).isDepartDeces();
        return departDeces || TaxmeConfig.isDebugEnabled();
    }

    private void addBullet(Composite panel) {
        Label bulletLbl = new Label(panel, 0);
        bulletLbl.setText("\u2022");
        bulletLbl.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 128).create());
    }

    private void setReleaseMode(ReleaseMode releaseMode) {
        assert (releaseMode != null);
        if (!this.readyForRelease) {
            DialogUtil.showWarningDialog((Shell)this.getShell(), (String)"release.dialog.error.state", (Object[])new Object[0]);
            return;
        }
        if (this.codeDeclaAvailable && !this.codeDeclaCorrect) {
            DialogUtil.showWarningDialog((Shell)this.getShell(), (String)"release.dialog.error.codeDecla", (Object[])new Object[0]);
            return;
        }
        switch (releaseMode) {
            case DEPOT: 
            case SOUMISSION: {
                if (this.codeDeclaAvailable) break;
                MessageDialog dlg = new MessageDialog(this.getShell(), Messages.translate((String)"title.warning", (Object[])new Object[0]), null, Messages.translate((String)"release.dialog.error.codeDecla.1", (Object[])new Object[0]), 4, new String[]{Messages.translate((String)"label.button.ok", (Object[])new Object[0])}, 0){

                    protected Control createCustomArea(Composite parent) {
                        Composite panel = new Composite(parent, 0);
                        panel.setLayout((Layout)new GridLayout(2, false));
                        Label lbl = new Label(panel, 0);
                        lbl.setText(Messages.translate((String)"release.dialog.error.codeDecla.2", (Object[])new Object[0]));
                        lbl.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
                        ReleaseDialog.this.addBullet(panel);
                        lbl = new Label(panel, 0);
                        lbl.setText(Messages.translate((String)"release.dialog.error.codeDecla.2a", (Object[])new Object[]{ApplicationConfig.getInstance().getJahr()}));
                        ReleaseDialog.this.addBullet(panel);
                        lbl = new Label(panel, 0);
                        lbl.setText(Messages.translate((String)"release.dialog.error.codeDecla.2b", (Object[])new Object[0]));
                        return panel;
                    }
                };
                dlg.open();
                releaseMode = null;
                break;
            }
            case PRINT: {
                if (!this.withAttachments) break;
                PrintWithAttachmentsDialog printWithAttDialog = new PrintWithAttachmentsDialog(this.getShell());
                printWithAttDialog.open();
                releaseMode = printWithAttDialog.releaseMode;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown enum member: " + String.valueOf(releaseMode)));
            }
        }
        this.releaseMode = releaseMode;
        if (releaseMode != null) {
            this.okPressed();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, Messages.configurableTranslate((String)"label.button.cancel", (Object[])new Object[0]), false).setFocus();
    }

    private class PrintWithAttachmentsDialog
    extends IconAndMessageDialog {
        ReleaseMode releaseMode;

        PrintWithAttachmentsDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.translate((String)"title.warning", (Object[])new Object[0]));
        }

        protected Control createDialogArea(Composite parent) {
            this.createMessageArea(parent);
            Composite mainPanel = new Composite(parent, 0);
            mainPanel.setLayout((Layout)RowLayoutFactory.swtDefaults().spacing(10).type(512).create());
            Label lbl1 = new Label(mainPanel, 64);
            lbl1.setText(Messages.translate((String)"release.dialog.print.withAttachments.1", (Object[])new Object[0]));
            Label lbl2 = new Label(mainPanel, 64);
            lbl2.setText(Messages.translate((String)"release.dialog.print.withAttachments.2", (Object[])new Object[0]));
            Composite btnPanel = new Composite(mainPanel, 0);
            btnPanel.setLayout((Layout)new GridLayout(4, false));
            Label printAttachLbl1 = new Label(btnPanel, 0);
            printAttachLbl1.setText(Messages.translate((String)"release.dialog.print.withAttachments.choice.1", (Object[])new Object[0]));
            Button tlvBtn = new Button(btnPanel, 8);
            tlvBtn.setText(Messages.translate((String)"release.dialog.tlv.btn", (Object[])new Object[0]));
            tlvBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PrintWithAttachmentsDialog.this.releaseMode = ReleaseMode.SOUMISSION;
                    PrintWithAttachmentsDialog.this.okPressed();
                }
            });
            tlvBtn.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).create());
            Label printAttachLbl2 = new Label(btnPanel, 0);
            printAttachLbl2.setText(Messages.translate((String)"release.dialog.print.withAttachments.choice.2", (Object[])new Object[0]));
            Button printBtn = new Button(btnPanel, 8);
            printBtn.setText(Messages.translate((String)"release.dialog.print.btn", (Object[])new Object[0]));
            printBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PrintWithAttachmentsDialog.this.releaseMode = ReleaseMode.PRINT;
                    PrintWithAttachmentsDialog.this.okPressed();
                }
            });
            RowDataFactory lblGdFty = RowDataFactory.swtDefaults().hint(btnPanel.computeSize((int)-1, (int)-1).x, -1);
            lblGdFty.applyTo((Control)lbl1);
            lblGdFty.applyTo((Control)lbl2);
            return mainPanel;
        }

        protected void createButtonsForButtonBar(Composite parent) {
        }

        protected Image getImage() {
            return Display.getCurrent().getSystemImage(8);
        }
    }

    private class ReleaseButtonListener
    extends SelectionAdapter {
        final ReleaseMode releaseMode;

        ReleaseButtonListener(ReleaseMode releaseMode) {
            assert (releaseMode != null);
            this.releaseMode = releaseMode;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            ReleaseDialog.this.setReleaseMode(this.releaseMode);
        }
    }
}

