/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.upload;

import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.PrintJob;
import ch.dvbern.tax.common.presentation.cd.util.PrintUtilCD;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.ge.pp.presentation.cd.GeDvbTaxCdSession;
import ch.dvbern.tax.ge.pp.transfer.utils.Barcode;
import ch.dvbern.tax.ge.pp.transfer.utils.BarcodeConfiguration;
import ch.dvbern.tax.ge.pp.transfer.utils.PersistenceKeysRegistry;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

class PrepareUploadTask
implements IRunnableWithProgress {
    private final BarcodeConfiguration barcodeConfiguration;
    private final OutputStream pdfStream;
    private final OutputStream barcodeStream;

    PrepareUploadTask(@Nonnull BarcodeConfiguration barcodeConfiguration, @Nonnull OutputStream barcodeStream, @Nonnull OutputStream pdfStream) {
        this.barcodeConfiguration = Objects.requireNonNull(barcodeConfiguration, "Barcode configuration cannot be null.");
        this.barcodeStream = Objects.requireNonNull(barcodeStream, "Barcode stream cannot be null.");
        this.pdfStream = Objects.requireNonNull(pdfStream, "PDF stream cannot be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        TaxmeController ctrl = TaxmeController.getInstance();
        GeDvbTaxCdSession session = (GeDvbTaxCdSession)ctrl.getTmoCdSession();
        try {
            int pdfWorkAmount = 80;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                this.getPdfDeclaPP(this.barcodeConfiguration.getTimestamp(), ctrl, (IProgressMonitor)subMonitor.newChild(pdfWorkAmount), this.pdfStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)this.pdfStream);
            }
            PersistenceKeysRegistry persistenceKeysRegistry = session.getPersistenceKeysRegistry();
            Barcode barcodeGenerator = Barcode.newInstance((PersistenceKeysRegistry)persistenceKeysRegistry, (Map)session.getDataModel());
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter(this.barcodeStream, Barcode.CHARSET);
                barcodeGenerator.writeBarcode(this.barcodeConfiguration, (Writer)writer);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private void getPdfDeclaPP(long timestamp, TaxmeController ctrl, IProgressMonitor monitor, OutputStream output) throws InvocationTargetException, InterruptedException {
        List formKeys = SharedUtils.getUploadFormKeys((DvbTaxSession)ctrl.getTmoCdSession());
        PrintRequest printRequest = PrintUtilCD.newPrintRequest().withFormKeys(formKeys).withConfiguration(GeConstants.newPrintConfiguration().withTimestamp(timestamp));
        PrintJob pj = new PrintJob(printRequest, output);
        pj.run(monitor);
    }
}

