/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.justificatifs;

import ch.dvbern.dvbtax.esteuerauszugextractor.Extractor;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.Taxme;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.presentation.cd.GeTaxWindow;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.DocNotCorrespondingTaxYearException;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.SteuerauszugExtractionException;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import ch.ech.xmlns.ech_0196._2.BankAccountType;
import ch.ech.xmlns.ech_0196._2.LiabilityAccountType;
import ch.ech.xmlns.ech_0196._2.SecurityDepotType;
import ch.ech.xmlns.ech_0196._2.SecurityPaymentType;
import ch.ech.xmlns.ech_0196._2.SecuritySecurityType;
import ch.ech.xmlns.ech_0196._2.SecurityStockType;
import ch.ech.xmlns.ech_0196._2.TaxStatement;
import com.google.common.base.Enums;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class ExtractBankStatement {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractBankStatement.class);

    private ExtractBankStatement() {
    }

    public static void extract(@NonNull Path filePath, @NonNull String description, @NonNull String commandDmk) throws SteuerauszugExtractionException {
        TaxStatement taxStatement = ExtractBankStatement.extractXmlFromPdf(filePath);
        if (taxStatement != null) {
            ExtractBankStatement.readAndWriteToModel(filePath, description, commandDmk, taxStatement);
        }
    }

    private static @Nullable TaxStatement extractXmlFromPdf(@NonNull Path filePath) {
        byte[] xml = null;
        TaxStatement ts = null;
        if (TaxmeConfig.isDebugEnabled() && "xml".equals(FilenameUtils.getExtension((String)filePath.toString()))) {
            try {
                xml = IOUtils.toByteArray((InputStream)new FileInputStream(filePath.toFile()));
            }
            catch (IOException e) {
                throw new SteuerauszugExtractionException("couldn't read xml-File", e);
            }
        }
        PDDocument pdfDoc = null;
        try {
            pdfDoc = PDDocument.load((File)filePath.toFile());
        }
        catch (IOException e) {
            throw new SteuerauszugExtractionException("PDDocument loading failure", e);
        }
        if (pdfDoc == null) {
            throw new SteuerauszugExtractionException("PDDocument cannot be null");
        }
        try {
            byte[] fileContents = Files.readAllBytes(filePath);
            Extractor extractor = new Extractor();
            xml = extractor.pdfToXml(fileContents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (xml == null) {
            throw new SteuerauszugExtractionException("Parsed XML is null");
        }
        if (TaxmeConfig.isDebugEnabled()) {
            try {
                File debugFile = new File(String.valueOf(filePath.getFileName()) + "_embedded.xml");
                FileUtils.writeByteArrayToFile((File)debugFile, (byte[])xml);
                LOG.info("PDF embedded XML: {}", (Object)debugFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error("Failed to dump barcode file.", (Throwable)e);
            }
        }
        try {
            JAXBContext jbx = JAXBContext.newInstance((Class[])new Class[]{TaxStatement.class});
            Unmarshaller um = jbx.createUnmarshaller();
            ts = (TaxStatement)um.unmarshal((InputStream)new ByteArrayInputStream(xml));
        }
        catch (JAXBException e) {
            LOG.error("xml does not seam to be valid.", (Throwable)e);
        }
        try {
            ch.ewv.taxstatement.TaxStatement.validateXML((byte[])xml);
        }
        catch (IOException | ParseException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new SteuerauszugExtractionException("XML validation failure", e);
        }
        try {
            ch.ewv.taxstatement.TaxStatement.verifyXML((byte[])xml);
        }
        catch (IOException | MarshalException | XMLSignatureException | ParserConfigurationException | SAXException e) {
            LOG.warn("XML verification failure", (Throwable)e);
        }
        return ts;
    }

    private static void readAndWriteToModel(@NonNull Path filePath, @NonNull String description, @NonNull String commandDmk, @NonNull TaxStatement auszug) {
        DvbTaxCdSession session = TaxmeController.getInstance().getTmoCdSession();
        HashMap<String, ModelItemDTO> newTitreDTOs = new HashMap<String, ModelItemDTO>();
        String titreTableDmk = Objects.requireNonNull(EngineUtil.getTableDataModelKey(commandDmk), "Fehler beim Referenzieren der Tabelle " + commandDmk);
        LogicModelItem.TableItem titreTable = (LogicModelItem.TableItem)((Object)session.getLogicModel().get(titreTableDmk));
        int steuerjahr = Objects.requireNonNull(ExtractBankStatement.getLocalDate(auszug.getTaxPeriod()), "Steuerjahr fehlt im XML").getYear();
        Taxme taxmeWindow = TaxmeController.getInstance().getApp();
        boolean departDeces = taxmeWindow != null && ((GeTaxWindow)taxmeWindow).isDepartDeces();
        int applicationYear = ApplicationConfig.getInstance().getJahr();
        if (departDeces) {
            ++applicationYear;
        }
        if (steuerjahr != applicationYear) {
            throw new DocNotCorrespondingTaxYearException();
        }
        ModelItemDTO maxGroupNoDTO = Objects.requireNonNull(session.getDataModel()).get("Titres.Divers.MaxGroupNo");
        long eReleveNo = 1L;
        if (maxGroupNoDTO != null && maxGroupNoDTO.getValue() != null) {
            eReleveNo = (Long)maxGroupNoDTO.getValue() + 1L;
        }
        Long appartenance = (Long)session.getDataModel().get(EngineUtil.mergeModelKey(titreTableDmk + ".Appartenance", commandDmk)).getValue();
        Boolean fortuneCommerciale = (Boolean)session.getDataModel().get(EngineUtil.mergeModelKey("Titres.Divers.DiversTable.EReleves.AvoirCommerciauxCheck", commandDmk)).getValue();
        ExtractBankStatement.writeTypeERF(newTitreDTOs, commandDmk, steuerjahr, eReleveNo, auszug, (DvbTaxSession)session, filePath, description);
        ExtractBankStatement.writeTypeComptes(newTitreDTOs, titreTableDmk, titreTable, steuerjahr, eReleveNo, auszug, (DvbTaxSession)session, appartenance, fortuneCommerciale);
        ExtractBankStatement.writeTypeDettes(newTitreDTOs, titreTableDmk, titreTable, steuerjahr, eReleveNo, auszug, (DvbTaxSession)session, appartenance, fortuneCommerciale);
        ExtractBankStatement.writeTypeTitres(newTitreDTOs, titreTableDmk, titreTable, steuerjahr, eReleveNo, auszug, (DvbTaxSession)session, appartenance, fortuneCommerciale);
        session.recalculate();
    }

    private static void writeTypeTitres(Map<String, ModelItemDTO> newTitreDTOs, String titreTableDmk, LogicModelItem.TableItem titreTable, int steuerjahr, long eReleveNo, @NonNull TaxStatement auszug, DvbTaxSession session, @Nullable Long appartenance, @Nullable Boolean commerciaux) {
        if (auszug.getListOfSecurities() != null) {
            HashMap<String, ModelItemDTO> newMutationDTOs = new HashMap<String, ModelItemDTO>();
            for (SecurityDepotType depot : auszug.getListOfSecurities().getDepot()) {
                for (SecuritySecurityType security : depot.getSecurity()) {
                    int newTitreRow = EngineUtil.getNextTableItemIndex(new LogicModelItem.ProtectedMap(Objects.requireNonNull(session.getDataModel()), true), titreTable, titreTableDmk);
                    String titreRowDmk = titreTableDmk + "." + newTitreRow;
                    if (security.getSecurityType() != null && security.getSecurityType().name().equals(SecurityCategory.SHARE_PARTCERT.getName())) {
                        ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.TypeDeFortune", SecurityCategory.SHARE_PARTCERT.getTypeFortune());
                    } else {
                        ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.TypeDeFortune", ((SecurityCategory)((Object)Enums.getIfPresent(SecurityCategory.class, (String)security.getSecurityCategory().name()).or((Object)SecurityCategory.OTHER))).getTypeFortune());
                    }
                    ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.GroupNo", eReleveNo);
                    ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.Appartenance", appartenance);
                    ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.AvoirCommerciauxCheck", commerciaux);
                    ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.NoValeur", security.getValorNumber() == null ? null : String.valueOf(security.getValorNumber()));
                    ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.Cotation", security.getValorNumber() != null);
                    ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.Designation", security.getSecurityName());
                    if (security.getPayment() != null) {
                        ModelItemDTO PPHCSuisseItemDTO;
                        boolean PPHCSuiss;
                        BigDecimal sumA = security.getPayment().stream().filter(a -> a.getGrossRevenueA() != null).map(SecurityPaymentType::getGrossRevenueA).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        BigDecimal sumB = security.getPayment().stream().filter(b -> b.getGrossRevenueB() != null).map(SecurityPaymentType::getGrossRevenueB).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        BigDecimal sumC = security.getPayment().stream().filter(c -> c.getAdditionalWithHoldingTaxUSA() != null).map(SecurityPaymentType::getAdditionalWithHoldingTaxUSA).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        String country = security.getCountry();
                        BigDecimal nonRecoverableTaxAmount = security.getPayment().stream().filter(d -> d.getNonRecoverableTaxAmount() != null).map(SecurityPaymentType::getNonRecoverableTaxAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        BigDecimal nonRecoverableTaxPercent = ExtractBankStatement.getNonRecoverableTaxPercentIfAllSame(security.getPayment());
                        if (!nonRecoverableTaxAmount.equals(BigDecimal.ZERO) && (nonRecoverableTaxPercent == null || nonRecoverableTaxPercent.equals(BigDecimal.ZERO))) {
                            nonRecoverableTaxPercent = nonRecoverableTaxAmount.multiply(BigDecimal.valueOf(100L)).divide(sumB, 2, RoundingMode.HALF_UP);
                        }
                        boolean bl = PPHCSuiss = (PPHCSuisseItemDTO = Objects.requireNonNull(session.getDataModel()).get("Stammdaten.Declaration.PPHCsuisse")) != null && (Boolean)PPHCSuisseItemDTO.getValue() != false;
                        if (PPHCSuiss) {
                            ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.RevenusSansIAInput", sumA);
                        } else {
                            ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.RevenusAvecIAInput", sumA);
                            ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.RevenusSansIAInput", sumB);
                        }
                        ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.InteretsEchusInput", sumA.add(sumB));
                        ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.RetenueUsaTitresFromEreleve", sumC);
                        if (sumC.compareTo(BigDecimal.ZERO) > 0) {
                            ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.RetenueUsaCheck", true);
                            ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.FromEreleve", true);
                        }
                        if (!country.isEmpty() && nonRecoverableTaxPercent != null) {
                            ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.PaysDa1", country);
                            ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.ImputationDa1", true);
                            ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.PourcentageDa1", nonRecoverableTaxPercent);
                            ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.ImpotEtrangerNonRecuperableDa1FromEreleve", nonRecoverableTaxAmount);
                        }
                    }
                    session.update(newTitreDTOs, false);
                    newTitreDTOs.clear();
                    ExtractBankStatement.writeTypeTransactions(newTitreDTOs, titreRowDmk, newMutationDTOs, steuerjahr, session, security);
                }
            }
        }
    }

    private static @Nullable BigDecimal getNonRecoverableTaxPercentIfAllSame(Collection<SecurityPaymentType> payments) {
        if (payments == null || payments.isEmpty()) {
            return null;
        }
        AtomicReference firstValue = new AtomicReference();
        boolean allSame = payments.stream().map(SecurityPaymentType::getNonRecoverableTaxPercent).allMatch(currentValue -> {
            if (firstValue.get() == null) {
                if (currentValue != null) {
                    firstValue.set(currentValue);
                }
                return true;
            }
            return ((BigDecimal)firstValue.get()).compareTo((BigDecimal)currentValue) == 0;
        });
        return allSame ? (BigDecimal)firstValue.get() : null;
    }

    private static void writeTypeTransactions(Map<String, ModelItemDTO> newTitreDTOs, String titreRowDmk, Map<String, ModelItemDTO> newMutationDTOs, int steuerjahr, DvbTaxSession session, SecuritySecurityType security) {
        BigDecimal quantityFinal = BigDecimal.ZERO;
        BigDecimal taxValue = BigDecimal.ZERO;
        if (security.getTaxValue() != null) {
            quantityFinal = security.getTaxValue().getQuantity();
            taxValue = security.getTaxValue().getValue() != null ? security.getTaxValue().getValue() : BigDecimal.ZERO;
        }
        ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.FortuneImposableInput", taxValue);
        BigDecimal totalQuantityMutation = BigDecimal.ZERO;
        session.update(newTitreDTOs, false);
        newTitreDTOs.clear();
        if (security.getStock() != null) {
            String titreRowMutationTableDmk = titreRowDmk + ".Titres.TransactionsTable";
            String mutationTableDmk = EngineUtil.removeTableIndices(titreRowMutationTableDmk);
            LogicModelItem.TableItem mutationTable = (LogicModelItem.TableItem)((Object)session.getLogicModel().get(mutationTableDmk));
            Supplier<Stream> stockStream = () -> security.getStock().stream().filter(stock -> {
                LocalDate refDate = ExtractBankStatement.getLocalDate(stock.getReferenceDate());
                return stock.isMutation() && Objects.requireNonNull(refDate).getYear() == steuerjahr;
            });
            ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.Operations", !stockStream.get().collect(Collectors.toList()).isEmpty());
            totalQuantityMutation = stockStream.get().map(SecurityStockType::getQuantity).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            stockStream.get().forEach(stock -> {
                int newMutationRow = EngineUtil.getNextTableItemIndex(new LogicModelItem.ProtectedMap(Objects.requireNonNull(session.getDataModel()), true), mutationTable, titreRowMutationTableDmk);
                String mutationRowDmk = titreRowMutationTableDmk + "." + newMutationRow;
                Date refDate = stock.getReferenceDate().toGregorianCalendar().getTime();
                BigDecimal quantityMutation = stock.getQuantity().abs();
                String genre = stock.getQuantity().compareTo(BigDecimal.ZERO) >= 0 ? "AE+" : "VR-";
                ExtractBankStatement.putValueIntoModel(newMutationDTOs, mutationRowDmk, "Titres.Divers.DiversTable.Titres.TransactionsTable.Date", refDate);
                ExtractBankStatement.putValueIntoModel(newMutationDTOs, mutationRowDmk, "Titres.Divers.DiversTable.Titres.TransactionsTable.Nombre", quantityMutation);
                ExtractBankStatement.putValueIntoModel(newMutationDTOs, mutationRowDmk, "Titres.Divers.DiversTable.Titres.TransactionsTable.Genre", genre);
                session.update(newMutationDTOs, false);
                newMutationDTOs.clear();
            });
        }
        ExtractBankStatement.putValueIntoModel(newTitreDTOs, titreRowDmk, "Titres.Divers.DiversTable.Titres.ValeurNominaleInitial", quantityFinal.subtract(totalQuantityMutation).doubleValue());
        session.update(newTitreDTOs, false);
        newTitreDTOs.clear();
    }

    private static void writeTypeDettes(Map<String, ModelItemDTO> newTitreDTOs, String titreTableDmk, LogicModelItem.TableItem titreTable, int steuerjahr, long eReleveNo, @NonNull TaxStatement auszug, DvbTaxSession session, @Nullable Long appartenance, @Nullable Boolean commerciaux) {
        if (auszug.getListOfLiabilities() != null) {
            for (LiabilityAccountType liabAcc : auszug.getListOfLiabilities().getLiabilityAccount()) {
                int newRow = EngineUtil.getNextTableItemIndex(new LogicModelItem.ProtectedMap(Objects.requireNonNull(session.getDataModel()), true), titreTable, titreTableDmk);
                String rowDmk = titreTableDmk + "." + newRow;
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, titreTableDmk, null);
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.TypeDeFortune", GeConstants.TypeDeFortune.CPT.name());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.GroupNo", eReleveNo);
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.InteretsDebiteurs", true);
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.SoldeDebiteur", true);
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.NoCompte", liabAcc.getIban());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.NomEtablissement", liabAcc.getBankAccountName());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.InteretsDebiteurValueInput", liabAcc.getTotalGrossRevenueB());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.SoldeDebiteurValueInput", liabAcc.getTotalTaxValue());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.Appartenance", appartenance);
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.AvoirCommerciauxCheck", commerciaux);
                TaxPeriod period = new TaxPeriod(steuerjahr, ExtractBankStatement.getLocalDate(liabAcc.getOpeningDate()), ExtractBankStatement.getLocalDate(liabAcc.getClosingDate()));
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.Operation", period.getOperationType());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.DateOperation", period.getOperationDate());
                session.update(newTitreDTOs, false);
                newTitreDTOs.clear();
            }
        }
    }

    private static void writeTypeComptes(Map<String, ModelItemDTO> newTitreDTOs, String titreTableDmk, LogicModelItem.TableItem titreTable, int steuerjahr, long eReleveNo, @NonNull TaxStatement auszug, @NonNull DvbTaxSession session, @Nullable Long appartenance, @Nullable Boolean commerciaux) {
        if (auszug.getListOfBankAccounts() != null) {
            for (BankAccountType bankAcc : auszug.getListOfBankAccounts().getBankAccount()) {
                int newRow = EngineUtil.getNextTableItemIndex(new LogicModelItem.ProtectedMap(Objects.requireNonNull(session.getDataModel()), true), titreTable, titreTableDmk);
                String rowDmk = titreTableDmk + "." + newRow;
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.TypeDeFortune", GeConstants.TypeDeFortune.CPT.name());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.GroupNo", eReleveNo);
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.NoCompte", bankAcc.getIban());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.NomEtablissement", bankAcc.getBankAccountName());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.RevenusAvecIAInput", bankAcc.getTotalGrossRevenueA());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.RevenusSansIAInput", bankAcc.getTotalGrossRevenueB());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.InteretsEchusInput", bankAcc.getTotalGrossRevenueA().add(bankAcc.getTotalGrossRevenueB()));
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.FortuneImposableInput", bankAcc.getTotalTaxValue());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.Appartenance", appartenance);
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.AvoirCommerciauxCheck", commerciaux);
                TaxPeriod period = new TaxPeriod(steuerjahr, ExtractBankStatement.getLocalDate(bankAcc.getOpeningDate()), ExtractBankStatement.getLocalDate(bankAcc.getClosingDate()));
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.Operation", period.getOperationType());
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, "Titres.Divers.DiversTable.Comptes.DateOperation", period.getOperationDate());
                session.update(newTitreDTOs, false);
                newTitreDTOs.clear();
                ExtractBankStatement.putValueIntoModel(newTitreDTOs, rowDmk, titreTableDmk, null, true);
                session.update(newTitreDTOs, false);
                newTitreDTOs.clear();
            }
        }
    }

    private static void writeTypeERF(Map<String, ModelItemDTO> newTitreDTOs, @NonNull String commandDmk, int steuerjahr, long eReleveNo, @NonNull TaxStatement auszug, DvbTaxSession session, @NonNull Path filePath, @NonNull String description) {
        ExtractBankStatement.putValueIntoModel(newTitreDTOs, commandDmk, "Titres.Divers.DiversTable.EReleves.EReleveImported", true);
        ExtractBankStatement.putValueIntoModel(newTitreDTOs, commandDmk, "Titres.Divers.DiversTable.EReleves.GroupNo", eReleveNo);
        ExtractBankStatement.putValueIntoModel(newTitreDTOs, commandDmk, "Titres.Divers.DiversTable.EReleves.AttachedFileName", filePath.getFileName().toString());
        ExtractBankStatement.putValueIntoModel(newTitreDTOs, commandDmk, "Titres.Divers.DiversTable.EReleves.AttachedFileDescription", description);
        ExtractBankStatement.putValueIntoModel(newTitreDTOs, commandDmk, "Titres.Divers.DiversTable.EReleves.NoDepot", auszug.getId());
        ExtractBankStatement.putValueIntoModel(newTitreDTOs, commandDmk, "Titres.Divers.DiversTable.EReleves.Designation", auszug.getInstitution().getName());
        if (auszug.getListOfExpenses() != null) {
            BigDecimal totalExpenses = auszug.getListOfExpenses().getTotalExpenses();
            BigDecimal totalExpensesDeductible = auszug.getListOfExpenses().getTotalExpensesDeductible();
            BigDecimal totalExpensesDeductibleCanton = auszug.getListOfExpenses().getTotalExpensesDeductibleCanton();
            if (totalExpensesDeductibleCanton != null) {
                totalExpenses = totalExpensesDeductibleCanton;
            } else if (totalExpensesDeductible != null) {
                totalExpenses = totalExpensesDeductible;
            }
            ExtractBankStatement.putValueIntoModel(newTitreDTOs, commandDmk, "Titres.Divers.DiversTable.EReleves.FraisBancairesInput", totalExpenses);
        }
        TaxPeriod period = new TaxPeriod(steuerjahr, ExtractBankStatement.getLocalDate(auszug.getPeriodFrom()), ExtractBankStatement.getLocalDate(auszug.getPeriodTo()));
        ExtractBankStatement.putValueIntoModel(newTitreDTOs, commandDmk, "Titres.Divers.DiversTable.EReleves.Operation", period.getOperationType());
        ExtractBankStatement.putValueIntoModel(newTitreDTOs, commandDmk, "Titres.Divers.DiversTable.EReleves.DateOperation", period.getOperationDate());
        session.update(newTitreDTOs, false);
        newTitreDTOs.clear();
    }

    private static void putValueIntoModel(@NonNull Map<String, ModelItemDTO> newValues, @NonNull String rowDmk, @NonNull String lmk, @Nullable Object value, boolean setStateOk) {
        String dmk = EngineUtil.mergeModelKey(lmk, rowDmk);
        ModelItemDTO mi = SharedUtils.createTouchedItem((Object)value, (boolean)setStateOk);
        newValues.put(dmk, mi);
    }

    private static @Nullable LocalDate getLocalDate(@Nullable XMLGregorianCalendar cal) {
        return cal == null ? null : cal.toGregorianCalendar().toZonedDateTime().toLocalDate();
    }

    private static void putValueIntoModel(@NonNull Map<String, ModelItemDTO> newValues, @NonNull String rowDmk, @NonNull String lmk, @Nullable Object value) {
        ExtractBankStatement.putValueIntoModel(newValues, rowDmk, lmk, value, false);
    }

    private static enum SecurityCategory {
        BOND("OBL"),
        COINBULL("MET"),
        DEVT("DEV"),
        FUND("FDS"),
        LIBOSWAP("DEV"),
        OPTION("DEV"),
        OTHER("AUT"),
        SHARE("ACT"),
        SHARE_PARTCERT("PQ");

        private final String typeFortune;

        private SecurityCategory(String typeFortune) {
            this.typeFortune = typeFortune;
        }

        private String getTypeFortune() {
            return this.typeFortune;
        }

        private String getName() {
            return this.name();
        }
    }

    private static class TaxPeriod {
        private final int steuerjahr;
        private final @Nullable LocalDate dateFrom;
        private final @Nullable LocalDate dateTo;
        private long operationType;
        private @Nullable LocalDate operationDate;

        public TaxPeriod(int steuerjahr, @Nullable LocalDate dateFrom, @Nullable LocalDate dateTo) {
            this.steuerjahr = steuerjahr;
            this.dateFrom = dateFrom;
            this.dateTo = dateTo;
            this.invoke();
        }

        private static boolean isLastDayOfYear(LocalDate dateTo) {
            return dateTo.isLeapYear() ? dateTo.getDayOfYear() == 366 : dateTo.getDayOfYear() == 365;
        }

        public long getOperationType() {
            return this.operationType;
        }

        public @Nullable LocalDate getOperationDate() {
            return this.operationDate;
        }

        private void invoke() {
            this.operationType = OperationType.AUCUNE.getOptionItemValue();
            this.operationDate = null;
            if (this.dateFrom != null && this.dateFrom.getYear() == this.steuerjahr && this.dateFrom.getDayOfYear() != 1) {
                this.operationType = OperationType.OUVERTURE.getOptionItemValue();
                this.operationDate = this.dateFrom;
            } else if (this.dateTo != null && this.dateTo.getYear() == this.steuerjahr && !TaxPeriod.isLastDayOfYear(this.dateTo)) {
                this.operationType = OperationType.FERMETURE.getOptionItemValue();
                this.operationDate = this.dateTo;
            }
        }
    }

    public static enum OperationType {
        AUCUNE(1L, false),
        OUVERTURE(2L, true),
        FERMETURE(3L, true);

        private final long optionItemValue;
        private final boolean operation;

        private OperationType(long optionItemValue, boolean operation) {
            this.optionItemValue = optionItemValue;
            this.operation = operation;
        }

        public long getOptionItemValue() {
            return this.optionItemValue;
        }

        public boolean isOperation() {
            return this.operation;
        }
    }
}

