/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.util.BrowserUtil;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WelcomeDialog
extends Dialog {
    private final String infoFilePath;
    private boolean doNotShowAnymore = false;

    public WelcomeDialog(@Nullable Shell parentShell, @Nonnull String infoFilePath) {
        super(parentShell);
        if (infoFilePath == null) {
            throw new NullPointerException("Info file path cannot be null.");
        }
        this.infoFilePath = infoFilePath;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.translate((String)"title.dialog.welcome", (Object[])new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        File infoFile = new File(TaxmeConfig.getInfoFilePath((String)this.infoFilePath));
        Composite panel = new Composite(parent, 0);
        Browser browser = BrowserUtil.createBrowser((Composite)panel, (int)2048, (boolean)false);
        RowLayout layout = new RowLayout(512);
        layout.marginBottom = 5;
        layout.marginTop = 5;
        layout.marginRight = 5;
        layout.marginLeft = 5;
        panel.setLayout((Layout)layout);
        RowData layoutData = new RowData();
        layoutData.width = 700;
        Rectangle res = super.getShell().getDisplay().getBounds();
        layoutData.height = res.height < 1050 ? 580 : 700;
        browser.setLayoutData((Object)layoutData);
        browser.setUrl(infoFile.getAbsolutePath());
        return panel;
    }

    public boolean isDoNotShowAnymoreSelected() {
        return this.doNotShowAnymore;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.translate((String)"label.button.start", (Object[])new Object[0]), false);
    }
}

