/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.dialog;

import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.bd.cd.DvbTaxCdSession;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeTitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommands;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrument;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrumentType;
import ch.dvbern.tax.ge.pp.presentation.cd.action.ValorSearchCDHelper;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ValorDatabaseDialog
extends TaxmeTitleAreaDialog {
    private static final int FISCAL_YEAR = ApplicationConfig.getInstance().getJahr();
    private static final String SEARCH_RESULT = "label.valordatabase.searchresult";
    private static final String NO_SEARCH_RESULT = "label.valordatabase.nosearchresult";
    private final DvbTaxInstrumentType type;
    private Table searchResultTable;
    private String selectedValorNumber = null;

    public ValorDatabaseDialog(Shell parentShell, DvbTaxInstrumentType type) {
        super(parentShell);
        this.type = type;
    }

    protected Control createDialogArea(Composite parent) {
        LocalizationHelper locHelper = TaxmeController.getInstance().getLocalizationHelper();
        this.getShell().setText(locHelper.translate("title.shell.valor.search", new Object[0]));
        this.setTitle(locHelper.translate("title.valor.search.dialog", new Object[0]));
        this.setMessage(locHelper.translate("label.valor.search.dialog", new Object[0]));
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createContent(composite);
        return composite;
    }

    private void createContent(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 20;
        layout.marginLeft = 20;
        layout.marginBottom = 20;
        layout.marginRight = 20;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData());
        final Text searchText = new Text(panel, 2048);
        GridData gd = new GridData();
        gd.widthHint = 300;
        searchText.setLayoutData((Object)gd);
        Button searchAction = new Button(panel, 0);
        searchAction.setText(Messages.translate((String)"label.button.valordatabase.search", (Object[])new Object[]{searchAction}));
        searchText.addModifyListener(me -> this.getShell().setDefaultButton(searchAction));
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = 400;
        new Label(panel, 0).setLayoutData((Object)gd);
        final Label searchResultTitel = new Label(panel, 0);
        searchResultTitel.setText(Messages.translate((String)SEARCH_RESULT, (Object[])new Object[]{searchResultTitel}));
        searchResultTitel.setLayoutData((Object)gd);
        final Table searchResultTable = new Table(panel, 68100);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = 400;
        gd.heightHint = 200;
        searchResultTable.setLayoutData((Object)gd);
        searchResultTable.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        searchResultTable.setLinesVisible(true);
        searchResultTable.setEnabled(true);
        TableColumn colNumber = new TableColumn(searchResultTable, 16384);
        colNumber.setWidth(100);
        TableColumn colText = new TableColumn(searchResultTable, 16384);
        colText.setWidth(300);
        this.searchResultTable = searchResultTable;
        final TableViewer searchResultViewer = new TableViewer(searchResultTable);
        searchResultViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object rows) {
                if (rows instanceof List) {
                    return ((List)rows).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        });
        searchResultViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object row, int col) {
                return null;
            }

            public String getColumnText(Object row, int col) {
                DvbTaxInstrument instrument = (DvbTaxInstrument)row;
                switch (col) {
                    case 0: {
                        return String.valueOf(instrument.getValorNumber());
                    }
                    case 1: {
                        return instrument.getInstitutionIdentifier();
                    }
                }
                return "";
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void removeListener(ILabelProviderListener arg0) {
            }
        });
        searchResultViewer.setUseHashlookup(true);
        searchAction.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                searchResultTitel.setText(Messages.translate((String)ValorDatabaseDialog.SEARCH_RESULT, (Object[])new Object[0]));
                List result = new ValorSearchCDHelper((DvbTaxSession)TaxmeController.getInstance().getTmoCdSession()).searchInstruments(ValorDatabaseDialog.this.type, searchText.getText());
                if (result.size() > 0) {
                    ValorDatabaseDialog.this.getButton(0).setEnabled(false);
                    searchResultViewer.setInput((Object)result);
                    searchResultTable.deselectAll();
                    searchResultTable.setFocus();
                    searchResultTable.setSelection(0);
                    ValorDatabaseDialog.this.getButton(0).setEnabled(true);
                    ValorDatabaseDialog.this.getShell().setDefaultButton(ValorDatabaseDialog.this.getButton(0));
                } else {
                    searchText.setFocus();
                    searchResultTitel.setText(Messages.translate((String)ValorDatabaseDialog.NO_SEARCH_RESULT, (Object[])new Object[0]));
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        searchResultTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ValorDatabaseDialog.this.getButton(0).setEnabled(true);
                ValorDatabaseDialog.this.getShell().setDefaultButton(ValorDatabaseDialog.this.getButton(0));
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        searchResultTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
                if (searchResultTable.getSelection().length > 0) {
                    ValorDatabaseDialog.this.okPressed();
                }
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        if (this.searchResultTable.getSelection().length > 0) {
            TableItem[] tis = this.searchResultTable.getSelection();
            this.selectedValorNumber = tis[0].getText();
        }
        super.okPressed();
    }

    @Nullable
    public String getSelectedValorNumber() {
        return this.selectedValorNumber;
    }

    public static class ValorDatabaseButtonCommand
    implements ButtonCommand {
        public void init(IButtonItem buttonDTO) {
        }

        public void execute(IButtonItem buttonDTO) {
            DvbTaxCdSession session = TaxmeController.getInstance().getTmoCdSession();
            Map<String, ModelItemDTO> dataModel = session.getDataModel();
            String valorTypeDMK = EngineUtil.mergeModelKey("Titres.Divers.DiversTable.TypeDeFortune", buttonDTO.getCommandDmk());
            String valorTypeStr = DataModelUtil.getRequiredValue(dataModel, String.class, valorTypeDMK);
            GeConstants.TypeDeFortune typeDeFortune = GeConstants.TypeDeFortune.valueOf((String)valorTypeStr);
            ValorDatabaseDialog vdd = new ValorDatabaseDialog(TaxmeController.getInstance().getShell(), typeDeFortune.getInstrumentType());
            vdd.open();
            String selectedValorNumber = vdd.getSelectedValorNumber();
            if (selectedValorNumber != null) {
                String valorNumberDMK = EngineUtil.mergeModelKey("Titres.Divers.DiversTable.Titres.NoValeur", buttonDTO.getCommandDmk());
                session.update(Collections.singletonMap(valorNumberDMK, SharedUtils.createTouchedItem((Object)selectedValorNumber)), true);
                ButtonCommands.get((String)"/valor.search.cmd").execute(buttonDTO);
            }
        }
    }
}

