/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd.dialog;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.dialog.TaxmeTitleAreaDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InfoMandataireDialog
extends TaxmeTitleAreaDialog {
    private static final char CHAR_NEWLINE = '\n';
    protected Button buttonJa;
    protected Button buttonNein;
    protected boolean modifyListenerEnabled = false;
    private Text textNom;
    private Text textNo;
    private Text textRue;
    private Text textNpa;
    private Text textLocalite;
    private Text textEmail;
    private Text textTelephone;

    public InfoMandataireDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.translate((String)"title.shell.info.mandataire", (Object[])new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.translate((String)"title.info.mandataire", (Object[])new Object[0]));
        this.setMessage(Messages.translate((String)"label.info.mandataire", (Object[])new Object[0]));
        return this.createContent(parent);
    }

    protected void refresh() {
        this.modifyListenerEnabled = false;
        if (!this.buttonNein.getSelection()) {
            this.textNom.setEnabled(true);
            this.textNo.setEnabled(true);
            this.textRue.setEnabled(true);
            this.textNpa.setEnabled(true);
            this.textLocalite.setEnabled(true);
            this.textEmail.setEnabled(true);
            this.textTelephone.setEnabled(true);
            this.textNom.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
            this.textNo.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
            this.textRue.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
            this.textNpa.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
            this.textLocalite.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
            this.textEmail.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
            this.textTelephone.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        } else {
            this.textNom.setEnabled(false);
            this.textNo.setEnabled(false);
            this.textRue.setEnabled(false);
            this.textNpa.setEnabled(false);
            this.textLocalite.setEnabled(false);
            this.textEmail.setEnabled(false);
            this.textTelephone.setEnabled(false);
            this.textNom.setText("");
            this.textNo.setText("");
            this.textRue.setText("");
            this.textNpa.setText("");
            this.textLocalite.setText("");
            this.textEmail.setText("");
            this.textTelephone.setText("");
            this.textNom.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY));
            this.textNo.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY));
            this.textRue.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY));
            this.textNpa.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY));
            this.textLocalite.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY));
            this.textEmail.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY));
            this.textTelephone.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY));
        }
        this.modifyListenerEnabled = true;
    }

    private Composite createContent(Composite parent) {
        this.modifyListenerEnabled = false;
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setFont(parent.getFont());
        Label labelMandataireOuiOuNon = new Label(panel, 64);
        labelMandataireOuiOuNon.setText(Messages.translate((String)"label.stammdaten.mandataire.question", (Object[])new Object[]{labelMandataireOuiOuNon}));
        GridData gdMandataireQuestion = new GridData();
        gdMandataireQuestion.horizontalSpan = 3;
        labelMandataireOuiOuNon.setLayoutData((Object)gdMandataireQuestion);
        Composite c = new Composite(panel, 4);
        c.setLayout((Layout)new FillLayout());
        GridData gdButtonJa = new GridData(768);
        gdButtonJa.horizontalSpan = 1;
        c.setLayoutData((Object)gdButtonJa);
        this.buttonJa = new Button(c, 16);
        this.buttonJa.setText(Messages.translate((String)"label.ja", (Object[])new Object[]{this.buttonJa}));
        this.buttonJa.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                InfoMandataireDialog.this.buttonJa.setSelection(true);
                InfoMandataireDialog.this.buttonNein.setSelection(false);
                InfoMandataireDialog.this.refresh();
            }
        });
        this.buttonNein = new Button(c, 16);
        this.buttonNein.setText(Messages.translate((String)"label.nein", (Object[])new Object[]{this.buttonNein}));
        this.buttonNein.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                InfoMandataireDialog.this.buttonJa.setSelection(false);
                InfoMandataireDialog.this.buttonNein.setSelection(true);
                InfoMandataireDialog.this.refresh();
            }
        });
        ModifyListener ml = ev -> {
            if (this.modifyListenerEnabled) {
                this.buttonJa.setSelection(true);
                this.buttonNein.setSelection(false);
            }
        };
        Label labelNom = new Label(panel, 64);
        labelNom.setText(Messages.translate((String)"label.stammdaten.mandataire.nom", (Object[])new Object[]{labelNom}));
        GridData gdLabelNom = new GridData();
        gdLabelNom.horizontalSpan = 1;
        labelNom.setLayoutData((Object)gdLabelNom);
        this.textNom = new Text(panel, 2048);
        this.textNom.setTextLimit(30);
        GridData gdTextNom = new GridData(768);
        gdTextNom.horizontalSpan = 3;
        this.textNom.setLayoutData((Object)gdTextNom);
        this.textNom.addModifyListener(ml);
        Label labelRue = new Label(panel, 64);
        labelRue.setText(Messages.translate((String)"label.stammdaten.mandataire.rue", (Object[])new Object[]{labelRue}));
        GridData gdLabelRue = new GridData();
        gdLabelRue.horizontalSpan = 1;
        labelRue.setLayoutData((Object)gdLabelRue);
        this.textNo = new Text(panel, 2048);
        this.textNo.setTextLimit(10);
        GridData gdTextNo = new GridData();
        gdTextNo.horizontalSpan = 1;
        gdTextNo.widthHint = 100;
        this.textNo.setLayoutData((Object)gdTextNo);
        this.textNo.addModifyListener(ml);
        this.textRue = new Text(panel, 2048);
        this.textRue.setTextLimit(20);
        GridData gdTextRue = new GridData(768);
        gdTextRue.horizontalSpan = 2;
        this.textRue.setLayoutData((Object)gdTextRue);
        this.textRue.addModifyListener(ml);
        Label labelLocalite = new Label(panel, 64);
        labelLocalite.setText(Messages.translate((String)"label.stammdaten.mandataire.lieu", (Object[])new Object[]{labelLocalite}));
        GridData gdLabelLocalite = new GridData();
        gdLabelLocalite.horizontalSpan = 1;
        labelLocalite.setLayoutData((Object)gdLabelLocalite);
        this.textNpa = new Text(panel, 2048);
        this.textNpa.setTextLimit(10);
        GridData gdTextNpa = new GridData();
        gdTextNpa.horizontalSpan = 1;
        gdTextNpa.widthHint = 100;
        this.textNpa.setLayoutData((Object)gdTextNpa);
        this.textNpa.addModifyListener(ml);
        this.textLocalite = new Text(panel, 2048);
        this.textLocalite.setTextLimit(20);
        GridData gdTextLocalite = new GridData(768);
        gdTextLocalite.horizontalSpan = 2;
        this.textLocalite.setLayoutData((Object)gdTextLocalite);
        this.textLocalite.addModifyListener(ml);
        Label labelEmail = new Label(panel, 64);
        labelEmail.setText(Messages.translate((String)"label.stammdaten.mandataire.email", (Object[])new Object[]{labelEmail}));
        GridData gdlabelEmail = new GridData();
        gdlabelEmail.horizontalSpan = 1;
        labelEmail.setLayoutData((Object)gdlabelEmail);
        this.textEmail = new Text(panel, 2048);
        this.textEmail.setTextLimit(30);
        GridData gdTextEmail = new GridData(768);
        gdTextEmail.horizontalSpan = 3;
        this.textEmail.setLayoutData((Object)gdTextEmail);
        this.textEmail.addModifyListener(ml);
        Label labelTelephone = new Label(panel, 64);
        labelTelephone.setText(Messages.translate((String)"label.stammdaten.mandataire.tel", (Object[])new Object[]{labelTelephone}));
        GridData gdLabelTelephone = new GridData();
        gdLabelTelephone.horizontalSpan = 1;
        labelTelephone.setLayoutData((Object)gdLabelTelephone);
        this.textTelephone = new Text(panel, 2048);
        this.textTelephone.setTextLimit(18);
        GridData gdTextTelephone = new GridData();
        gdTextTelephone.horizontalSpan = 1;
        gdTextTelephone.widthHint = 100;
        this.textTelephone.setLayoutData((Object)gdTextTelephone);
        this.textTelephone.addModifyListener(ml);
        this.setValuesFromConfig();
        this.refresh();
        return panel;
    }

    private void setValuesFromConfig() {
        this.buttonJa.setSelection(TaxmeConfig.getBoolean((String)"Stammdaten.MandataireOuiNon"));
        if (TaxmeConfig.getString((String)"Stammdaten.MandataireOuiNon") != null) {
            this.buttonNein.setSelection(!TaxmeConfig.getBoolean((String)"Stammdaten.MandataireOuiNon"));
        }
        this.textNom.setText(TaxmeConfig.getString((String)"Stammdaten.MandataireNom") != null ? TaxmeConfig.getString((String)"Stammdaten.MandataireNom") : "");
        this.textNo.setText(TaxmeConfig.getString((String)"Stammdaten.MandataireNo") != null ? TaxmeConfig.getString((String)"Stammdaten.MandataireNo") : "");
        this.textRue.setText(TaxmeConfig.getString((String)"Stammdaten.MandataireRue") != null ? TaxmeConfig.getString((String)"Stammdaten.MandataireRue") : "");
        this.textNpa.setText(TaxmeConfig.getString((String)"Stammdaten.MandataireNpa") != null ? TaxmeConfig.getString((String)"Stammdaten.MandataireNpa") : "");
        this.textLocalite.setText(TaxmeConfig.getString((String)"Stammdaten.MandataireLieu") != null ? TaxmeConfig.getString((String)"Stammdaten.MandataireLieu") : "");
        this.textEmail.setText(TaxmeConfig.getString((String)"Stammdaten.MandataireEmail") != null ? TaxmeConfig.getString((String)"Stammdaten.MandataireEmail") : "");
        this.textTelephone.setText(TaxmeConfig.getString((String)"Stammdaten.MandataireTel") != null ? TaxmeConfig.getString((String)"Stammdaten.MandataireTel") : "");
    }

    private void setValuesToConfig() {
        TaxmeConfig.setValue((String)"Stammdaten.MandataireOuiNon", (boolean)this.buttonJa.getSelection());
        TaxmeConfig.setValue((String)"Stammdaten.MandataireNom", (String)this.textNom.getText());
        TaxmeConfig.setValue((String)"Stammdaten.MandataireNo", (String)this.textNo.getText());
        TaxmeConfig.setValue((String)"Stammdaten.MandataireRue", (String)this.textRue.getText());
        TaxmeConfig.setValue((String)"Stammdaten.MandataireNpa", (String)this.textNpa.getText());
        TaxmeConfig.setValue((String)"Stammdaten.MandataireLieu", (String)this.textLocalite.getText());
        TaxmeConfig.setValue((String)"Stammdaten.MandataireEmail", (String)this.textEmail.getText());
        TaxmeConfig.setValue((String)"Stammdaten.MandataireTel", (String)this.textTelephone.getText());
    }

    protected void okPressed() {
        if (this.buttonJa.getSelection()) {
            StringBuilder message = new StringBuilder(48);
            if (this.textNom.getText().length() <= 0) {
                message.append('\n').append(Messages.translate((String)"error.missing.data.stammdaten.mandataire.nom", (Object[])new Object[0]));
                this.textNom.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED));
            }
            if (this.textNpa.getText().length() <= 0) {
                message.append('\n').append(Messages.translate((String)"error.missing.data.stammdaten.mandataire.npa", (Object[])new Object[0]));
                this.textNpa.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED));
            }
            if (this.textLocalite.getText().length() <= 0) {
                message.append('\n').append(Messages.translate((String)"error.missing.data.stammdaten.mandataire.lieu", (Object[])new Object[0]));
                this.textLocalite.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED));
            }
            if (message.length() > 0) {
                DialogUtil.showErrorDialog((String)message.toString(), (Object[])new Object[0]);
                return;
            }
        }
        this.setValuesToConfig();
        super.okPressed();
    }

    protected void cancelPressed() {
        if (TaxmeConfig.getString((String)"Stammdaten.MandataireOuiNon") == null) {
            TaxmeConfig.setValue((String)"Stammdaten.MandataireOuiNon", (boolean)false);
        }
        super.cancelPressed();
    }
}

