/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.presentation.cd;

import ch.dvbern.tax.common.integration.DvbTaxIdentification;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.bd.AuthenticationData;
import ch.dvbern.tax.common.presentation.bd.cd.AbstractDvbTaxCdSessionImpl;
import ch.dvbern.tax.common.presentation.cd.Taxme;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ValidateAction;
import ch.dvbern.tax.common.presentation.common.util.FileImageSource;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.presentation.common.util.TaxFile;
import ch.dvbern.tax.common.presentation.common.util.TaxFileUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import ch.dvbern.tax.ge.pp.presentation.cd.GeTaxWindow;
import ch.dvbern.tax.ge.pp.presentation.cd.justificatifs.FSDocumentStore;
import ch.dvbern.tax.ge.pp.presentation.cd.util.GeCdApplicationConfig;
import ch.dvbern.tax.ge.pp.transfer.utils.PersistenceKeysRegistry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeDvbTaxCdSession
extends AbstractDvbTaxCdSessionImpl {
    private static final Logger LOG = LoggerFactory.getLogger(GeDvbTaxCdSession.class);
    private static final Map<String, Object> TAX_FILE_SYSTEM_ENV;
    public static final String ATTACHMENTS_ROOT_DIRECTORY = "/doc";
    private final PersistenceKeysRegistry persistenceKeysRegistry = PersistenceKeysRegistry.newInstance((List)this.getPersistenceReadDTOs());
    private Path taxFile;
    private File sourceTaxfile = null;

    public GeDvbTaxCdSession() {
        super(TaxmeConfig.getString((String)"path.model.xml"), TaxmeConfig.getDataResource());
    }

    public PersistenceKeysRegistry getPersistenceKeysRegistry() {
        return this.persistenceKeysRegistry;
    }

    public synchronized File getFile() {
        return this.taxFile != null ? this.taxFile.toFile() : null;
    }

    public synchronized void setFile(File newTaxFile) {
        if (this.taxFile != null && newTaxFile != null) {
            newTaxFile.delete();
            this.manageAttachments(newTaxFile);
        }
        this.taxFile = newTaxFile != null ? newTaxFile.toPath() : null;
    }

    public DvbTaxIdentification login(AuthenticationData authData) throws InvalidAuthenticationException {
        DvbTaxIdentification id = super.login(authData);
        if (this.getFile() == null) {
            Taxme taxmeWindow = TaxmeController.getInstance().getApp();
            boolean departDeces = taxmeWindow != null && ((GeTaxWindow)taxmeWindow).isDepartDeces();
            long year = ((GeCdApplicationConfig)ApplicationConfig.getInstance()).getEffectiveYear(departDeces);
            HashMap<String, ModelItemDTO> initMap = new HashMap<String, ModelItemDTO>();
            initMap.put("Stammdaten.Declaration.PeriodeTaxation", this.createTouchedItem(year));
            initMap.put("Stammdaten.Declaration.DepartDeces", this.createTouchedItem(departDeces));
            this.update(initMap, false);
        }
        return id;
    }

    private ModelItemDTO createTouchedItem(Object value) {
        ModelItemDTO item = new ModelItemDTO(value);
        item.setTouched();
        return item;
    }

    private void manageAttachments(File newTaxFile) {
        try (final FileSystem newTaxfileFileSystem = this.openTaxFileSystem(newTaxFile.toPath());
             FileSystem oldTaxfileFileSystem = this.openTaxFileSystem(this.taxFile);){
            Files.walkFileTree(oldTaxfileFileSystem.getPath("/", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path oldTaxfileDir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(newTaxfileFileSystem.getPath(oldTaxfileDir.toString(), new String[0]), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path oldTaxfile, BasicFileAttributes attrs) throws IOException {
                    Files.copy(oldTaxfile, newTaxfileFileSystem.getPath(oldTaxfile.toString(), new String[0]), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new ApplicationException("Failed to relocate tax file.", e);
        }
    }

    public synchronized void save() throws IOException {
        if (this.taxFile == null) {
            throw new IllegalStateException("No tax file set, cannot save.");
        }
        this.writeFile(this.taxFile);
        this.setChangesSaved(true);
    }

    private void writeFile(Path file) throws IOException {
        try (FileSystem taxFileFS = this.openTaxFileSystem(file);){
            Path model = taxFileFS.getPath("dvb-tax-model-12345678909876543210", new String[0]);
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(model, StandardOpenOption.CREATE));){
                TaxFileUtil.write(out, this.getDataModel(), "");
            }
        }
    }

    @Nonnull
    public synchronized FSDocumentStore openDocumentStore() throws IOException {
        if (this.taxFile == null) {
            throw new IllegalStateException("Must save-as before opening document store.");
        }
        return new FSDocumentStore(this.openTaxFileSystem(this.taxFile).getPath(ATTACHMENTS_ROOT_DIRECTORY, new String[0]));
    }

    public synchronized void updateDocumentStore() {
        if (TaxmeController.getInstance().isTempTaxfileEnabled()) {
            this.setChangesSaved(false);
        }
    }

    private FileSystem openTaxFileSystem(Path file) throws IOException {
        FileSystem fileSystem;
        assert (file != null);
        URI uri = URI.create("jar:" + String.valueOf(file.toUri()));
        try {
            fileSystem = FileSystems.newFileSystem(uri, TAX_FILE_SYSTEM_ENV);
        }
        catch (FileSystemAlreadyExistsException e) {
            fileSystem = FileSystems.getFileSystem(uri);
        }
        return fileSystem;
    }

    protected Map<String, ModelItemDTO> readDataModel() throws InvalidAuthenticationException, IOException {
        if (this.taxFile == null) {
            return new HashMap<String, ModelItemDTO>(200);
        }
        try (FileSystem taxFileFS = this.openTaxFileSystem(this.taxFile);){
            Map<String, ModelItemDTO> map;
            Path modelFile = taxFileFS.getPath("dvb-tax-model-12345678909876543210", new String[0]);
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(modelFile, new OpenOption[0]));){
                map = TaxFileUtil.read(is, "");
            }
            return map;
        }
    }

    public ImageSource getFormImageSource() {
        if (this.isUnterjaehrig()) {
            return new FileImageSource(new File(TaxmeConfig.getString((String)"forms.dir.unterjaehrig")));
        }
        return super.getFormImageSource();
    }

    public ImageSource getImageSource() {
        if (this.isUnterjaehrig()) {
            return new FileImageSource(new File(TaxmeConfig.getString((String)"image.dir.unterjaehrig")));
        }
        return super.getImageSource();
    }

    public boolean isUnterjaehrig() {
        Map dataModel = Objects.requireNonNull(TaxmeController.getInstance().getTmoCdSession().getDataModel());
        ModelItemDTO unterjaehrig = dataModel.getOrDefault("Stammdaten.Declaration.DepartDeces", new ModelItemDTO(Boolean.FALSE));
        Boolean value = (Boolean)unterjaehrig.getValue();
        assert (value != null);
        return value;
    }

    public synchronized void importData(Map<String, ModelItemDTO> newValues, boolean allowDelete) {
        super.importData(newValues, allowDelete);
        new ValidateAction().execute(this.getWizardDisplayInfo("Stammdaten.Declaration").getFormItemDTO());
    }

    public synchronized TaxFile getTaxFile() {
        return new TaxFile(this.taxFile.toFile(), null);
    }

    public void setSourceTaxFile(File file) {
        this.sourceTaxfile = file;
    }

    public File getSourceTaxfile() {
        return this.sourceTaxfile;
    }

    static {
        HashMap<String, Object> envMap = new HashMap<String, Object>();
        envMap.put("useTempFile", Boolean.TRUE);
        envMap.put("create", "true");
        TAX_FILE_SYSTEM_ENV = Collections.unmodifiableMap(envMap);
    }
}

