/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.ictax;

import ch.dvbern.tax.ge.pp.online.integration.xml.ictax.UnmarshallHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.joda.time.LocalDate;

class ICTAXXMLMetaData {
    private static final String YEAR_PROP = "year";
    private static final String CREATION_DATE_PROP = "creationDate";
    private static final String INFO_FILE_NAME = "info.properties";
    private final int year;
    private final LocalDate creationDate;

    ICTAXXMLMetaData(int year, @Nonnull LocalDate creationDate) {
        if (year <= 0) {
            throw new IllegalArgumentException("Year must be strictly greater than zero.");
        }
        if (creationDate == null) {
            throw new NullPointerException("Creation date cannot ben null.");
        }
        this.year = year;
        this.creationDate = creationDate;
    }

    @Nonnull
    static ICTAXXMLMetaData load(@Nonnull URL databaseURL) throws IOException {
        if (databaseURL == null) {
            throw new NullPointerException("Database URL cannot be null.");
        }
        try (BufferedInputStream is = new BufferedInputStream(new URL(databaseURL, INFO_FILE_NAME).openStream());){
            ICTAXXMLMetaData iCTAXXMLMetaData = ICTAXXMLMetaData.load(is);
            return iCTAXXMLMetaData;
        }
    }

    @Nonnull
    static ICTAXXMLMetaData load(@Nonnull Path databasePath) throws IOException {
        if (databasePath == null) {
            throw new NullPointerException("Database path cannot be null.");
        }
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(databasePath.resolve(INFO_FILE_NAME), new OpenOption[0]));){
            ICTAXXMLMetaData iCTAXXMLMetaData = ICTAXXMLMetaData.load(is);
            return iCTAXXMLMetaData;
        }
    }

    private static ICTAXXMLMetaData load(@Nonnull InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException("Input stream cannot be null.");
        }
        Properties infoProps = new Properties();
        infoProps.load(is);
        String yearProp = ICTAXXMLMetaData.getRequiredProperty(infoProps, YEAR_PROP);
        String creationDateProp = ICTAXXMLMetaData.getRequiredProperty(infoProps, CREATION_DATE_PROP);
        int year = Integer.parseInt(yearProp);
        LocalDate creationDate = UnmarshallHelper.parseDate((String)creationDateProp);
        return new ICTAXXMLMetaData(year, creationDate);
    }

    private static String getRequiredProperty(Properties props, String key) {
        assert (props != null && key != null);
        String value = props.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("Missing required property in meta-data file: " + key);
        }
        return value;
    }

    void store(Path databasePath) throws IOException {
        if (databasePath == null) {
            throw new NullPointerException("Database directory cannot be null.");
        }
        Properties infoProps = new Properties();
        infoProps.setProperty(YEAR_PROP, String.valueOf(this.year));
        infoProps.setProperty(CREATION_DATE_PROP, UnmarshallHelper.printDate((LocalDate)this.creationDate));
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(databasePath.resolve(INFO_FILE_NAME), new OpenOption[0]));){
            infoProps.store(os, null);
        }
    }

    int getYear() {
        return this.year;
    }

    @Nonnull
    LocalDate getCreationDate() {
        return this.creationDate;
    }

    public String toString() {
        return String.format("[year=%d, creationDate=%s]", this.year, this.creationDate);
    }
}

