/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.ictax;

import ch.admin.estv.xmlns.ictax._1_2_0.kursliste.ExchangeRateYearEnd;
import ch.admin.estv.xmlns.ictax._1_2_0.kursliste.Instrument;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrument;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrumentType;
import ch.dvbern.tax.ge.pp.ictax.ICTAXUtils;
import ch.dvbern.tax.ge.pp.ictax.ICTAXXMLMetaData;
import ch.dvbern.tax.ge.pp.online.integration.xml.ictax.UnmarshallHelper;
import ch.dvbern.tax.ge.pp.presentation.cd.util.ZipHelper;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICTAXXMLDatabaseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ICTAXXMLDatabaseUtils.class);
    private static final QName ROOT_NAME = new QName("http://xmlns.estv.admin.ch/ictax/1.2.0/kursliste", "kursliste");
    private static final QName EXCHANGE_RATE_YEAR_END_NAME = new QName("http://xmlns.estv.admin.ch/ictax/1.2.0/kursliste", "exchangeRateYearEnd");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createIndex(Path valorXMLFile, Path valorIdxDir) throws XMLStreamException, IOException, JAXBException {
        LOG.info("Started processing file: {}", (Object)valorXMLFile);
        long startTime = System.currentTimeMillis();
        XMLInputFactory fty = XMLInputFactory.newFactory();
        XMLStreamReader reader = null;
        Path indexDir = valorIdxDir.resolve("db");
        FileUtils.deleteQuietly((File)indexDir.toFile());
        Files.createDirectory(indexDir, new FileAttribute[0]);
        int instrumentCounter = 0;
        try (InputStream valorXMLStream2 = Files.newInputStream(valorXMLFile, new OpenOption[0]);
             OutputStream exchangeRateStream = Files.newOutputStream(indexDir.resolve("exchangeRate.properties"), new OpenOption[0]);){
            reader = fty.createXMLStreamReader(valorXMLStream2);
            StandardAnalyzer analyzer = new StandardAnalyzer();
            SimpleFSDirectory index = new SimpleFSDirectory(indexDir.toFile());
            IndexWriterConfig config = new IndexWriterConfig(Version.LATEST, (Analyzer)analyzer);
            IndexWriter indexWriter = new IndexWriter((Directory)index, config);
            reader.nextTag();
            if (!"http://xmlns.estv.admin.ch/ictax/1.2.0/kursliste".equals(reader.getNamespaceURI())) {
                throw new InternalFailureException("Wrong namespace in valor database: " + reader.getNamespaceURI());
            }
            QName rootName = reader.getName();
            if (!ROOT_NAME.equals(rootName)) {
                throw new InternalFailureException("Unexpected root element: " + String.valueOf(rootName));
            }
            String creationDate = reader.getAttributeValue(null, "creationDate");
            JAXBContext jaxbContext = ICTAXUtils.createICTAXJAXBContext();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Properties exchangeRateProps = new Properties();
            int year = Integer.parseInt(reader.getAttributeValue(null, "year"));
            ICTAXXMLMetaData md = new ICTAXXMLMetaData(year, UnmarshallHelper.parseDate((String)creationDate));
            md.store(valorIdxDir);
            while (reader.hasNext()) {
                ExchangeRateYearEnd rate;
                if (reader.next() != 1) continue;
                QName eltName = reader.getName();
                DvbTaxInstrumentType instrumentType = DvbTaxInstrumentType.forQName((QName)eltName);
                if (instrumentType != null) {
                    Instrument instrument = ICTAXUtils.unmarshallFragment((XMLStreamReader)reader, (Class)instrumentType.getJAXBClass());
                    if (instrument.isDeleted()) continue;
                    DvbTaxInstrument dvbTaxInstrument = instrumentType.build(instrument);
                    StringWriter sw = new StringWriter();
                    ICTAXUtils.marshall((DvbTaxInstrument)dvbTaxInstrument, (Writer)sw);
                    ICTAXXMLDatabaseUtils.addToIndex(indexWriter, sw.toString(), dvbTaxInstrument, instrumentType);
                    ++instrumentCounter;
                    continue;
                }
                if (!EXCHANGE_RATE_YEAR_END_NAME.equals(eltName) || (rate = (ExchangeRateYearEnd)unmarshaller.unmarshal(reader, ExchangeRateYearEnd.class).getValue()).getYear() != year) continue;
                exchangeRateProps.setProperty(rate.getCurrency(), rate.getValue().toString());
            }
            indexWriter.close();
            exchangeRateProps.store(exchangeRateStream, "ICTAX exchange rates at 31.12." + year);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException valorXMLStream2) {}
            }
        }
        Path zipFile = valorIdxDir.resolve("ictax.zip");
        Files.deleteIfExists(zipFile);
        ZipHelper.zip(indexDir, zipFile);
        LOG.info("{} instrument processed in {}ms.", (Object)instrumentCounter, (Object)(System.currentTimeMillis() - startTime));
    }

    private static void addToIndex(IndexWriter indexWriter, String fragment, DvbTaxInstrument instrument, DvbTaxInstrumentType type) throws IOException {
        Document doc = new Document();
        FieldType ft = new FieldType();
        ft.setIndexed(false);
        ft.setStored(true);
        ft.setNumericType(FieldType.NumericType.INT);
        doc.add((IndexableField)new StoredField("xmlFragment", fragment));
        doc.add((IndexableField)new IntField("type", type.ordinal(), Field.Store.NO));
        assert (ICTAXUtils.isValorNumber((String)String.valueOf(instrument.getValorNumber())));
        doc.add((IndexableField)new LongField("valorNumber", instrument.getValorNumber(), Field.Store.NO));
        String isin = instrument.getIsin();
        if (isin != null) {
            assert (ICTAXUtils.isISIN((String)instrument.getIsin()));
            doc.add((IndexableField)new StringField("ISIN", instrument.getIsin(), Field.Store.NO));
        }
        doc.add((IndexableField)new StringField("institutionIdentifier", instrument.getInstitutionIdentifier(), Field.Store.NO));
        doc.add((IndexableField)new TextField("institutionIdentifierTokenized", instrument.getInstitutionIdentifier(), Field.Store.NO));
        doc.add((IndexableField)new TextField("institutionIdentifierAppendixTokenized", instrument.getInstitutionIdentifier(), Field.Store.NO));
        indexWriter.addDocument((Iterable)doc);
    }

    public static void main(String[] args) throws Exception {
    }

    public void start() throws Exception {
    }
}

