/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.ictax;

import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrument;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrumentType;
import ch.dvbern.tax.ge.pp.ictax.ICTAXDataBase;
import ch.dvbern.tax.ge.pp.ictax.ICTAXDatabaseUnavailableException;
import ch.dvbern.tax.ge.pp.ictax.ICTAXUtils;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;

class ICTAXXMLDataBase
extends ICTAXDataBase {
    private final Map<String, BigDecimal> exchangeRateYearEndMap;
    private final IndexSearcher indexSearcher;
    private final IndexReader indexReader;
    private volatile boolean closed;

    ICTAXXMLDataBase(int year, Directory directory, Map<String, BigDecimal> exchangeRateYearEndMap) throws IOException {
        super(year);
        assert (directory != null && exchangeRateYearEndMap != null);
        this.indexReader = DirectoryReader.open((Directory)directory);
        this.indexSearcher = new IndexSearcher(this.indexReader);
        this.exchangeRateYearEndMap = exchangeRateYearEndMap;
    }

    @Nonnull
    public List<DvbTaxInstrument> lookup(@Nonnull DvbTaxInstrumentType type, @Nonnull String text) {
        ArrayList<DvbTaxInstrument> result;
        if (type == null) {
            throw new NullPointerException("Instrument type cannot be null.");
        }
        if (text == null) {
            throw new NullPointerException("Lookup text cannot be null.");
        }
        this.checkNotClosed();
        text = text.toLowerCase();
        BooleanQuery textQuery = new BooleanQuery();
        textQuery.setMinimumNumberShouldMatch(1);
        textQuery.add((Query)new PrefixQuery(new Term("institutionIdentifierTokenized", text)), BooleanClause.Occur.SHOULD);
        textQuery.add((Query)new PrefixQuery(new Term("institutionIdentifierAppendixTokenized", text)), BooleanClause.Occur.SHOULD);
        BooleanQuery query = new BooleanQuery();
        query.add((Query)NumericRangeQuery.newIntRange((String)"type", (Integer)type.ordinal(), (Integer)type.ordinal(), (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        query.add((Query)textQuery, BooleanClause.Occur.MUST);
        Sort sort = new Sort(new SortField("institutionIdentifier", SortField.Type.STRING));
        try {
            TopFieldDocs topDocs = this.indexSearcher.search((Query)query, 100, sort);
            result = new ArrayList<DvbTaxInstrument>(topDocs.totalHits);
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Document doc = this.indexReader.document(scoreDoc.doc);
                String xmlFragment = doc.getField("xmlFragment").stringValue();
                DvbTaxInstrument instrument = ICTAXUtils.unmarshall((String)xmlFragment, (DvbTaxInstrumentType)type);
                if (instrument == null) continue;
                result.add(instrument);
            }
        }
        catch (IOException e) {
            throw new ICTAXDatabaseUnavailableException("Failed to query index.", (Throwable)e);
        }
        return Collections.unmodifiableList(result);
    }

    public DvbTaxInstrument lookupNumber(@Nonnull DvbTaxInstrumentType type, @Nonnull String number) {
        if (type == null) {
            throw new NullPointerException("Type cannot be null.");
        }
        if (number == null) {
            throw new NullPointerException("Number cannot be null.");
        }
        this.checkNotClosed();
        BooleanQuery query = new BooleanQuery();
        if (ICTAXUtils.isValorNumber((String)number)) {
            long valorNumber = Long.parseLong(number);
            query.add((Query)NumericRangeQuery.newLongRange((String)"valorNumber", (Long)valorNumber, (Long)valorNumber, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        } else if (ICTAXUtils.isISIN((String)number)) {
            query.add((Query)new TermQuery(new Term("ISIN", number)), BooleanClause.Occur.MUST);
        } else {
            return null;
        }
        query.add((Query)NumericRangeQuery.newIntRange((String)"type", (Integer)type.ordinal(), (Integer)type.ordinal(), (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        try {
            TopDocs topDocs = this.indexSearcher.search((Query)query, 1);
            if (topDocs.totalHits == 0) {
                return null;
            }
            if (topDocs.totalHits > 1) {
                throw new InternalFailureException("Duplicate valor number found in index: " + number);
            }
            Document doc = this.indexReader.document(topDocs.scoreDocs[0].doc);
            String xmlFragment = doc.getField("xmlFragment").stringValue();
            return ICTAXUtils.unmarshall((String)xmlFragment, (DvbTaxInstrumentType)type);
        }
        catch (IOException e) {
            throw new ICTAXDatabaseUnavailableException("Failed to query index.", (Throwable)e);
        }
    }

    @Nullable
    public BigDecimal getExchangeRateYearEnd(@Nonnull String currency) {
        return this.exchangeRateYearEndMap.get(currency);
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new ICTAXDatabaseUnavailableException("Database has been closed.");
        }
    }

    void close() {
        this.closed = true;
        try {
            this.indexReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

