/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.gui;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import uk.org.okapibarcode.graphics.Color;
import uk.org.okapibarcode.gui.OkapiUI;
import uk.org.okapibarcode.output.PostScriptRenderer;
import uk.org.okapibarcode.output.SvgRenderer;

public class SaveImage {
    public void save(File file, JPanel panel) throws IOException {
        int i = file.getName().lastIndexOf(46);
        String extension = i > 0 ? file.getName().substring(i + 1).toLowerCase() : "png";
        Color paper = new Color(OkapiUI.paperColour.getRGB());
        Color ink = new Color(OkapiUI.inkColour.getRGB());
        switch (extension) {
            case "png": 
            case "gif": 
            case "jpg": 
            case "bmp": {
                int w = OkapiUI.symbol.getWidth() * OkapiUI.factor;
                int h = OkapiUI.symbol.getHeight() * OkapiUI.factor;
                BufferedImage bi = new BufferedImage(w, h, 2);
                panel.paint(bi.getGraphics());
                ImageIO.write((RenderedImage)bi, extension, file);
                break;
            }
            case "svg": {
                SvgRenderer svg = new SvgRenderer(new FileOutputStream(file), OkapiUI.factor, paper, ink, true);
                svg.render(OkapiUI.symbol);
                break;
            }
            case "eps": {
                PostScriptRenderer eps = new PostScriptRenderer(new FileOutputStream(file), OkapiUI.factor, paper, ink);
                eps.render(OkapiUI.symbol);
                break;
            }
            default: {
                System.out.println("Unsupported output format");
            }
        }
    }
}

