/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.graphics;

import java.util.Objects;

public final class Color {
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color BLUE = new Color(0, 0, 255);
    public final int red;
    public final int green;
    public final int blue;

    public Color(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public Color(int rgb) {
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
    }

    public Color(String rrggbb) {
        if (rrggbb.length() != 6) {
            throw new IllegalArgumentException("Invalid hex RRGGBB value: " + rrggbb);
        }
        for (int i = 0; i < rrggbb.length(); ++i) {
            char c = rrggbb.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            throw new IllegalArgumentException("Invalid hex RRGGBB value: " + rrggbb);
        }
        this.red = Integer.parseInt(rrggbb.substring(0, 2), 16);
        this.green = Integer.parseInt(rrggbb.substring(2, 4), 16);
        this.blue = Integer.parseInt(rrggbb.substring(4, 6), 16);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Color)) {
            return false;
        }
        Color c = (Color)other;
        return this.red == c.red && this.green == c.green && this.blue == c.blue;
    }

    public int hashCode() {
        return Objects.hash(this.red, this.green, this.blue);
    }

    public String toString() {
        return "Color[red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + "]";
    }
}

