/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.util.Locale;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.graphics.Rectangle;
import uk.org.okapibarcode.util.Arrays;

public class RoyalMail4State
extends Symbol {
    private static final String[] ROYAL_TABLE = new String[]{"TTFF", "TDAF", "TDFA", "DTAF", "DTFA", "DDAA", "TADF", "TFTF", "TFDA", "DATF", "DADA", "DFTA", "TAFD", "TFAD", "TFFT", "DAAD", "DAFT", "DFAT", "ATDF", "ADTF", "ADDA", "FTTF", "FTDA", "FDTA", "ATFD", "ADAD", "ADFT", "FTAD", "FTFT", "FDAT", "AADD", "AFTD", "AFDT", "FATD", "FADT", "FFTT"};
    private static final int[][] ROYAL_VALUES = new int[][]{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {2, 5}, {2, 0}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {3, 5}, {3, 0}, {4, 1}, {4, 2}, {4, 3}, {4, 4}, {4, 5}, {4, 0}, {5, 1}, {5, 2}, {5, 3}, {5, 4}, {5, 5}, {5, 0}, {0, 1}, {0, 2}, {0, 3}, {0, 4}, {0, 5}, {0, 0}};
    private static final char[] KR_SET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public RoyalMail4State() {
        this.humanReadableLocation = HumanReadableLocation.NONE;
    }

    @Override
    protected void encode() {
        this.content = this.content.toUpperCase(Locale.ENGLISH);
        if (!this.content.matches("[0-9A-Z]+")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        int top = 0;
        int bottom = 0;
        StringBuilder dest = new StringBuilder();
        dest.append('A');
        for (int i = 0; i < this.content.length(); ++i) {
            int index = Arrays.positionOf(this.content.charAt(i), KR_SET);
            dest.append(ROYAL_TABLE[index]);
            top += ROYAL_VALUES[index][0];
            bottom += ROYAL_VALUES[index][1];
        }
        int row = top % 6 - 1;
        int column = bottom % 6 - 1;
        if (row == -1) {
            row = 5;
        }
        if (column == -1) {
            column = 5;
        }
        int check = 6 * row + column;
        dest.append(ROYAL_TABLE[check]);
        this.infoLine("Check Digit: " + check);
        dest.append('F');
        this.infoLine("Encoding: " + dest);
        this.readable = "";
        this.pattern = new String[]{dest.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    @Override
    protected void plotSymbol() {
        int x = 0;
        boolean w = true;
        int y = 0;
        int h = 0;
        this.resetPlotElements();
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            switch (this.pattern[0].charAt(xBlock)) {
                case 'A': {
                    y = 0;
                    h = 5;
                    break;
                }
                case 'D': {
                    y = 3;
                    h = 5;
                    break;
                }
                case 'F': {
                    y = 0;
                    h = 8;
                    break;
                }
                case 'T': {
                    y = 3;
                    h = 2;
                }
            }
            Rectangle rect = new Rectangle(x, y, (double)w, h);
            this.rectangles.add(rect);
            x += 2;
        }
        this.symbol_width = this.pattern[0].length() * 2;
        this.symbol_height = 8;
    }
}

