/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;

public class Plessey
extends Symbol {
    private boolean checkDigitInHumanReadableText = true;
    private double moduleWidthRatio = 2.0;

    public void setCheckDigitInHumanReadableText(boolean checkDigitInHumanReadableText) {
        this.checkDigitInHumanReadableText = checkDigitInHumanReadableText;
    }

    public boolean getCheckDigitInHumanReadableText() {
        return this.checkDigitInHumanReadableText;
    }

    public void setModuleWidthRatio(double moduleWidthRatio) {
        this.moduleWidthRatio = moduleWidthRatio;
    }

    public double getModuleWidthRatio() {
        return this.moduleWidthRatio;
    }

    @Override
    protected void encode() {
        int i;
        if (!this.content.matches("[0-9A-F]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        int length = this.content.length();
        int maxExpectedLength = 8 + length * 8 + 16 + 3 + 8;
        StringBuilder intermediate = new StringBuilder(maxExpectedLength);
        intermediate.append("21211221");
        int[] bits = new int[4 * (length + 2)];
        String[] patterns = new String[]{"12", "21"};
        for (int i2 = 0; i2 < length; ++i2) {
            char c = this.content.charAt(i2);
            int n = Character.getNumericValue(c);
            intermediate.append(patterns[n >> 0 & 1]);
            intermediate.append(patterns[n >> 1 & 1]);
            intermediate.append(patterns[n >> 2 & 1]);
            intermediate.append(patterns[n >> 3 & 1]);
            bits[4 * i2 + 0] = n >> 0 & 1;
            bits[4 * i2 + 1] = n >> 1 & 1;
            bits[4 * i2 + 2] = n >> 2 & 1;
            bits[4 * i2 + 3] = n >> 3 & 1;
        }
        int[] generator = new int[]{1, 1, 1, 1, 0, 1, 0, 0, 1};
        for (i = 0; i < 4 * length; ++i) {
            if (bits[i] != 1) continue;
            for (int j = 0; j < 9; ++j) {
                int n = i + j;
                bits[n] = bits[n] ^ generator[j];
            }
        }
        for (i = bits.length - 8; i < bits.length; ++i) {
            intermediate.append(patterns[bits[i]]);
        }
        intermediate.append("201").append("21211212");
        assert (maxExpectedLength == intermediate.length());
        this.readable = this.content;
        if (this.checkDigitInHumanReadableText) {
            int i1 = bits[bits.length - 8] | bits[bits.length - 7] << 1 | bits[bits.length - 6] << 2 | bits[bits.length - 5] << 3;
            int i2 = bits[bits.length - 4] | bits[bits.length - 3] << 1 | bits[bits.length - 2] << 2 | bits[bits.length - 1] << 3;
            this.readable = this.readable + Integer.toHexString(i1).toUpperCase();
            this.readable = this.readable + Integer.toHexString(i2).toUpperCase();
        }
        this.pattern = new String[]{intermediate.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    @Override
    protected double getModuleWidth(int originalWidth) {
        if (originalWidth == 1) {
            return 1.0;
        }
        if (originalWidth == 0) {
            return 0.0;
        }
        return this.moduleWidthRatio;
    }
}

