/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.Code3Of9;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;

public class Pharmazentralnummer
extends Symbol {
    @Override
    protected void encode() {
        int len = this.content.length();
        if (len > 7) {
            throw OkapiInputException.inputTooLong();
        }
        if (!this.content.matches("[0-9]+")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        StringBuilder localstr = new StringBuilder();
        localstr.append('-');
        int zeroes = 7 - len + 1;
        for (int i = 1; i < zeroes; ++i) {
            localstr.append('0');
        }
        localstr.append(this.content);
        int count = 0;
        for (int i = 1; i < 8; ++i) {
            count += i * Character.getNumericValue(localstr.charAt(i));
        }
        int check_digit = count % 11;
        if (check_digit == 10) {
            throw new OkapiInputException("Not a valid PZN identifier, check digit is 10");
        }
        this.infoLine("Check Digit: " + check_digit);
        localstr.append((char)(check_digit + 48));
        Code3Of9 code39 = new Code3Of9();
        code39.setContent(localstr.toString());
        this.readable = "PZN" + localstr;
        this.pattern = new String[1];
        this.pattern[0] = code39.pattern[0];
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }
}

